/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.fileformats.cgm.commands;

import com.aspose.cad.fileformats.cgm.CgmFile;
import com.aspose.cad.fileformats.cgm.IBinaryReader;
import com.aspose.cad.fileformats.cgm.IBinaryWriter;
import com.aspose.cad.fileformats.cgm.IClearTextWriter;
import com.aspose.cad.fileformats.cgm.classes.CgmPoint;
import com.aspose.cad.fileformats.cgm.commands.Command;
import com.aspose.cad.fileformats.cgm.commands.CommandConstructorArguments;
import com.aspose.cad.fileformats.cgm.commands.i;
import com.aspose.cad.fileformats.cgm.enums.ClassCode;
import com.aspose.cad.internal.N.aX;
import com.aspose.cad.internal.N.g;
import com.aspose.cad.internal.tM.d;

public class PolyMarker
extends Command {
    private CgmPoint[] a;

    public final CgmPoint[] getPoints() {
        return this.a;
    }

    public final void setPoints(CgmPoint[] cgmPointArray) {
        this.a = cgmPointArray;
    }

    public PolyMarker(CgmFile cgmFile) {
        super(new CommandConstructorArguments(ClassCode.GraphicalPrimitiveElements, 3, cgmFile));
    }

    public PolyMarker(CgmFile cgmFile, CgmPoint[] cgmPointArray) {
        this(cgmFile);
        this.setPoints(cgmPointArray);
    }

    @Override
    public void readFromBinary(IBinaryReader iBinaryReader) {
        int n2 = iBinaryReader.getArguments().length / iBinaryReader.sizeOfPoint();
        this.setPoints(new CgmPoint[n2]);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.getPoints()[i2] = iBinaryReader.readPoint();
        }
    }

    @Override
    public void writeAsBinary(IBinaryWriter iBinaryWriter) {
        for (CgmPoint cgmPoint : this.getPoints()) {
            iBinaryWriter.writePoint(cgmPoint);
        }
    }

    @Override
    public void writeAsClearText(IClearTextWriter iClearTextWriter) {
        iClearTextWriter.write(" MARKER");
        for (CgmPoint cgmPoint : this.getPoints()) {
            iClearTextWriter.write(String.format(" %s", this.writePoint(cgmPoint)));
        }
        iClearTextWriter.writeLine(";");
    }

    @Override
    public String toString() {
        return "PolyMarker " + aX.a(", ", new d<CgmPoint>(CgmPoint.class, g.a(this.getPoints())).a(new i(this), String.class).i());
    }
}

