/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.fileformats.cgm.commands;

import com.aspose.cad.fileformats.cgm.CgmFile;
import com.aspose.cad.fileformats.cgm.IBinaryReader;
import com.aspose.cad.fileformats.cgm.IBinaryWriter;
import com.aspose.cad.fileformats.cgm.IClearTextWriter;
import com.aspose.cad.fileformats.cgm.classes.BezierCurve;
import com.aspose.cad.fileformats.cgm.classes.CgmPoint;
import com.aspose.cad.fileformats.cgm.commands.Command;
import com.aspose.cad.fileformats.cgm.commands.CommandConstructorArguments;
import com.aspose.cad.fileformats.cgm.commands.h;
import com.aspose.cad.fileformats.cgm.enums.ClassCode;
import com.aspose.cad.internal.N.aX;
import com.aspose.cad.internal.N.aq;
import com.aspose.cad.internal.N.av;
import com.aspose.cad.internal.N.g;
import com.aspose.cad.internal.tM.d;
import com.aspose.cad.system.collections.Generic.IGenericEnumerable;
import com.aspose.cad.system.collections.Generic.IGenericEnumerator;
import com.aspose.cad.system.collections.Generic.List;

public class PolyBezier
extends Command {
    private int a;
    private List<BezierCurve> b = new List();

    public final int getContinuityIndicator() {
        return this.a;
    }

    public final void setContinuityIndicator(int n2) {
        this.a = n2;
    }

    public final java.util.List<BezierCurve> getCurves() {
        return List.toJava(this.a());
    }

    public final List<BezierCurve> a() {
        return this.b;
    }

    public final void setCurves(java.util.List<BezierCurve> list) {
        this.a(List.fromJava(list));
    }

    public final void a(List<BezierCurve> list) {
        this.b = list;
    }

    public PolyBezier(CgmFile cgmFile) {
        super(new CommandConstructorArguments(ClassCode.GraphicalPrimitiveElements, 26, cgmFile));
    }

    public PolyBezier(CgmFile cgmFile, int n2, IGenericEnumerable<BezierCurve> iGenericEnumerable) {
        this(cgmFile);
        this.setContinuityIndicator(n2);
        this.a().addRange(iGenericEnumerable);
    }

    @Override
    public void readFromBinary(IBinaryReader iBinaryReader) {
        this.setContinuityIndicator(iBinaryReader.readIndex());
        if (this.getContinuityIndicator() == 1) {
            PolyBezier.assert_((iBinaryReader.getArguments().length - iBinaryReader.getCurrentArg()) / iBinaryReader.sizeOfPoint() % 4 == 0, "invalid PolyBezier args for _continuityIndicator {ContinuityIndicator}");
            int n2 = (iBinaryReader.getArguments().length - iBinaryReader.getCurrentArg()) / iBinaryReader.sizeOfPoint() / 4;
            for (int i2 = 0; i2 < n2; ++i2) {
                BezierCurve bezierCurve = new BezierCurve();
                bezierCurve.addItem(iBinaryReader.readPoint());
                bezierCurve.addItem(iBinaryReader.readPoint());
                bezierCurve.addItem(iBinaryReader.readPoint());
                bezierCurve.addItem(iBinaryReader.readPoint());
                this.a().addItem(bezierCurve);
            }
        } else if (this.getContinuityIndicator() == 2) {
            PolyBezier.assert_((iBinaryReader.getArguments().length - iBinaryReader.getCurrentArg() - 1) / iBinaryReader.sizeOfPoint() % 3 == 0, String.format("invalid PolyBezier args for _continuityIndicator %d", this.getContinuityIndicator()));
            int n3 = (iBinaryReader.getArguments().length - iBinaryReader.getCurrentArg() - 1) / iBinaryReader.sizeOfPoint() / 3;
            for (int i3 = 0; i3 < n3; ++i3) {
                BezierCurve bezierCurve = new BezierCurve();
                if (i3 == 0) {
                    bezierCurve.addItem(iBinaryReader.readPoint());
                }
                bezierCurve.addItem(iBinaryReader.readPoint());
                bezierCurve.addItem(iBinaryReader.readPoint());
                bezierCurve.addItem(iBinaryReader.readPoint());
                this.a().addItem(bezierCurve);
            }
        } else {
            iBinaryReader.unsupported(aX.a(new String[]{"unsupported continuity indicator ", av.b(this.getContinuityIndicator())}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeAsBinary(IBinaryWriter iBinaryWriter) {
        iBinaryWriter.writeIndex(this.getContinuityIndicator());
        IGenericEnumerator iGenericEnumerator = this.a().iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                BezierCurve bezierCurve = (BezierCurve)iGenericEnumerator.next();
                for (CgmPoint cgmPoint : bezierCurve) {
                    iBinaryWriter.writePoint(cgmPoint);
                }
            }
        }
        finally {
            if (com.aspose.cad.internal.eT.d.a(iGenericEnumerator, aq.class) != false) {
                ((aq)iGenericEnumerator).dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeAsClearText(IClearTextWriter iClearTextWriter) {
        iClearTextWriter.write(String.format(" POLYBEZIER %s", this.writeInt(this.getContinuityIndicator())));
        IGenericEnumerator iGenericEnumerator = this.a().iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                BezierCurve bezierCurve = (BezierCurve)iGenericEnumerator.next();
                String string = aX.a("", new d<CgmPoint>(CgmPoint.class, g.a(bezierCurve.toArray(new CgmPoint[0]))).a(new h(this), String.class).i());
                iClearTextWriter.write(string);
            }
        }
        finally {
            if (com.aspose.cad.internal.eT.d.a(iGenericEnumerator, aq.class) != false) {
                ((aq)iGenericEnumerator).dispose();
            }
        }
        iClearTextWriter.writeLine(";");
    }
}

