/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.fileformats.cgm.commands;

import com.aspose.cad.fileformats.cgm.CgmFile;
import com.aspose.cad.fileformats.cgm.IBinaryReader;
import com.aspose.cad.fileformats.cgm.IBinaryWriter;
import com.aspose.cad.fileformats.cgm.IClearTextWriter;
import com.aspose.cad.fileformats.cgm.commands.Command;
import com.aspose.cad.fileformats.cgm.commands.CommandConstructorArguments;
import com.aspose.cad.fileformats.cgm.enums.ClassCode;
import com.aspose.cad.internal.N.aX;
import com.aspose.cad.internal.N.av;

public class MetafileElementList
extends Command {
    public static final String DRAWINGSET = "DRAWINGSET";
    public static final String DRAWINGPLUS = "DRAWINGPLUS";
    public static final String VERSION_2 = "VERSION2";
    public static final String EXTDPRIM = "EXTDPRIM";
    public static final String VERSION_2_GKSM = "VERSION2GKSM";
    public static final String VERSION_3 = "VERSION3";
    public static final String VERSION_4 = "VERSION4";
    private String[] a;

    public MetafileElementList(CgmFile cgmFile) {
        super(new CommandConstructorArguments(ClassCode.MetafileDescriptorElements, 11, cgmFile));
    }

    public MetafileElementList(CgmFile cgmFile, String string) {
        this(cgmFile);
        this.a(new String[]{string});
    }

    @Override
    public void readFromBinary(IBinaryReader iBinaryReader) {
        int n2 = iBinaryReader.readInt();
        this.a(new String[n2]);
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = iBinaryReader.readIndex();
            int n4 = iBinaryReader.readIndex();
            if (n3 == -1) {
                switch (n4) {
                    case 0: {
                        this.getElements()[i2] = DRAWINGSET;
                        break;
                    }
                    case 1: {
                        this.getElements()[i2] = DRAWINGPLUS;
                        break;
                    }
                    case 2: {
                        this.getElements()[i2] = VERSION_2;
                        break;
                    }
                    case 3: {
                        this.getElements()[i2] = EXTDPRIM;
                        break;
                    }
                    case 4: {
                        this.getElements()[i2] = VERSION_2_GKSM;
                        break;
                    }
                    case 5: {
                        this.getElements()[i2] = VERSION_3;
                        break;
                    }
                    case 6: {
                        this.getElements()[i2] = VERSION_4;
                        break;
                    }
                    default: {
                        iBinaryReader.unsupported(aX.a(new String[]{"unsupported meta file elements set ", av.b(n4)}));
                        break;
                    }
                }
                continue;
            }
            this.getElements()[i2] = String.format(" (%d,%d)", n3, n4);
        }
    }

    @Override
    public void writeAsBinary(IBinaryWriter iBinaryWriter) {
        iBinaryWriter.writeInt(this.getElements().length);
        for (String string : this.getElements()) {
            if (DRAWINGSET.equals(string)) {
                iBinaryWriter.writeInt(-1);
                iBinaryWriter.writeInt(0);
                continue;
            }
            if (DRAWINGPLUS.equals(string)) {
                iBinaryWriter.writeInt(-1);
                iBinaryWriter.writeInt(1);
                continue;
            }
            if (VERSION_2.equals(string)) {
                iBinaryWriter.writeInt(-1);
                iBinaryWriter.writeInt(2);
                continue;
            }
            if (EXTDPRIM.equals(string)) {
                iBinaryWriter.writeInt(-1);
                iBinaryWriter.writeInt(3);
                continue;
            }
            if (VERSION_2_GKSM.equals(string)) {
                iBinaryWriter.writeInt(-1);
                iBinaryWriter.writeInt(4);
                continue;
            }
            if (VERSION_3.equals(string)) {
                iBinaryWriter.writeInt(-1);
                iBinaryWriter.writeInt(5);
                continue;
            }
            if (VERSION_4.equals(string)) {
                iBinaryWriter.writeInt(-1);
                iBinaryWriter.writeInt(6);
                continue;
            }
            String string2 = aX.c(aX.a(aX.a(string, "(", ""), ")", ""));
            int n2 = aX.h(string2, ",");
            iBinaryWriter.writeInt(av.a(aX.b(string2, 0, n2)));
            iBinaryWriter.writeInt(av.a(aX.e(string2, n2 + 1)));
        }
    }

    @Override
    public void writeAsClearText(IClearTextWriter iClearTextWriter) {
        iClearTextWriter.writeLine(String.format(" mfelemlist '%s';", aX.a("', '", this.getElements())));
    }

    @Override
    public String toString() {
        return aX.a(new String[]{"MetafileElementList ", aX.a(" ", this.getElements())});
    }

    public final String[] getElements() {
        return this.a;
    }

    private void a(String[] stringArray) {
        this.a = stringArray;
    }
}

