/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.fileformats.cgm.commands;

import com.aspose.cad.fileformats.cgm.CgmFile;
import com.aspose.cad.fileformats.cgm.IBinaryReader;
import com.aspose.cad.fileformats.cgm.IBinaryWriter;
import com.aspose.cad.fileformats.cgm.IClearTextWriter;
import com.aspose.cad.fileformats.cgm.commands.Command;
import com.aspose.cad.fileformats.cgm.commands.CommandConstructorArguments;
import com.aspose.cad.fileformats.cgm.enums.ClassCode;
import com.aspose.cad.internal.N.bE;
import com.aspose.cad.internal.aC.A;

public class LineAndEdgeTypeDefinition
extends Command {
    private int a;
    private double b;
    private int[] c;

    public final int getLineType() {
        return this.a;
    }

    public final void setLineType(int n2) {
        this.a = n2;
    }

    public final double getDashCycleRepeatLength() {
        return this.b;
    }

    public final void setDashCycleRepeatLength(double d2) {
        this.b = d2;
    }

    public final int[] getDashElements() {
        return this.c;
    }

    public final void setDashElements(int[] nArray) {
        this.c = nArray;
    }

    public LineAndEdgeTypeDefinition(CgmFile cgmFile) {
        super(new CommandConstructorArguments(ClassCode.PictureDescriptorElements, 17, cgmFile));
    }

    public LineAndEdgeTypeDefinition(CgmFile cgmFile, int n2, double d2, int[] nArray) {
        this(cgmFile);
        this.setLineType(n2);
        this.setDashCycleRepeatLength(d2);
        this.setDashElements(nArray);
    }

    @Override
    public void readFromBinary(IBinaryReader iBinaryReader) {
        this.setLineType(iBinaryReader.readIndex());
        LineAndEdgeTypeDefinition.assert_(this.getLineType() <= 0, String.format("invalid lineType %d. Should be negative.", this.getLineType()));
        this.setDashCycleRepeatLength(bE.a(iBinaryReader.readSizeSpecification(this._container.getLineWidthSpecificationMode())));
        this.setDashElements(new int[(iBinaryReader.getArguments().length - iBinaryReader.getCurrentArg()) / iBinaryReader.sizeOfInt()]);
        for (int i2 = 0; i2 < this.getDashElements().length; ++i2) {
            this.getDashElements()[i2] = iBinaryReader.readInt();
        }
    }

    @Override
    public void writeAsBinary(IBinaryWriter iBinaryWriter) {
        iBinaryWriter.writeIndex(this.getLineType());
        iBinaryWriter.writeSizeSpecification(this.getDashCycleRepeatLength(), this._container.getLineWidthSpecificationMode());
        for (int n2 : this.getDashElements()) {
            iBinaryWriter.writeInt(n2);
        }
    }

    @Override
    public String toString() {
        A a2 = new A();
        a2.a("LineAndEdgeTypeDefinition");
        a2.a(" lineType=").e(this.getLineType());
        a2.a(" dashCycleRepeatLength=").a(this.getDashCycleRepeatLength());
        a2.a(" [");
        for (int i2 = 0; i2 < this.getDashElements().length; ++i2) {
            a2.e(this.getDashElements()[i2]).a(",");
        }
        a2.a("]");
        return a2.toString();
    }

    @Override
    public void writeAsClearText(IClearTextWriter iClearTextWriter) {
        iClearTextWriter.write(String.format(" LINEEDGETYPEDEF %s %s", this.writeInt(this.getLineType()), this.writeVDC(this.getDashCycleRepeatLength())));
        for (int n2 : this.getDashElements()) {
            iClearTextWriter.write(String.format(" %s", this.writeInt(n2)));
        }
        iClearTextWriter.writeLine(";");
    }
}

