/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.fileformats.cgm.commands;

import com.aspose.cad.fileformats.cgm.CgmFile;
import com.aspose.cad.fileformats.cgm.IBinaryReader;
import com.aspose.cad.fileformats.cgm.IBinaryWriter;
import com.aspose.cad.fileformats.cgm.IClearTextWriter;
import com.aspose.cad.fileformats.cgm.commands.Command;
import com.aspose.cad.fileformats.cgm.commands.CommandConstructorArguments;
import com.aspose.cad.fileformats.cgm.enums.ClassCode;
import com.aspose.cad.fileformats.cgm.enums.SpecificationMode;
import com.aspose.cad.internal.N.aX;
import com.aspose.cad.internal.N.av;

public class InteriorStyleSpecificationMode
extends Command {
    private SpecificationMode a;

    public final SpecificationMode getMode() {
        return this.a;
    }

    public final void setMode(SpecificationMode specificationMode) {
        this.a = specificationMode;
    }

    public InteriorStyleSpecificationMode(CgmFile cgmFile) {
        super(new CommandConstructorArguments(ClassCode.PictureDescriptorElements, 16, cgmFile));
    }

    public InteriorStyleSpecificationMode(CgmFile cgmFile, SpecificationMode specificationMode) {
        this(cgmFile);
        this.setMode(specificationMode);
    }

    @Override
    public void readFromBinary(IBinaryReader iBinaryReader) {
        int n2 = iBinaryReader.readEnum();
        switch (n2) {
            case 0: {
                this.setMode(SpecificationMode.ABS);
                break;
            }
            case 1: {
                this.setMode(SpecificationMode.SCALED);
                break;
            }
            case 2: {
                this.setMode(SpecificationMode.FRACTIONAL);
                break;
            }
            case 3: {
                this.setMode(SpecificationMode.MM);
                break;
            }
            default: {
                this.setMode(SpecificationMode.ABS);
                iBinaryReader.unsupported(aX.a(new String[]{"unsupported specification mode ", av.b(n2)}));
            }
        }
        this._container.setInteriorStyleSpecificationMode(this.getMode());
    }

    @Override
    public void writeAsBinary(IBinaryWriter iBinaryWriter) {
        iBinaryWriter.writeEnum(this.getMode().ordinal());
        this._container.setInteriorStyleSpecificationMode(this.getMode());
    }

    @Override
    public void writeAsClearText(IClearTextWriter iClearTextWriter) {
        iClearTextWriter.writeLine(String.format(" INTSTYLEMODE %s;", InteriorStyleSpecificationMode.a(this.getMode().toString())));
    }

    @Override
    public String toString() {
        return String.format("InteriorStyleSpecificationMode mode=%s", InteriorStyleSpecificationMode.a(this.getMode().toString()));
    }
}

