/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.fileformats.cgm.commands;

import com.aspose.cad.fileformats.cgm.CgmFile;
import com.aspose.cad.fileformats.cgm.IBinaryReader;
import com.aspose.cad.fileformats.cgm.IBinaryWriter;
import com.aspose.cad.fileformats.cgm.IClearTextWriter;
import com.aspose.cad.fileformats.cgm.commands.Command;
import com.aspose.cad.fileformats.cgm.commands.CommandConstructorArguments;
import com.aspose.cad.fileformats.cgm.enums.ClassCode;

public class InteriorStyle
extends Command {
    private Style a;

    public final Style getValue() {
        return this.a;
    }

    public final void setValue(Style style) {
        this.a = style;
    }

    public InteriorStyle(CgmFile cgmFile) {
        super(new CommandConstructorArguments(ClassCode.AttributeElements, 22, cgmFile));
    }

    public InteriorStyle(CgmFile cgmFile, Style style) {
        this(cgmFile);
        this.setValue(style);
    }

    @Override
    public void readFromBinary(IBinaryReader iBinaryReader) {
        switch (iBinaryReader.readEnum()) {
            case 0: {
                this.setValue(Style.HOLLOW);
                break;
            }
            case 1: {
                this.setValue(Style.SOLID);
                break;
            }
            case 2: {
                this.setValue(Style.PATTERN);
                break;
            }
            case 3: {
                this.setValue(Style.HATCH);
                break;
            }
            case 4: {
                this.setValue(Style.EMPTY);
                break;
            }
            case 5: {
                this.setValue(Style.GEOMETRIC_PATTERN);
                break;
            }
            case 6: {
                this.setValue(Style.INTERPOLATED);
                break;
            }
            default: {
                this.setValue(Style.HOLLOW);
            }
        }
    }

    @Override
    public void writeAsBinary(IBinaryWriter iBinaryWriter) {
        iBinaryWriter.writeEnum(this.getValue().ordinal());
    }

    @Override
    public void writeAsClearText(IClearTextWriter iClearTextWriter) {
        iClearTextWriter.writeLine(String.format("  intstyle %s;", InteriorStyle.a(this.getValue().toString())));
    }

    public static enum Style {
        HOLLOW,
        SOLID,
        PATTERN,
        HATCH,
        EMPTY,
        GEOMETRIC_PATTERN,
        INTERPOLATED;

    }
}

