/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.fileformats.cgm.commands;

import com.aspose.cad.fileformats.cgm.CgmFile;
import com.aspose.cad.fileformats.cgm.IBinaryReader;
import com.aspose.cad.fileformats.cgm.IBinaryWriter;
import com.aspose.cad.fileformats.cgm.IClearTextWriter;
import com.aspose.cad.fileformats.cgm.commands.Command;
import com.aspose.cad.fileformats.cgm.commands.CommandConstructorArguments;
import com.aspose.cad.fileformats.cgm.enums.ClassCode;
import com.aspose.cad.internal.N.aX;
import com.aspose.cad.internal.N.av;
import com.aspose.cad.internal.N.bE;

public class IntegerPrecision
extends Command {
    private int a;

    public final int getPrecision() {
        return this.a;
    }

    public final void setPrecision(int n2) {
        this.a = n2;
    }

    public IntegerPrecision(CgmFile cgmFile) {
        super(new CommandConstructorArguments(ClassCode.MetafileDescriptorElements, 4, cgmFile));
    }

    public IntegerPrecision(CgmFile cgmFile, int n2) {
        this(cgmFile);
        this.setPrecision(n2);
        this.a();
    }

    @Override
    public void readFromBinary(IBinaryReader iBinaryReader) {
        this.setPrecision(iBinaryReader.readInt());
        this._container.setIntegerPrecision(this.getPrecision());
        this.a();
    }

    @Override
    public void writeAsBinary(IBinaryWriter iBinaryWriter) {
        iBinaryWriter.writeInt(this.getPrecision());
        this._container.setIntegerPrecision(this.getPrecision());
    }

    private void a() {
        IntegerPrecision.assert_(this.getPrecision() == 8 || this.getPrecision() == 16 || this.getPrecision() == 24 || this.getPrecision() == 32, "unsupported INTEGER PRECISION");
    }

    @Override
    public void writeAsClearText(IClearTextWriter iClearTextWriter) {
        double d2 = bE.f(2.0, (double)this.getPrecision()) / 2.0;
        iClearTextWriter.writeLine(String.format(" integerprec -%s, %s %% %d binary bits %%;", IntegerPrecision.writeDouble(d2), IntegerPrecision.writeDouble(d2 - 1.0), this.getPrecision()));
    }

    @Override
    public String toString() {
        return aX.a(new String[]{"IntegerPrecision ", av.b(this.getPrecision())});
    }
}

