/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.fileformats.cgm.commands;

import com.aspose.cad.fileformats.cgm.CgmFile;
import com.aspose.cad.fileformats.cgm.IBinaryReader;
import com.aspose.cad.fileformats.cgm.IBinaryWriter;
import com.aspose.cad.fileformats.cgm.IClearTextWriter;
import com.aspose.cad.fileformats.cgm.classes.StructuredDataRecord;
import com.aspose.cad.fileformats.cgm.commands.CharacterSetList;
import com.aspose.cad.fileformats.cgm.commands.Command;
import com.aspose.cad.fileformats.cgm.commands.CommandConstructorArguments;
import com.aspose.cad.fileformats.cgm.enums.ClassCode;

public class GlyphMapping
extends Command {
    private int a;
    private int b;
    private String c;
    private int d;
    private int e;
    private StructuredDataRecord f;

    public final int getCharacterSetIndex() {
        return this.a;
    }

    public final void setCharacterSetIndex(int n2) {
        this.a = n2;
    }

    public final int getType() {
        return this.b;
    }

    public final void setType(int n2) {
        this.b = n2;
    }

    public final String getSequenceTail() {
        return this.c;
    }

    public final void setSequenceTail(String string) {
        this.c = string;
    }

    public final int getOctetsPerCode() {
        return this.d;
    }

    public final void setOctetsPerCode(int n2) {
        this.d = n2;
    }

    public final int getGlyphSource() {
        return this.e;
    }

    public final void setGlyphSource(int n2) {
        this.e = n2;
    }

    public final StructuredDataRecord getCodeAssocs() {
        return this.f;
    }

    public final void setCodeAssocs(StructuredDataRecord structuredDataRecord) {
        this.f = structuredDataRecord;
    }

    public GlyphMapping(CgmFile cgmFile) {
        super(new CommandConstructorArguments(ClassCode.MetafileDescriptorElements, 22, cgmFile));
    }

    public GlyphMapping(CgmFile cgmFile, int n2, int n3, String string, int n4, int n5, StructuredDataRecord structuredDataRecord) {
        this(cgmFile);
        this.setCharacterSetIndex(n2);
        this.setType(n3);
        this.setSequenceTail(string);
        this.setOctetsPerCode(n4);
        this.setGlyphSource(n5);
        this.setCodeAssocs(structuredDataRecord);
    }

    @Override
    public void readFromBinary(IBinaryReader iBinaryReader) {
        this.setCharacterSetIndex(iBinaryReader.readIndex());
        this.setType(iBinaryReader.readEnum());
        this.setSequenceTail(iBinaryReader.readFixedString());
        this.setOctetsPerCode(iBinaryReader.readInt());
        this.setGlyphSource(iBinaryReader.readIndex());
        this.setCodeAssocs(iBinaryReader.readSDR());
    }

    @Override
    public void writeAsBinary(IBinaryWriter iBinaryWriter) {
        iBinaryWriter.writeIndex(this.getCharacterSetIndex());
        iBinaryWriter.writeEnum(this.getType());
        iBinaryWriter.writeFixedString(this.getSequenceTail());
        iBinaryWriter.writeInt(this.getOctetsPerCode());
        iBinaryWriter.writeIndex(this.getGlyphSource());
        iBinaryWriter.writeSDR(this.getCodeAssocs());
    }

    @Override
    public void writeAsClearText(IClearTextWriter iClearTextWriter) {
        iClearTextWriter.write(String.format("  GLYPHMAP %s %s %s %s", this.writeIndex(this.getCharacterSetIndex()), this.writeEnum(CharacterSetList.Type.class, this.getType()), this.writeIndex(this.getOctetsPerCode()), this.writeIndex(this.getGlyphSource())));
        this.writeSDR(iClearTextWriter, this.getCodeAssocs());
        iClearTextWriter.writeLine(";");
    }
}

