/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.fileformats.cgm.commands;

import com.aspose.cad.fileformats.cgm.CgmFile;
import com.aspose.cad.fileformats.cgm.IBinaryReader;
import com.aspose.cad.fileformats.cgm.IBinaryWriter;
import com.aspose.cad.fileformats.cgm.IClearTextWriter;
import com.aspose.cad.fileformats.cgm.classes.CgmPoint;
import com.aspose.cad.fileformats.cgm.commands.Command;
import com.aspose.cad.fileformats.cgm.commands.CommandConstructorArguments;
import com.aspose.cad.fileformats.cgm.enums.ClassCode;

public class GeometricPatternDefinition
extends Command {
    private int a;
    private int b;
    private CgmPoint c;
    private CgmPoint d;

    public final int getPatternIndex() {
        return this.a;
    }

    public final void setPatternIndex(int n2) {
        this.a = n2;
    }

    public final int getIdentifier() {
        return this.b;
    }

    public final void setIdentifier(int n2) {
        this.b = n2;
    }

    public final CgmPoint getFirstCorner() {
        return this.c;
    }

    public final void setFirstCorner(CgmPoint cgmPoint) {
        this.c = cgmPoint;
    }

    public final CgmPoint getSecondCorner() {
        return this.d;
    }

    public final void setSecondCorner(CgmPoint cgmPoint) {
        this.d = cgmPoint;
    }

    public GeometricPatternDefinition(CgmFile cgmFile) {
        super(new CommandConstructorArguments(ClassCode.PictureDescriptorElements, 19, cgmFile));
    }

    public GeometricPatternDefinition(CgmFile cgmFile, int n2, int n3, CgmPoint cgmPoint, CgmPoint cgmPoint2) {
        this(cgmFile);
        this.setPatternIndex(n2);
        this.setIdentifier(n3);
        this.setFirstCorner(cgmPoint);
        this.setSecondCorner(cgmPoint2);
    }

    @Override
    public void readFromBinary(IBinaryReader iBinaryReader) {
        this.setPatternIndex(iBinaryReader.readIndex());
        this.setIdentifier(iBinaryReader.readName());
        this.setFirstCorner(iBinaryReader.readPoint());
        this.setSecondCorner(iBinaryReader.readPoint());
    }

    @Override
    public void writeAsBinary(IBinaryWriter iBinaryWriter) {
        iBinaryWriter.writeIndex(this.getPatternIndex());
        iBinaryWriter.writeName(this.getIdentifier());
        iBinaryWriter.writePoint(this.getFirstCorner());
        iBinaryWriter.writePoint(this.getSecondCorner());
    }

    @Override
    public void writeAsClearText(IClearTextWriter iClearTextWriter) {
        iClearTextWriter.writeLine(String.format("  GEOPATDEF %s %s %s %s;", this.writeIndex(this.getPatternIndex()), this.writeName(this.getIdentifier()), this.writePoint(this.getFirstCorner()), this.writePoint(this.getSecondCorner())));
    }
}

