/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.fileformats.cgm.commands;

import com.aspose.cad.fileformats.cgm.CgmFile;
import com.aspose.cad.fileformats.cgm.IBinaryReader;
import com.aspose.cad.fileformats.cgm.IBinaryWriter;
import com.aspose.cad.fileformats.cgm.IClearTextWriter;
import com.aspose.cad.fileformats.cgm.commands.Command;
import com.aspose.cad.fileformats.cgm.commands.CommandConstructorArguments;
import com.aspose.cad.fileformats.cgm.enums.ClassCode;

public class DeviceViewportMapping
extends Command {
    private Isotropy a;
    private Horizontalalignment b;
    private Verticalalignment c;

    public final Isotropy getIsotropyValue() {
        return this.a;
    }

    public final void setIsotropyValue(Isotropy isotropy) {
        this.a = isotropy;
    }

    public final Horizontalalignment getHorizontalAlignment() {
        return this.b;
    }

    public final void setHorizontalAlignment(Horizontalalignment horizontalalignment) {
        this.b = horizontalalignment;
    }

    public final Verticalalignment getVerticalAlignment() {
        return this.c;
    }

    public final void setVerticalAlignment(Verticalalignment verticalalignment) {
        this.c = verticalalignment;
    }

    public DeviceViewportMapping(CgmFile cgmFile) {
        super(new CommandConstructorArguments(ClassCode.PictureDescriptorElements, 10, cgmFile));
    }

    public DeviceViewportMapping(CgmFile cgmFile, Isotropy isotropy, Horizontalalignment horizontalalignment, Verticalalignment verticalalignment) {
        this(cgmFile);
        this.setIsotropyValue(isotropy);
        this.setHorizontalAlignment(horizontalalignment);
        this.setVerticalAlignment(verticalalignment);
    }

    @Override
    public void readFromBinary(IBinaryReader iBinaryReader) {
        this.setIsotropyValue(Isotropy.values()[iBinaryReader.readEnum()]);
        this.setHorizontalAlignment(Horizontalalignment.values()[iBinaryReader.readEnum()]);
        this.setVerticalAlignment(Verticalalignment.values()[iBinaryReader.readEnum()]);
    }

    @Override
    public void writeAsBinary(IBinaryWriter iBinaryWriter) {
        iBinaryWriter.writeEnum(this.getIsotropyValue().ordinal());
        iBinaryWriter.writeEnum(this.getHorizontalAlignment().ordinal());
        iBinaryWriter.writeEnum(this.getVerticalAlignment().ordinal());
    }

    @Override
    public void writeAsClearText(IClearTextWriter iClearTextWriter) {
        iClearTextWriter.writeLine(String.format(" DEVVPMAP %s %s %s;", DeviceViewportMapping.a(this.getIsotropyValue().toString()), DeviceViewportMapping.a(this.getHorizontalAlignment().toString()), DeviceViewportMapping.a(this.getVerticalAlignment().toString())));
    }

    public static enum Verticalalignment {
        BOTTOM,
        CTR,
        TOP;

    }

    public static enum Horizontalalignment {
        LEFT,
        CTR,
        RIGHT;

    }

    public static enum Isotropy {
        NOTFORCED,
        FORCED;

    }
}

