/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.fileformats.cgm.commands;

import com.aspose.cad.fileformats.cgm.CgmFile;
import com.aspose.cad.fileformats.cgm.IBinaryReader;
import com.aspose.cad.fileformats.cgm.IBinaryWriter;
import com.aspose.cad.fileformats.cgm.IClearTextWriter;
import com.aspose.cad.fileformats.cgm.commands.Command;
import com.aspose.cad.fileformats.cgm.commands.CommandConstructorArguments;
import com.aspose.cad.fileformats.cgm.enums.ClassCode;
import com.aspose.cad.internal.Exceptions.NotSupportedException;
import com.aspose.cad.internal.N.aX;
import com.aspose.cad.internal.N.av;

public class CharacterCodingAnnouncer
extends Command {
    private Type a;

    public final Type getValue() {
        return this.a;
    }

    private void a(Type type) {
        this.a = type;
    }

    public CharacterCodingAnnouncer(CgmFile cgmFile) {
        super(new CommandConstructorArguments(ClassCode.MetafileDescriptorElements, 15, cgmFile));
    }

    public CharacterCodingAnnouncer(CgmFile cgmFile, Type type) {
        this(cgmFile);
        this.a(type);
    }

    @Override
    public void readFromBinary(IBinaryReader iBinaryReader) {
        int n2 = iBinaryReader.readEnum();
        switch (n2) {
            case 0: {
                this.a(Type.BASIC_7_BIT);
                break;
            }
            case 1: {
                this.a(Type.BASIC_8_BIT);
                break;
            }
            case 2: {
                this.a(Type.EXTENDED_7_BIT);
                break;
            }
            case 3: {
                this.a(Type.EXTENDED_8_BIT);
                break;
            }
            default: {
                iBinaryReader.unsupported(aX.a(new String[]{"unsupported character coding type ", av.b(n2)}));
                this.a(Type.BASIC_7_BIT);
            }
        }
    }

    @Override
    public void writeAsBinary(IBinaryWriter iBinaryWriter) {
        iBinaryWriter.writeEnum(this.getValue().ordinal());
    }

    @Override
    public void writeAsClearText(IClearTextWriter iClearTextWriter) {
        switch (this.getValue()) {
            case BASIC_7_BIT: {
                iClearTextWriter.writeLine(" charcoding BASIC7BIT;");
                break;
            }
            case BASIC_8_BIT: {
                iClearTextWriter.writeLine(" charcoding BASIC8BIT;");
                break;
            }
            case EXTENDED_7_BIT: {
                iClearTextWriter.writeLine(" charcoding EXTD7BIT;");
                break;
            }
            case EXTENDED_8_BIT: {
                iClearTextWriter.writeLine(" charcoding EXTD8BIT;");
                break;
            }
            default: {
                throw new NotSupportedException(String.format("CharacterCoding %s not supported.", this.getValue().toString()));
            }
        }
    }

    @Override
    public String toString() {
        return String.format("CharacterCodingAnnouncer type=%s", this.getValue().toString());
    }

    public static enum Type {
        BASIC_7_BIT,
        BASIC_8_BIT,
        EXTENDED_7_BIT,
        EXTENDED_8_BIT;

    }
}

