/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.jcajce.provider.asymmetric.dsa;

import com.aspose.cad.internal.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.aspose.cad.internal.bouncycastle.crypto.digests.SHA256Digest;
import com.aspose.cad.internal.bouncycastle.crypto.generators.DSAKeyPairGenerator;
import com.aspose.cad.internal.bouncycastle.crypto.generators.DSAParametersGenerator;
import com.aspose.cad.internal.bouncycastle.crypto.params.DSAKeyGenerationParameters;
import com.aspose.cad.internal.bouncycastle.crypto.params.DSAParameterGenerationParameters;
import com.aspose.cad.internal.bouncycastle.crypto.params.DSAParameters;
import com.aspose.cad.internal.bouncycastle.crypto.params.DSAPrivateKeyParameters;
import com.aspose.cad.internal.bouncycastle.crypto.params.DSAPublicKeyParameters;
import com.aspose.cad.internal.bouncycastle.jcajce.provider.asymmetric.dsa.BCDSAPrivateKey;
import com.aspose.cad.internal.bouncycastle.jcajce.provider.asymmetric.dsa.BCDSAPublicKey;
import com.aspose.cad.internal.bouncycastle.jcajce.provider.asymmetric.util.PrimeCertaintyCalculator;
import com.aspose.cad.internal.bouncycastle.util.Integers;
import com.aspose.cad.internal.bouncycastle.util.Properties;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.util.Hashtable;

public class KeyPairGeneratorSpi
extends KeyPairGenerator {
    private static Hashtable a = new Hashtable();
    private static Object b = new Object();
    DSAKeyGenerationParameters param;
    DSAKeyPairGenerator engine = new DSAKeyPairGenerator();
    int strength = 2048;
    SecureRandom random = new SecureRandom();
    boolean initialised = false;

    public KeyPairGeneratorSpi() {
        super("DSA");
    }

    @Override
    public void initialize(int n2, SecureRandom secureRandom) {
        if (n2 < 512 || n2 > 4096 || n2 < 1024 && n2 % 64 != 0 || n2 >= 1024 && n2 % 1024 != 0) {
            throw new InvalidParameterException("strength must be from 512 - 4096 and a multiple of 1024 above 1024");
        }
        this.strength = n2;
        this.random = secureRandom;
        this.initialised = false;
    }

    @Override
    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof DSAParameterSpec)) {
            throw new InvalidAlgorithmParameterException("parameter object not a DSAParameterSpec");
        }
        DSAParameterSpec dSAParameterSpec = (DSAParameterSpec)algorithmParameterSpec;
        this.param = new DSAKeyGenerationParameters(secureRandom, new DSAParameters(dSAParameterSpec.getP(), dSAParameterSpec.getQ(), dSAParameterSpec.getG()));
        this.engine.init(this.param);
        this.initialised = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeyPair generateKeyPair() {
        Object object;
        Object object2;
        Object object3;
        if (!this.initialised) {
            object3 = Integers.valueOf(this.strength);
            if (a.containsKey(object3)) {
                this.param = (DSAKeyGenerationParameters)a.get(object3);
            } else {
                object2 = b;
                synchronized (object2) {
                    if (a.containsKey(object3)) {
                        this.param = (DSAKeyGenerationParameters)a.get(object3);
                    } else {
                        int n2 = PrimeCertaintyCalculator.getDefaultCertainty(this.strength);
                        if (this.strength == 1024) {
                            object = new DSAParametersGenerator();
                            if (Properties.isOverrideSet("com.aspose.cad.internal.bouncycastle.dsa.FIPS186-2for1024bits")) {
                                ((DSAParametersGenerator)object).init(this.strength, n2, this.random);
                            } else {
                                DSAParameterGenerationParameters dSAParameterGenerationParameters = new DSAParameterGenerationParameters(1024, 160, n2, this.random);
                                ((DSAParametersGenerator)object).init(dSAParameterGenerationParameters);
                            }
                        } else if (this.strength > 1024) {
                            DSAParameterGenerationParameters dSAParameterGenerationParameters = new DSAParameterGenerationParameters(this.strength, 256, n2, this.random);
                            object = new DSAParametersGenerator(new SHA256Digest());
                            ((DSAParametersGenerator)object).init(dSAParameterGenerationParameters);
                        } else {
                            object = new DSAParametersGenerator();
                            ((DSAParametersGenerator)object).init(this.strength, n2, this.random);
                        }
                        this.param = new DSAKeyGenerationParameters(this.random, ((DSAParametersGenerator)object).generateParameters());
                        a.put(object3, this.param);
                    }
                }
            }
            this.engine.init(this.param);
            this.initialised = true;
        }
        object3 = this.engine.generateKeyPair();
        object2 = (DSAPublicKeyParameters)((AsymmetricCipherKeyPair)object3).getPublic();
        object = (DSAPrivateKeyParameters)((AsymmetricCipherKeyPair)object3).getPrivate();
        return new KeyPair(new BCDSAPublicKey((DSAPublicKeyParameters)object2), new BCDSAPrivateKey((DSAPrivateKeyParameters)object));
    }
}

