/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.crypto.agreement;

import com.aspose.cad.internal.bouncycastle.crypto.BasicAgreement;
import com.aspose.cad.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.cad.internal.bouncycastle.crypto.params.ECDomainParameters;
import com.aspose.cad.internal.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.aspose.cad.internal.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.aspose.cad.internal.bouncycastle.math.ec.ECPoint;
import java.math.BigInteger;

public class ECDHCBasicAgreement
implements BasicAgreement {
    ECPrivateKeyParameters key;

    @Override
    public void init(CipherParameters cipherParameters) {
        this.key = (ECPrivateKeyParameters)cipherParameters;
    }

    @Override
    public int getFieldSize() {
        return (this.key.getParameters().getCurve().getFieldSize() + 7) / 8;
    }

    @Override
    public BigInteger calculateAgreement(CipherParameters cipherParameters) {
        ECPublicKeyParameters eCPublicKeyParameters = (ECPublicKeyParameters)cipherParameters;
        ECDomainParameters eCDomainParameters = eCPublicKeyParameters.getParameters();
        if (!eCDomainParameters.equals(this.key.getParameters())) {
            throw new IllegalStateException("ECDHC public key has wrong domain parameters");
        }
        BigInteger bigInteger = eCDomainParameters.getH().multiply(this.key.getD()).mod(eCDomainParameters.getN());
        ECPoint eCPoint = eCPublicKeyParameters.getQ().multiply(bigInteger).normalize();
        if (eCPoint.isInfinity()) {
            throw new IllegalStateException("Infinity is not a valid agreement value for ECDHC");
        }
        return eCPoint.getAffineXCoord().toBigInteger();
    }
}

