/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.asn1.cms;

import com.aspose.cad.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Integer;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1OctetString;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1TaggedObject;
import com.aspose.cad.internal.bouncycastle.asn1.DERSequence;
import com.aspose.cad.internal.bouncycastle.asn1.DERTaggedObject;
import com.aspose.cad.internal.bouncycastle.asn1.cms.OriginatorIdentifierOrKey;
import com.aspose.cad.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class KeyAgreeRecipientInfo
extends ASN1Object {
    private ASN1Integer a;
    private OriginatorIdentifierOrKey b;
    private ASN1OctetString c;
    private AlgorithmIdentifier d;
    private ASN1Sequence e;

    public KeyAgreeRecipientInfo(OriginatorIdentifierOrKey originatorIdentifierOrKey, ASN1OctetString aSN1OctetString, AlgorithmIdentifier algorithmIdentifier, ASN1Sequence aSN1Sequence) {
        this.a = new ASN1Integer(3L);
        this.b = originatorIdentifierOrKey;
        this.c = aSN1OctetString;
        this.d = algorithmIdentifier;
        this.e = aSN1Sequence;
    }

    public KeyAgreeRecipientInfo(ASN1Sequence aSN1Sequence) {
        int n2 = 0;
        this.a = (ASN1Integer)aSN1Sequence.getObjectAt(n2++);
        this.b = OriginatorIdentifierOrKey.getInstance((ASN1TaggedObject)aSN1Sequence.getObjectAt(n2++), true);
        if (aSN1Sequence.getObjectAt(n2) instanceof ASN1TaggedObject) {
            this.c = ASN1OctetString.getInstance((ASN1TaggedObject)aSN1Sequence.getObjectAt(n2++), true);
        }
        this.d = AlgorithmIdentifier.getInstance(aSN1Sequence.getObjectAt(n2++));
        this.e = (ASN1Sequence)aSN1Sequence.getObjectAt(n2++);
    }

    public static KeyAgreeRecipientInfo getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl2) {
        return KeyAgreeRecipientInfo.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl2));
    }

    public static KeyAgreeRecipientInfo getInstance(Object object) {
        if (object instanceof KeyAgreeRecipientInfo) {
            return (KeyAgreeRecipientInfo)object;
        }
        if (object != null) {
            return new KeyAgreeRecipientInfo(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public ASN1Integer getVersion() {
        return this.a;
    }

    public OriginatorIdentifierOrKey getOriginator() {
        return this.b;
    }

    public ASN1OctetString getUserKeyingMaterial() {
        return this.c;
    }

    public AlgorithmIdentifier getKeyEncryptionAlgorithm() {
        return this.d;
    }

    public ASN1Sequence getRecipientEncryptedKeys() {
        return this.e;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(new DERTaggedObject(true, 0, this.b));
        if (this.c != null) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 1, this.c));
        }
        aSN1EncodableVector.add(this.d);
        aSN1EncodableVector.add(this.e);
        return new DERSequence(aSN1EncodableVector);
    }
}

