/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.barcode.complexbarcode;

import com.aspose.barcode.BarCodeException;
import com.aspose.barcode.complexbarcode.HIBCLICDateFormat;
import com.aspose.barcode.internal.bbf.tt;
import com.aspose.barcode.internal.bbr.aad;
import com.aspose.barcode.internal.bbr.hhq;
import com.aspose.barcode.internal.bbr.kke;
import com.aspose.barcode.internal.bbr.llq;
import com.aspose.barcode.internal.oot.ii;
import com.aspose.barcode.internal.qqr.rr;
import java.util.Calendar;
import java.util.Date;

public class SecondaryAndAdditionalData {
    private HIBCLICDateFormat a;
    private Date b = new Date(0L);
    private String c;
    private String d;
    private Date e = new Date(0L);
    private int f = -1;

    public HIBCLICDateFormat getExpiryDateFormat() {
        return this.a;
    }

    public void setExpiryDateFormat(HIBCLICDateFormat value) {
        this.a = value;
    }

    public Date getExpiryDate() {
        return this.b;
    }

    public void setExpiryDate(Date value) {
        this.b = value;
    }

    public String getLotNumber() {
        return this.c;
    }

    public void setLotNumber(String value) {
        if (kke.b(value)) {
            this.c = value;
            return;
        }
        if (value.length() > 18) {
            throw new BarCodeException("Lot/batch number must be up to 18 sybmols length.");
        }
        if (!rr.b(value, true)) {
            throw new BarCodeException("Lot/batch number must be alphanumeric string.");
        }
        this.c = value;
    }

    public String getSerialNumber() {
        return this.d;
    }

    public void setSerialNumber(String value) {
        if (kke.b(value)) {
            this.d = value;
            return;
        }
        if (value.length() > 18) {
            throw new BarCodeException("Lot/batch number must be up to 18 sybmols length.");
        }
        if (!rr.b(value, true)) {
            throw new BarCodeException("Lot/batch number must be alphanumeric string.");
        }
        this.d = value;
    }

    public Date getDateOfManufacture() {
        return this.e;
    }

    public void setDateOfManufacture(Date value) {
        this.e = value;
    }

    public int getQuantity() {
        return this.f;
    }

    public void setQuantity(int value) {
        if (value < -1 || value > 500) {
            throw new BarCodeException("Quantity must be integer value from 0 to 500. Also it can be set to -1 in order not to use this field.");
        }
        this.f = value;
    }

    public String toString() {
        if (kke.b(this.getLotNumber()) && kke.b(this.getSerialNumber())) {
            throw new BarCodeException("Lot/batch or serial number must be provided.");
        }
        String string = "$$";
        if (kke.b(this.getLotNumber())) {
            string = kke.a(string, "+");
        }
        string = kke.a(string, this.a());
        string = kke.b(this.getLotNumber()) ? kke.a(string, this.getSerialNumber()) : kke.a(string, this.getLotNumber());
        if (!kke.b(this.getLotNumber()) && !kke.b(this.getSerialNumber())) {
            string = kke.a(string, kke.a(new String[]{"/S", this.getSerialNumber()}));
        }
        if (this.getExpiryDateFormat() == HIBCLICDateFormat.YYYYMMDD) {
            string = kke.a(string, kke.a(new String[]{"/14D", aad.a(this.getExpiryDate()).b("yyyyMMdd")}));
        }
        if (aad.h(aad.a(this.getDateOfManufacture()), aad.a(new Date(aad.d.z())))) {
            string = kke.a(string, kke.a(new String[]{"/16D", aad.a(this.getDateOfManufacture()).b("yyyyMMdd")}));
        }
        if (this.getQuantity() >= 0) {
            string = kke.a(string, kke.a(new String[]{"/Q", llq.b(this.getQuantity())}));
        }
        return string;
    }

    private String a() {
        String[] stringArray = new String[]{"yyyyMMdd", "MMyy", "MMddyy", "yyMMdd", "yyMMddHH"};
        String string = llq.b(this.getExpiryDateFormat().getValue());
        switch (this.getExpiryDateFormat()) {
            case MMYY: {
                return aad.a(this.getExpiryDate()).b("MMyy");
            }
            case NONE: {
                return string;
            }
            case YYJJJ: {
                return kke.a(new String[]{string, aad.a(this.getExpiryDate()).b("yy"), llq.b(aad.a(this.getExpiryDate()).h())});
            }
            case YYJJJHH: {
                return kke.a(string, aad.a(this.getExpiryDate()).b("yy"), llq.b(aad.a(this.getExpiryDate()).h()), aad.a(this.getExpiryDate()).b("HH"));
            }
            case MMDDYY: 
            case YYMMDD: 
            case YYMMDDHH: {
                return kke.a(new String[]{string, aad.a(this.getExpiryDate()).b(stringArray[this.getExpiryDateFormat().getValue()])});
            }
            case YYYYMMDD: {
                return llq.b(HIBCLICDateFormat.NONE.getValue());
            }
        }
        throw new BarCodeException("Unknown date format");
    }

    public void parseFromString(String secondaryDataCodetext) {
        String[] stringArray = kke.a(secondaryDataCodetext, '/');
        this.a(stringArray[0]);
        this.a(stringArray);
    }

    private void a(String string) {
        if (kke.b(string, "$+")) {
            this.setExpiryDateFormat(HIBCLICDateFormat.NONE);
            if (string.length() < 3) {
                throw new BarCodeException("Incorrect encoded serial number.");
            }
            this.setSerialNumber(kke.b(string, 2, string.length() - 2));
            return;
        }
        if (kke.b(string, "$") && (rr.a(string.charAt(1)) || rr.b(string.charAt(1)))) {
            this.setExpiryDateFormat(HIBCLICDateFormat.NONE);
            if (string.length() < 2) {
                throw new BarCodeException("Incorrect encoded lot/batch number.");
            }
            this.setLotNumber(kke.b(string, 1, string.length() - 1));
            return;
        }
        if (string.charAt(0) != '$') {
            this.setExpiryDateFormat(HIBCLICDateFormat.YYJJJ);
            Date date = new Date(this.a(string, 1, this.getExpiryDateFormat()).z());
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.set(11, calendar.get(11) - 2);
            this.setExpiryDate(calendar.getTime());
            if (string.length() > 5) {
                this.setLotNumber(kke.b(string, 5, string.length() - 5));
            }
            return;
        }
        int n = string.charAt(2) == '+' ? 3 : 2;
        this.setExpiryDateFormat(this.a(string, n));
        int n2 = this.getExpiryDateFormat() == HIBCLICDateFormat.MMYY ? n : n + 1;
        Date date = new Date(this.a(string, n2, this.getExpiryDateFormat()).z());
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, calendar.get(11) - 2);
        this.setExpiryDate(calendar.getTime());
        int n3 = this.getExpiryDateFormat() == HIBCLICDateFormat.NONE ? n2 : n2 + this.getExpiryDateFormat().name().length();
        String string2 = kke.d(string, n3);
        if ("".equals(string2)) {
            throw new BarCodeException("Incorrect encoded serial or lot/batch number.");
        }
        if (string.charAt(2) == '+') {
            this.setSerialNumber(string2);
        } else {
            this.setLotNumber(string2);
        }
    }

    private void a(String[] stringArray) {
        for (int i = 1; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string.charAt(0) == 'Q') {
                this.setQuantity(llq.a(kke.d(string, 1)));
                continue;
            }
            if (string.charAt(0) == 'S') {
                this.setSerialNumber(kke.d(string, 1));
                continue;
            }
            if (kke.b(string, "16D")) {
                this.setDateOfManufacture(new Date(this.a(string, 3, HIBCLICDateFormat.YYYYMMDD).z()));
                continue;
            }
            if (kke.b(string, "14D")) {
                this.setExpiryDateFormat(HIBCLICDateFormat.YYYYMMDD);
                Date date = new Date(this.a(string, 3, HIBCLICDateFormat.YYYYMMDD).z());
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                calendar.set(11, calendar.get(11) - 2);
                this.setExpiryDate(calendar.getTime());
                continue;
            }
            throw new BarCodeException("Unknown additional supplemental data format");
        }
    }

    private HIBCLICDateFormat a(String string, int n) {
        if (string.charAt(n) == '0' || string.charAt(n) == '1') {
            return HIBCLICDateFormat.MMYY;
        }
        int n2 = 0;
        int[] nArray = new int[]{n2};
        boolean bl = !llq.a(kke.b(string, n, 1), nArray);
        n2 = nArray[0];
        if (bl) {
            throw new BarCodeException("Incorrect encoded date format");
        }
        return HIBCLICDateFormat.values()[n2];
    }

    private aad a(String string, int n, HIBCLICDateFormat hIBCLICDateFormat) {
        String[] stringArray = new String[]{"yyyyMMdd", "MMyy", "MMddyy", "yyMMdd", "yyMMddHH"};
        if (hIBCLICDateFormat == HIBCLICDateFormat.NONE) {
            return aad.d;
        }
        if (string.length() - n < hIBCLICDateFormat.name().length()) {
            throw new BarCodeException("Incorrect encoded date.");
        }
        if (hIBCLICDateFormat == HIBCLICDateFormat.YYJJJ) {
            int n2 = 0;
            int[] nArray = new int[]{n2};
            boolean bl = !llq.a(kke.b(string, n, 2), nArray);
            n2 = nArray[0];
            if (bl) {
                throw new BarCodeException("Incorrect encoded date.");
            }
            int n3 = 0;
            int[] nArray2 = new int[]{n3};
            boolean bl2 = !llq.a(kke.b(string, n + 2, 3), nArray2);
            n3 = nArray2[0];
            if (bl2) {
                throw new BarCodeException("Incorrect encoded date.");
            }
            return new aad(2000 + n2, 1, 1).a((double)(n3 - 1));
        }
        if (hIBCLICDateFormat == HIBCLICDateFormat.YYJJJHH) {
            int n4 = 0;
            int[] nArray = new int[]{n4};
            boolean bl = !llq.a(kke.b(string, n, 2), nArray);
            n4 = nArray[0];
            if (bl) {
                throw new BarCodeException("Incorrect encoded date.");
            }
            int n5 = 0;
            int[] nArray3 = new int[]{n5};
            boolean bl3 = !llq.a(kke.b(string, n + 2, 3), nArray3);
            n5 = nArray3[0];
            if (bl3) {
                throw new BarCodeException("Incorrect encoded date.");
            }
            int n6 = 0;
            int[] nArray4 = new int[]{n6};
            boolean bl4 = !llq.a(kke.b(string, n + 5, 2), nArray4);
            n6 = nArray4[0];
            if (bl4) {
                throw new BarCodeException("Incorrect encoded date.");
            }
            return new aad(2000 + n4, 1, 1).a((double)(n5 - 1)).b((double)n6);
        }
        aad aad2 = new aad();
        aad[] aadArray = new aad[]{aad2};
        boolean bl = !aad.a(kke.b(string, n, stringArray[hIBCLICDateFormat.getValue()].length()), stringArray[hIBCLICDateFormat.getValue()], (hhq)ii.e(), 0, aadArray);
        aadArray[0].f(aad2);
        if (bl) {
            throw new BarCodeException("Incorrect encoded date.");
        }
        return aad2;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!tt.b(obj, SecondaryAndAdditionalData.class)) {
            return false;
        }
        SecondaryAndAdditionalData secondaryAndAdditionalData = (SecondaryAndAdditionalData)obj;
        return this.getQuantity() == secondaryAndAdditionalData.getQuantity() && kke.e(this.a(), secondaryAndAdditionalData.a()) && (kke.e(this.getSerialNumber(), secondaryAndAdditionalData.getSerialNumber()) || kke.b(this.getSerialNumber()) && kke.b(secondaryAndAdditionalData.getSerialNumber())) && (kke.e(this.getLotNumber(), secondaryAndAdditionalData.getLotNumber()) || kke.b(this.getLotNumber()) && kke.b(secondaryAndAdditionalData.getLotNumber())) && kke.e(aad.a(this.getDateOfManufacture()).b("yyyyMMdd"), aad.a(secondaryAndAdditionalData.getDateOfManufacture()).b("yyyyMMdd")) && this.getExpiryDateFormat() == secondaryAndAdditionalData.getExpiryDateFormat();
    }

    public int hashCode() {
        int n = -1570462163;
        n = n * -1521134295 + this.getExpiryDateFormat().hashCode();
        n = n * -1521134295 + this.getExpiryDate().hashCode();
        n = n * -1521134295 + this.getLotNumber().hashCode();
        n = n * -1521134295 + this.getSerialNumber().hashCode();
        n = n * -1521134295 + this.getDateOfManufacture().hashCode();
        n = n * -1521134295 + llq.a(this.getQuantity());
        return n;
    }
}

