/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.barcode.complexbarcode;

import com.aspose.barcode.complexbarcode.HIBCLICCombinedCodetext;
import com.aspose.barcode.complexbarcode.HIBCLICComplexCodetext;
import com.aspose.barcode.complexbarcode.HIBCLICPrimaryDataCodetext;
import com.aspose.barcode.complexbarcode.HIBCLICSecondaryAndAdditionalDataCodetext;
import com.aspose.barcode.complexbarcode.HIBCPASCodetext;
import com.aspose.barcode.complexbarcode.Mailmark2DCodetext;
import com.aspose.barcode.complexbarcode.MailmarkCodetext;
import com.aspose.barcode.complexbarcode.MaxiCodeCodetext;
import com.aspose.barcode.complexbarcode.MaxiCodeCodetextMode2;
import com.aspose.barcode.complexbarcode.MaxiCodeCodetextMode3;
import com.aspose.barcode.complexbarcode.MaxiCodeStandardCodetext;
import com.aspose.barcode.complexbarcode.SwissQRCodetext;
import com.aspose.barcode.internal.bbr.kke;
import com.aspose.barcode.internal.bbr.vv;

public final class ComplexCodetextReader {
    private ComplexCodetextReader() {
    }

    public static SwissQRCodetext tryDecodeSwissQR(String encodedCodetext) {
        SwissQRCodetext swissQRCodetext = new SwissQRCodetext();
        try {
            swissQRCodetext.initFromString(encodedCodetext);
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
        return swissQRCodetext;
    }

    public static Mailmark2DCodetext tryDecodeMailmark2D(String encodedCodetext) {
        Mailmark2DCodetext mailmark2DCodetext = new Mailmark2DCodetext();
        try {
            mailmark2DCodetext.initFromString(encodedCodetext);
        }
        catch (Exception exception) {
            return null;
        }
        return mailmark2DCodetext;
    }

    public static MailmarkCodetext tryDecodeMailmark(String encodedCodetext) {
        MailmarkCodetext mailmarkCodetext = new MailmarkCodetext();
        try {
            mailmarkCodetext.initFromString(encodedCodetext);
        }
        catch (Exception exception) {
            return null;
        }
        return mailmarkCodetext;
    }

    public static MaxiCodeCodetext tryDecodeMaxiCode(int maxiCodeMode, String encodedCodetext) {
        MaxiCodeCodetext maxiCodeCodetext;
        switch (maxiCodeMode) {
            case 2: {
                maxiCodeCodetext = new MaxiCodeCodetextMode2();
                break;
            }
            case 3: {
                maxiCodeCodetext = new MaxiCodeCodetextMode3();
                break;
            }
            default: {
                maxiCodeCodetext = new MaxiCodeStandardCodetext();
                ((MaxiCodeStandardCodetext)maxiCodeCodetext).setMode(maxiCodeMode);
            }
        }
        try {
            maxiCodeCodetext.initFromString(encodedCodetext);
        }
        catch (Exception exception) {
            return null;
        }
        return maxiCodeCodetext;
    }

    public static HIBCLICComplexCodetext tryDecodeHIBCLIC(String encodedCodetext) {
        HIBCLICComplexCodetext hIBCLICComplexCodetext;
        int n = kke.d(encodedCodetext, '/');
        if (vv.c(encodedCodetext.charAt(1)) || encodedCodetext.charAt(1) == '$') {
            hIBCLICComplexCodetext = new HIBCLICSecondaryAndAdditionalDataCodetext();
        } else if (vv.n(encodedCodetext.charAt(1)) && (n == -1 || n == encodedCodetext.length() - 1)) {
            hIBCLICComplexCodetext = new HIBCLICPrimaryDataCodetext();
        } else if (vv.n(encodedCodetext.charAt(1)) && n != -1 && n != encodedCodetext.length() - 1) {
            hIBCLICComplexCodetext = new HIBCLICCombinedCodetext();
        } else {
            return null;
        }
        try {
            ((HIBCLICComplexCodetext)hIBCLICComplexCodetext).initFromString(encodedCodetext);
            return hIBCLICComplexCodetext;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    public static HIBCPASCodetext tryDecodeHIBCPAS(String encodedCodetext) {
        HIBCPASCodetext hIBCPASCodetext = new HIBCPASCodetext();
        try {
            hIBCPASCodetext.initFromString(encodedCodetext);
            return hIBCPASCodetext;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }
}

