/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.threed.utils;

import com.aspose.threed.utils.Stream;
import java.io.IOException;
import java.io.OutputStream;

public class MemoryStream
extends Stream
implements AutoCloseable {
    protected byte[] data;
    protected int cursor;
    protected int size;

    public MemoryStream() {
        this.data = new byte[4096];
    }

    /*
     * WARNING - void declaration
     */
    public MemoryStream(int capacity) {
        void var1_1;
        this.data = new byte[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    public MemoryStream(byte[] data) {
        void var1_1;
        this.data = data;
        this.size = ((void)var1_1).length;
    }

    public int getSize() {
        return this.size;
    }

    public byte[] getBuffer() {
        return this.data;
    }

    private void a(int n2) {
        if (this.data != null && this.data.length >= n2) {
            return;
        }
        int n3 = this.data == null ? 0 : this.data.length;
        if (n3 == 0) {
            n3 = 4096;
        }
        while (n3 < n2) {
            n3 <<= 1;
        }
        this.setCapacity(n3);
    }

    /*
     * WARNING - void declaration
     */
    public void setCapacity(int cap) {
        if (cap < 0) {
            throw new IllegalArgumentException();
        }
        byte[] byArray = new byte[cap];
        if (this.data != null) {
            System.arraycopy(this.data, 0, byArray, 0, Math.min(cap, this.data.length));
        }
        this.data = byArray;
        if (this.size > cap) {
            void var1_1;
            this.size = var1_1;
        }
    }

    @Override
    public long getLength() {
        return this.size;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setLength(long len) {
        void var1_1;
        this.a((int)len);
        this.size = (int)var1_1;
        if (this.cursor > this.size) {
            MemoryStream memoryStream = this;
            int n2 = memoryStream.size;
            MemoryStream memoryStream2 = memoryStream;
            memoryStream.cursor = n2;
        }
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public int readByte() throws IOException {
        if (this.cursor >= this.data.length) {
            return -1;
        }
        this.a();
        int n2 = this.cursor;
        MemoryStream memoryStream = this;
        int n3 = memoryStream.cursor + 1;
        MemoryStream memoryStream2 = memoryStream;
        memoryStream.cursor = n3;
        return this.data[n2];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int read(byte[] buf) throws IOException {
        void var1_1;
        return this.read(buf, 0, ((void)var1_1).length);
    }

    @Override
    public int read(byte[] buf, int start, int len) throws IOException {
        int n2;
        MemoryStream memoryStream;
        int n3;
        this.a();
        n3 = Math.max(0, Math.min(Math.min(this.size - start, len), Math.min(this.size - this.cursor, n3)));
        if (n3 == 0) {
            return 0;
        }
        System.arraycopy(this.data, this.cursor, memoryStream, n2, n3);
        MemoryStream memoryStream2 = this;
        n2 = memoryStream2.cursor + n3;
        memoryStream = memoryStream2;
        memoryStream2.cursor = n2;
        return n3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(byte[] buf) throws IOException {
        void var1_1;
        this.a();
        this.write(buf, 0, ((void)var1_1).length);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(byte[] buf, int start, int len) throws IOException {
        void var3_3;
        int n2;
        MemoryStream memoryStream;
        this.a();
        MemoryStream memoryStream2 = this;
        memoryStream2.a(memoryStream2.cursor + len);
        System.arraycopy(memoryStream, n2, this.data, this.cursor, len);
        MemoryStream memoryStream3 = this;
        n2 = memoryStream3.cursor + var3_3;
        memoryStream = memoryStream3;
        memoryStream3.cursor = n2;
        if (this.cursor > this.size) {
            this.size = this.cursor;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void writeByte(int b2) throws IOException {
        void var1_1;
        this.a();
        MemoryStream memoryStream = this;
        memoryStream.a(memoryStream.cursor + 1);
        this.data[this.cursor] = (byte)var1_1;
        MemoryStream memoryStream2 = this;
        int n2 = memoryStream2.cursor + 1;
        MemoryStream memoryStream3 = memoryStream2;
        memoryStream2.cursor = n2;
        ++this.size;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long seek(long offset222, int seek) throws IOException {
        switch (seek) {
            case 0: {
                int n2 = (int)offset222;
                MemoryStream offset222 = this;
                this.cursor = n2;
                break;
            }
            case 1: {
                long offset222;
                MemoryStream memoryStream = this;
                int n3 = memoryStream.cursor + (int)offset222;
                MemoryStream offset222 = memoryStream;
                memoryStream.cursor = n3;
                break;
            }
            case 2: {
                void var1_1;
                MemoryStream memoryStream = this;
                int n4 = memoryStream.size + (int)var1_1;
                MemoryStream memoryStream2 = memoryStream;
                memoryStream.cursor = n4;
            }
        }
        return this.cursor;
    }

    private void a() {
        if (this.cursor < 0 || this.cursor > this.size) {
            throw new IllegalStateException("Invalid cursor");
        }
    }

    public byte[] toArray() {
        byte[] byArray = new byte[this.size];
        if (this.size == 0) {
            return byArray;
        }
        System.arraycopy(this.data, 0, byArray, 0, this.size);
        return byArray;
    }

    @Override
    public void close() throws IOException {
    }

    /*
     * WARNING - void declaration
     */
    public void copyTo(Stream stream) throws IOException {
        if (this.size > 0) {
            void var1_1;
            var1_1.write(this.data, 0, this.size);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void copyTo(OutputStream stream) throws IOException {
        if (this.size > 0) {
            void var1_1;
            var1_1.write(this.data, 0, this.size);
        }
    }
}

