/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.threed;

import com.aspose.threed.BoundingBox;
import com.aspose.threed.Matrix4;
import com.aspose.threed.Mesh;
import com.aspose.threed.Primitive;
import com.aspose.threed.Vector3;
import com.aspose.threed.Vector4;
import com.aspose.threed.iq;

public class Sphere
extends Primitive {
    private double radius;
    private int widthSegments;
    private int heightSegments;
    private double phiStart;
    private double phiLength;
    private double thetaStart;
    private double thetaLength;

    public Sphere() {
        this(1.0);
    }

    /*
     * WARNING - void declaration
     */
    public Sphere(double radius) {
        this((double)var1_1, 12, 8);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Sphere(double radius, int widthSegments, int heightSegments) {
        this("", (double)var1_1, (int)var3_2, heightSegments, 0.0, Math.PI * 2, 0.0, Math.PI);
        void var3_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Sphere(String name, double radius, int widthSegments, int heightSegments, double phiStart, double phiLength, double thetaStart, double thetaLength) {
        super((String)var1_1);
        void var2_2;
        void var1_1;
        this.radius = var2_2;
        this.setWidthSegments(widthSegments);
        this.setHeightSegments(heightSegments);
        this.phiStart = phiStart;
        this.phiLength = phiLength;
        this.thetaStart = thetaStart;
        this.thetaLength = thetaLength;
    }

    public int getWidthSegments() {
        return this.widthSegments;
    }

    /*
     * WARNING - void declaration
     */
    public void setWidthSegments(int value) {
        void var1_1;
        this.widthSegments = Math.max(3, (int)var1_1);
    }

    public int getHeightSegments() {
        return this.heightSegments;
    }

    /*
     * WARNING - void declaration
     */
    public void setHeightSegments(int value) {
        void var1_1;
        this.heightSegments = Math.max(2, (int)var1_1);
    }

    public double getPhiStart() {
        return this.phiStart;
    }

    /*
     * WARNING - void declaration
     */
    public void setPhiStart(double value) {
        void var1_1;
        this.phiStart = var1_1;
    }

    public double getPhiLength() {
        return this.phiLength;
    }

    /*
     * WARNING - void declaration
     */
    public void setPhiLength(double value) {
        void var1_1;
        this.phiLength = var1_1;
    }

    public double getThetaStart() {
        return this.thetaStart;
    }

    /*
     * WARNING - void declaration
     */
    public void setThetaStart(double value) {
        void var1_1;
        this.thetaStart = var1_1;
    }

    public double getThetaLength() {
        return this.thetaLength;
    }

    /*
     * WARNING - void declaration
     */
    public void setThetaLength(double value) {
        void var1_1;
        this.thetaLength = var1_1;
    }

    public double getRadius() {
        return this.radius;
    }

    /*
     * WARNING - void declaration
     */
    public void setRadius(double value) {
        void var1_1;
        this.radius = var1_1;
    }

    @Override
    final BoundingBox a(Matrix4 matrix4) {
        double d2 = this.radius;
        BoundingBox boundingBox = new BoundingBox();
        boundingBox.a(Matrix4.mul(matrix4, new Vector3(0.0, 0.0, d2)));
        boundingBox.a(Matrix4.mul(matrix4, new Vector3(0.0, 0.0, -d2)));
        boundingBox.a(Matrix4.mul(matrix4, new Vector3(0.0, d2, 0.0)));
        boundingBox.a(Matrix4.mul(matrix4, new Vector3(0.0, -d2, 0.0)));
        boundingBox.a(Matrix4.mul(matrix4, new Vector3(d2, 0.0, 0.0)));
        boundingBox.a(Matrix4.mul(matrix4, new Vector3(-d2, 0.0, 0.0)));
        return boundingBox;
    }

    @Override
    public Mesh toMesh() {
        int n2;
        int n3;
        Mesh mesh = this.createEmptyMesh();
        double d2 = this.thetaStart + this.thetaLength;
        int n4 = (this.widthSegments + 1) * (this.heightSegments + 1);
        Vector4[] vector4Array = (Vector4[])iq.d.newArray(n4);
        Vector4[] vector4Array2 = (Vector4[])iq.d.newArray(n4);
        Vector4[] vector4Array3 = (Vector4[])iq.d.newArray(n4);
        int n5 = 0;
        int[][] nArrayArray = new int[this.heightSegments + 1][];
        for (n3 = 0; n3 <= this.heightSegments; ++n3) {
            int[] nArray = new int[this.widthSegments + 1];
            double d3 = 1.0 * (double)n3 / (double)this.heightSegments;
            for (n2 = 0; n2 <= this.widthSegments; ++n2) {
                double d4 = 1.0 * (double)n2 / (double)this.widthSegments;
                double d5 = -this.radius * Math.cos(this.phiStart + d4 * this.phiLength) * Math.sin(this.thetaStart + d3 * this.thetaLength);
                double d6 = this.radius * Math.cos(this.thetaStart + d3 * this.thetaLength);
                double d7 = this.radius * Math.sin(this.phiStart + d4 * this.phiLength) * Math.sin(this.thetaStart + d3 * this.thetaLength);
                vector4Array[n5] = new Vector4(d5, d6, d7, 1.0);
                vector4Array2[n5] = new Vector4(new Vector3(d5, d6, d7).normalize());
                vector4Array3[n5] = new Vector4(d4, 1.0 - d3, 0.0, 0.0);
                nArray[n2] = n5++;
            }
            nArrayArray[n3] = nArray;
        }
        for (n3 = 0; n3 < this.heightSegments; ++n3) {
            for (int i2 = 0; i2 < this.widthSegments; ++i2) {
                boolean bl2;
                int n6 = nArrayArray[n3][i2 + 1];
                int n7 = nArrayArray[n3][i2];
                n2 = nArrayArray[n3 + 1][i2];
                int n8 = nArrayArray[n3 + 1][i2 + 1];
                boolean bl3 = n3 != 0 || this.thetaStart > 0.0;
                boolean bl4 = bl2 = n3 != this.heightSegments - 1 || d2 < Math.PI;
                if (bl3 && bl2) {
                    mesh.createPolygon(n6, n7, n2, n8);
                    continue;
                }
                if (bl3) {
                    mesh.createPolygon(n6, n7, n8);
                    continue;
                }
                if (!bl2) continue;
                mesh.createPolygon(n7, n2, n8);
            }
        }
        Primitive.setup(mesh, vector4Array, vector4Array2, vector4Array3);
        return mesh;
    }
}

