/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.threed;

import com.aspose.threed.DracoFormat;
import com.aspose.threed.FileContentType;
import com.aspose.threed.FileFormatType;
import com.aspose.threed.ImportException;
import com.aspose.threed.LoadOptions;
import com.aspose.threed.PdfFormat;
import com.aspose.threed.PlyFormat;
import com.aspose.threed.RvmFormat;
import com.aspose.threed.SaveOptions;
import com.aspose.threed.da;
import com.aspose.threed.dd;
import com.aspose.threed.eQ;
import com.aspose.threed.eW;
import com.aspose.threed.utils.AsposeUtils;
import com.aspose.threed.utils.FileStream;
import com.aspose.threed.utils.Stream;
import com.aspose.threed.utils.Version;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.HashMap;

public class FileFormat {
    private static HashMap<String, FileFormat> a = new HashMap();
    public static final FileFormat FBX6100ASCII;
    public static final FileFormat FBX6100_BINARY;
    public static final FileFormat FBX7200ASCII;
    public static final FileFormat FBX7200_BINARY;
    public static final FileFormat FBX7300ASCII;
    public static final FileFormat FBX7300_BINARY;
    public static final FileFormat FBX7400ASCII;
    public static final FileFormat FBX7400_BINARY;
    public static final FileFormat FBX7500ASCII;
    public static final FileFormat FBX7500_BINARY;
    public static final FileFormat FBX7600ASCII;
    public static final FileFormat FBX7600_BINARY;
    public static final FileFormat FBX7700ASCII;
    public static final FileFormat FBX7700_BINARY;
    public static final FileFormat MAYAASCII;
    public static final FileFormat MAYA_BINARY;
    public static final FileFormat STL_BINARY;
    public static final FileFormat STLASCII;
    public static final FileFormat WAVEFRONTOBJ;
    public static final FileFormat DISCREET3DS;
    public static final FileFormat COLLADA;
    public static final FileFormat UNIVERSAL3D;
    public static final FileFormat GLTF;
    public static final FileFormat GLTF2;
    public static final FileFormat GLTF_BINARY;
    public static final FileFormat GLTF2_BINARY;
    public static final PdfFormat PDF;
    public static final FileFormat DXF;
    public static final PlyFormat PLY;
    public static final FileFormat X_BINARY;
    public static final FileFormat X_TEXT;
    public static final DracoFormat DRACO;
    public static final FileFormat MICROSOFT3MF;
    public static final RvmFormat RVM_TEXT;
    public static final RvmFormat RVM_BINARY;
    public static final FileFormat ASE;
    public static final FileFormat SIEMENSJT8;
    public static final FileFormat SIEMENSJT9;
    public static final FileFormat AMF;
    public static final FileFormat VRML;
    public static final FileFormat ASPOSE3D_WEB;
    public static final FileFormat HTML5;
    public static final FileFormat ZIP;
    public static final FileFormat USD;
    public static final FileFormat USDZ;
    public static final FileFormat XYZ;
    public static final FileFormat PCD;
    public static final FileFormat PCD_BINARY;
    private FileFormatType b;
    private FileContentType c;
    private Version d;

    public Version getVersion() {
        return this.d;
    }

    public static FileFormat getFormatByExtension(String extensionName) {
        FileFormat fileFormat;
        FileFormat[] fileFormatArray = new FileFormat[1];
        if (extensionName == null || extensionName.length() == 0) {
            return null;
        }
        if (AsposeUtils.tryGetValue(a, ((String)((Object)fileFormat)).toLowerCase(), fileFormatArray)) {
            fileFormat = fileFormatArray[0];
            return fileFormat;
        }
        return null;
    }

    final FileFormat a(String string) {
        a.put(string, this);
        return this;
    }

    public boolean getCanExport() {
        dd dd2 = eW.a().b(this);
        return dd2 != null;
    }

    public boolean getCanImport() {
        eQ eQ2 = eW.a().d(this);
        return eQ2 != null;
    }

    public String getExtension() {
        if (this.b.a() != null && this.b.a().length > 0) {
            return this.b.a()[0];
        }
        return null;
    }

    public String[] getExtensions() {
        return this.b.a();
    }

    public FileContentType getContentType() {
        return this.c;
    }

    public FileFormatType getFileFormatType() {
        return this.b;
    }

    /*
     * WARNING - void declaration
     */
    FileFormat(FileFormatType formatType, Version version, FileContentType contentType) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.b = var1_1;
        this.d = var2_2;
        this.c = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    FileFormat(FileFormatType formatType, FileContentType contentType) {
        void var2_2;
        void var1_1;
        this.b = var1_1;
        this.d = new Version(1, 0);
        this.c = var2_2;
    }

    private static FileFormat a(FileFormatType object, int n2, int n3) {
        object = new FileFormat((FileFormatType)object, new Version(n2, n3), FileContentType.BINARY);
        return object;
    }

    private static FileFormat b(FileFormatType object, int n2, int n3) {
        object = new FileFormat((FileFormatType)object, new Version(n2, n3), FileContentType.ASCII);
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public static FileFormat detect(Stream stream, String fileName) throws IOException {
        Stream stream2;
        void var1_1;
        if (stream == null) {
            throw new IllegalArgumentException("Argument stream cannot be null");
        }
        return eW.a().a((String)var1_1, stream2);
    }

    public static FileFormat detect(String fileName) throws IOException {
        if (fileName == null || fileName.length() == 0) {
            throw new IllegalArgumentException("Argument fileName cannot be null");
        }
        if (!Files.exists(Paths.get(fileName, new String[0]), new LinkOption[0])) {
            throw new FileNotFoundException(da.a());
        }
        try (FileStream fileStream = new FileStream(fileName, 1, 1);){
            FileFormat fileFormat;
            fileFormat = FileFormat.detect(fileStream, (String)((Object)fileFormat));
            return fileFormat;
        }
    }

    public LoadOptions createLoadOptions() throws ImportException {
        return eW.a().f(this);
    }

    public SaveOptions createSaveOptions() {
        return eW.a().e(this);
    }

    public String toString() {
        return String.format("%s/%s/%s", new Object[]{this.getVersion(), this.getContentType(), this.getFileFormatType()});
    }

    static {
        MAYAASCII = FileFormat.b(FileFormatType.MAYA, 1, 0).a(".ma");
        MAYA_BINARY = FileFormat.a(FileFormatType.MAYA, 1, 0).a(".mb");
        FBX6100ASCII = FileFormat.b(FileFormatType.FBX, 6, 1);
        FBX7200ASCII = FileFormat.b(FileFormatType.FBX, 7, 2);
        FBX7300ASCII = FileFormat.b(FileFormatType.FBX, 7, 3);
        FBX7400ASCII = FileFormat.b(FileFormatType.FBX, 7, 4);
        FBX7500ASCII = FileFormat.b(FileFormatType.FBX, 7, 5);
        FBX7600ASCII = FileFormat.b(FileFormatType.FBX, 7, 6);
        FBX7700ASCII = FileFormat.b(FileFormatType.FBX, 7, 7);
        FBX6100_BINARY = FileFormat.a(FileFormatType.FBX, 6, 1);
        FBX7200_BINARY = FileFormat.a(FileFormatType.FBX, 7, 2);
        FBX7300_BINARY = FileFormat.a(FileFormatType.FBX, 7, 3);
        FBX7400_BINARY = FileFormat.a(FileFormatType.FBX, 7, 4);
        FBX7500_BINARY = FileFormat.a(FileFormatType.FBX, 7, 5);
        FBX7600_BINARY = FileFormat.a(FileFormatType.FBX, 7, 6);
        FBX7700_BINARY = FileFormat.a(FileFormatType.FBX, 7, 7).a(".fbx");
        STLASCII = FileFormat.b(FileFormatType.STL, 1, 0);
        STL_BINARY = FileFormat.a(FileFormatType.STL, 1, 0).a(".stl");
        WAVEFRONTOBJ = FileFormat.b(FileFormatType.WAVEFRONTOBJ, 1, 0).a(".obj");
        DISCREET3DS = FileFormat.a(FileFormatType.DISCREET3DS, 1, 0).a(".3ds");
        COLLADA = FileFormat.b(FileFormatType.COLLADA, 1, 5).a(".dae");
        UNIVERSAL3D = FileFormat.a(FileFormatType.UNIVERSAL3D, 3, 0).a(".u3d");
        PDF = (PdfFormat)new PdfFormat().a(".pdf");
        GLTF = FileFormat.b(FileFormatType.GLTF, 1, 0);
        GLTF_BINARY = FileFormat.a(FileFormatType.GLTF, 1, 0);
        GLTF2 = FileFormat.b(FileFormatType.GLTF, 2, 0).a(".gltf");
        GLTF2_BINARY = FileFormat.a(FileFormatType.GLTF, 2, 0).a(".glb");
        DXF = FileFormat.b(FileFormatType.DXF, 1, 0).a(".dxf");
        PLY = (PlyFormat)new PlyFormat().a(".ply");
        AMF = FileFormat.b(FileFormatType.AMF, 1, 0).a(".amf");
        X_BINARY = FileFormat.a(FileFormatType.X, 1, 0).a(".x");
        X_TEXT = FileFormat.b(FileFormatType.X, 1, 0);
        DRACO = (DracoFormat)new DracoFormat().a(".drc");
        MICROSOFT3MF = FileFormat.a(FileFormatType.MICROSOFT3MF, 1, 0).a(".3mf");
        RVM_TEXT = new RvmFormat(FileContentType.ASCII);
        RVM_BINARY = (RvmFormat)new RvmFormat(FileContentType.BINARY).a(".rvm");
        USD = FileFormat.a(FileFormatType.USD, 1, 0).a(".usd").a(".usdc");
        USDZ = FileFormat.a(FileFormatType.USD, 1, 0).a(".usdz");
        ASE = FileFormat.b(FileFormatType.ASE, 1, 0).a(".ase");
        SIEMENSJT8 = FileFormat.a(FileFormatType.SIEMENSJT, 8, 0);
        SIEMENSJT9 = FileFormat.a(FileFormatType.SIEMENSJT, 9, 0).a(".jt");
        FileFormat.a(FileFormatType.a, 1, 0).a(".prc");
        VRML = FileFormat.a(FileFormatType.VRML, 1, 0).a(".vrml");
        ASPOSE3D_WEB = FileFormat.a(FileFormatType.ASPOSE3D_WEB, 1, 0).a(".a3dw");
        HTML5 = FileFormat.a(FileFormatType.HTML5, 1, 0).a(".html").a(".html5");
        ZIP = FileFormat.a(FileFormatType.ZIP, 1, 0).a(".zip");
        XYZ = FileFormat.b(FileFormatType.XYZ, 1, 0).a(".xyz");
        PCD = FileFormat.b(FileFormatType.PCD, 1, 0);
        PCD_BINARY = FileFormat.a(FileFormatType.PCD, 1, 0).a(".pcd");
    }
}

