/*
 * Decompiled with CFR 0.152.
 */
package com.ashokvarma.gander.internal.ui.details.fragments;

import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.ashokvarma.gander.R;
import com.ashokvarma.gander.internal.data.HttpTransaction;
import com.ashokvarma.gander.internal.ui.details.fragments.TransactionFragment;

public class TransactionOverviewFragment
extends Fragment
implements TransactionFragment {
    private TextView mUrlView;
    private TextView mMethodView;
    private TextView mProtocolView;
    private TextView mStatusView;
    private TextView mResponseView;
    private TextView mSslView;
    private TextView mRequestTimeView;
    private TextView mResponseTimeView;
    private TextView mDurationView;
    private TextView mRequestSizeView;
    private TextView mResponseSizeView;
    private TextView mTotalSizeView;
    private HttpTransaction mTransaction;

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setRetainInstance(true);
    }

    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.gander_frag_transaction_overview, container, false);
        this.mUrlView = (TextView)view.findViewById(R.id.gander_details_url);
        this.mMethodView = (TextView)view.findViewById(R.id.gander_details_method);
        this.mProtocolView = (TextView)view.findViewById(R.id.gander_details_protocol);
        this.mStatusView = (TextView)view.findViewById(R.id.gander_details_status);
        this.mResponseView = (TextView)view.findViewById(R.id.gander_details_response);
        this.mSslView = (TextView)view.findViewById(R.id.gander_details_ssl);
        this.mRequestTimeView = (TextView)view.findViewById(R.id.gander_details_request_time);
        this.mResponseTimeView = (TextView)view.findViewById(R.id.gander_details_response_time);
        this.mDurationView = (TextView)view.findViewById(R.id.gander_details_duration);
        this.mRequestSizeView = (TextView)view.findViewById(R.id.gander_details_request_size);
        this.mResponseSizeView = (TextView)view.findViewById(R.id.gander_details_response_size);
        this.mTotalSizeView = (TextView)view.findViewById(R.id.gander_details_total_size);
        return view;
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.populateUI();
    }

    @Override
    public void transactionUpdated(HttpTransaction transaction) {
        this.mTransaction = transaction;
        this.populateUI();
    }

    private void populateUI() {
        if (this.isAdded() && this.mTransaction != null) {
            this.mUrlView.setText((CharSequence)this.mTransaction.getUrl());
            this.mMethodView.setText((CharSequence)this.mTransaction.getMethod());
            this.mProtocolView.setText((CharSequence)this.mTransaction.getProtocol());
            this.mStatusView.setText((CharSequence)this.mTransaction.getStatus().toString());
            this.mResponseView.setText((CharSequence)this.mTransaction.getResponseSummaryText());
            this.mSslView.setText(this.mTransaction.isSsl() ? R.string.gander_yes : R.string.gander_no);
            this.mRequestTimeView.setText((CharSequence)this.mTransaction.getRequestDateString());
            this.mResponseTimeView.setText((CharSequence)this.mTransaction.getResponseDateString());
            this.mDurationView.setText((CharSequence)this.mTransaction.getDurationString());
            this.mRequestSizeView.setText((CharSequence)this.mTransaction.getRequestSizeString());
            this.mResponseSizeView.setText((CharSequence)this.mTransaction.getResponseSizeString());
            this.mTotalSizeView.setText((CharSequence)this.mTransaction.getTotalSizeString());
        }
    }
}

