package com.artear.ui.views.error

import com.artear.tools.error.NestErrorType
import com.artear.ui.model.ErrorButton
import com.artear.ui.model.ErrorImage
import com.artear.ui.model.ErrorMessage

class ErrorCustomizer {

    var options = arrayListOf<Item>()
    internal var style: Int? = null

    class Item {

        internal lateinit var type: NestErrorType
        internal lateinit var errorImage: ErrorImage
        internal lateinit var errorMessage: ErrorMessage
        internal var errorButton: ErrorButton? = null
        internal var isDefault: Boolean = false

        class Builder(
                private val customizer: ErrorCustomizer,
                private val type: NestErrorType) {

            private val item = Item()

            fun addImage(image: ErrorImage) = apply { item.errorImage = image }

            fun addMessage(message: ErrorMessage) = apply { item.errorMessage = message }

            fun addButton(button: ErrorButton) = apply { item.errorButton = button }

            fun setByDefault() = apply { item.isDefault = true }

            fun build(): Item {
                item.type = type
                checkNotNull(item.errorImage) { "Can not be null the image of an ErrorView" }
                checkNotNull(item.errorMessage) {
                    "Can not be empty the text, the user must to know what is happening"
                }
                customizer.style?.let {
                    if (item.errorMessage.styleId == null) item.errorMessage.styleId = it
                    if (item.errorButton?.styleId == null) item.errorButton?.styleId = it
                }
                return item
            }
        }
    }

    fun addItem(item: Item) {
        options.add(item)
    }

    fun addStyle(style: Int) {
        this.style = style
    }

    fun customizeError(
            errorType: NestErrorType,
            updateViews: (
                    errorImage: ErrorImage,
                    errorMessage: ErrorMessage,
                    errorButton: ErrorButton?) -> Unit) {

        var item = options.find { option -> option.type == errorType }

        if (item == null) {
            item = options.find { option -> option.isDefault }
        }

        checkNotNull(item) {
            "The customizer must have almost one item by default if not define an " +
                    "item for each NestErrorType"
        }

        item.let {
            updateViews(
                    it.errorImage,
                    it.errorMessage,
                    it.errorButton)
        }
    }

    fun newItemBuilder(type: NestErrorType): Item.Builder {
        return Item.Builder(this, type)
    }


}