/*
 * Decompiled with CFR 0.152.
 */
package com.artear.ui.views;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.text.Layout;
import android.util.AttributeSet;
import android.view.View;
import androidx.appcompat.widget.AppCompatTextView;
import com.artear.ui.R;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\"\u0010\u001f\u001a\u00020 2\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010!\u001a\u0004\u0018\u00010\u00052\u0006\u0010\"\u001a\u00020\u0007H\u0002J\u0010\u0010#\u001a\u00020 2\u0006\u0010$\u001a\u00020%H\u0014R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R$\u0010\u0015\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R$\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001e\u00a8\u0006&"}, d2={"Lcom/artear/ui/views/UnderlinedTextView;", "Landroidx/appcompat/widget/AppCompatTextView;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "mEnabled", "", "mPaint", "Landroid/graphics/Paint;", "mStrokeWidth", "", "mColor", "underLineColor", "getUnderLineColor", "()I", "setUnderLineColor", "(I)V", "underlineEnabled", "getUnderlineEnabled", "()Z", "setUnderlineEnabled", "(Z)V", "underlineWidth", "getUnderlineWidth", "()F", "setUnderlineWidth", "(F)V", "init", "", "attributeSet", "defStyle", "onDraw", "canvas", "Landroid/graphics/Canvas;", "view_release"})
public final class UnderlinedTextView
extends AppCompatTextView {
    private Paint mPaint;
    private float mStrokeWidth;
    private boolean mEnabled;
    private HashMap _$_findViewCache;

    public final int getUnderLineColor() {
        Paint paint = this.mPaint;
        if (paint == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
        }
        return paint.getColor();
    }

    public final void setUnderLineColor(int mColor) {
        Paint paint = this.mPaint;
        if (paint == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
        }
        paint.setColor(mColor);
        this.invalidate();
    }

    public final float getUnderlineWidth() {
        return this.mStrokeWidth;
    }

    public final void setUnderlineWidth(float mStrokeWidth) {
        this.mStrokeWidth = mStrokeWidth;
        this.invalidate();
    }

    public final boolean getUnderlineEnabled() {
        return this.mEnabled;
    }

    public final void setUnderlineEnabled(boolean mEnabled) {
        this.mEnabled = mEnabled;
        this.invalidate();
    }

    private final void init(Context context, AttributeSet attributeSet, int defStyle) {
        if (!this.isInEditMode()) {
            Resources resources = context.getResources();
            Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
            float density = resources.getDisplayMetrics().density;
            if (attributeSet == null || !this.mEnabled) {
                return;
            }
            TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.UnderlinedTextView, defStyle, 0);
            int underlineColor = typedArray.getColor(R.styleable.UnderlinedTextView_underlineColor, -65536);
            this.mStrokeWidth = typedArray.getDimension(R.styleable.UnderlinedTextView_underlineWidth, density * (float)2);
            typedArray.recycle();
            Paint paint = this.mPaint = new Paint();
            if (paint == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
            }
            paint.setStyle(Paint.Style.STROKE);
            Paint paint2 = this.mPaint;
            if (paint2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
            }
            paint2.setColor(underlineColor);
            Paint paint3 = this.mPaint;
            if (paint3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
            }
            paint3.setStrokeWidth(this.mStrokeWidth);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        if (!this.isInEditMode() && this.mEnabled) {
            int count = this.getLineCount() > this.getMaxLines() ? this.getMaxLines() : this.getLineCount();
            float xStart = 0.0f;
            float xStop = 0.0f;
            Context context = this.getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
            Resources resources = context.getResources();
            Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
            float density = resources.getDisplayMetrics().density;
            int n = 0;
            int n2 = count;
            while (n < n2) {
                void i;
                int baseline = this.getLineBounds((int)i, null);
                Layout layout2 = this.getLayout();
                Intrinsics.checkExpressionValueIsNotNull((Object)layout2, (String)"layout");
                float diff = ((float)layout2.getWidth() - this.getLayout().getLineWidth((int)i)) / (float)2;
                xStart = diff + (float)this.getPaddingLeft();
                Layout layout3 = this.getLayout();
                Intrinsics.checkExpressionValueIsNotNull((Object)layout3, (String)"layout");
                xStop = (float)layout3.getWidth() - diff + (float)this.getPaddingLeft();
                float valueY = (float)baseline + this.mStrokeWidth + (float)5 * density;
                Paint paint = this.mPaint;
                if (paint == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
                }
                canvas.drawLine(xStart, valueY, xStop, valueY, paint);
                ++i;
            }
            super.onDraw(canvas);
        }
    }

    @JvmOverloads
    public UnderlinedTextView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.mEnabled = true;
        this.init(context, attrs, defStyleAttr);
    }

    @JvmOverloads
    public /* synthetic */ UnderlinedTextView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public UnderlinedTextView(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public UnderlinedTextView(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }
}

