/*
 * Decompiled with CFR 0.152.
 */
package com.artear.ui.views.error;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.AttrRes;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.content.ContextCompat;
import androidx.vectordrawable.graphics.drawable.VectorDrawableCompat;
import com.artear.tools.error.NestErrorType;
import com.artear.ui.R;
import com.artear.ui.extensions.TextViewExtKt;
import com.artear.ui.model.ErrorButton;
import com.artear.ui.model.ErrorImage;
import com.artear.ui.model.ErrorMessage;
import com.artear.ui.views.error.ErrorCustomizer;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0001&B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u0019\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bB#\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0001\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\u0010\u001a\u00020\u0011J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\nH\u0002J\b\u0010\u0015\u001a\u00020\u0011H\u0002J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u000e\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\rJ\u000e\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fJ\"\u0010\u001f\u001a\u00020\u00112\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010%H\u0002R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/artear/ui/views/error/ErrorView;", "Landroidx/constraintlayout/widget/ConstraintLayout;", "Landroid/view/View$OnClickListener;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "errorCustomizer", "Lcom/artear/ui/views/error/ErrorCustomizer;", "onReloadClickListener", "Lcom/artear/ui/views/error/ErrorView$OnReloadClickListener;", "clearOnReloadClickListener", "", "getDrawable", "Landroid/graphics/drawable/Drawable;", "drawableResId", "init", "onClick", "v", "Landroid/view/View;", "setErrorCustomizer", "customizer", "setErrorType", "errorType", "Lcom/artear/tools/error/NestErrorType;", "setOnReloadClickListener", "updateViews", "image", "Lcom/artear/ui/model/ErrorImage;", "message", "Lcom/artear/ui/model/ErrorMessage;", "button", "Lcom/artear/ui/model/ErrorButton;", "OnReloadClickListener", "view_release"})
public final class ErrorView
extends ConstraintLayout
implements View.OnClickListener {
    private OnReloadClickListener onReloadClickListener;
    private ErrorCustomizer errorCustomizer;
    private HashMap _$_findViewCache;

    private final void init() {
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.error_view, (ViewGroup)this, true);
        ((TextView)this._$_findCachedViewById(R.id.errorActionButton)).setOnClickListener((View.OnClickListener)this);
    }

    public final void setErrorCustomizer(@NotNull ErrorCustomizer customizer) {
        Intrinsics.checkParameterIsNotNull((Object)customizer, (String)"customizer");
        this.errorCustomizer = customizer;
    }

    public final void setErrorType(@NotNull NestErrorType errorType) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)errorType, (String)"errorType");
            ErrorCustomizer errorCustomizer = this.errorCustomizer;
            if (errorCustomizer == null) break block0;
            errorCustomizer.customizeError(errorType, (Function3<? super ErrorImage, ? super ErrorMessage, ? super ErrorButton, Unit>)((Function3)new Function3<ErrorImage, ErrorMessage, ErrorButton, Unit>(this){
                final /* synthetic */ ErrorView this$0;

                public final void invoke(@NotNull ErrorImage image, @NotNull ErrorMessage message, @Nullable ErrorButton button) {
                    Intrinsics.checkParameterIsNotNull((Object)image, (String)"image");
                    Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                    ErrorView.access$updateViews(this.this$0, image, message, button);
                }
                {
                    this.this$0 = errorView;
                    super(3);
                }
            }));
        }
    }

    private final void updateViews(ErrorImage image, ErrorMessage message, ErrorButton button) {
        block1: {
            ErrorButton errorButton;
            AppCompatImageView appCompatImageView = (AppCompatImageView)this._$_findCachedViewById(R.id.errorImage);
            AppCompatImageView appCompatImageView2 = (AppCompatImageView)this._$_findCachedViewById(R.id.errorImage);
            Intrinsics.checkExpressionValueIsNotNull((Object)appCompatImageView2, (String)"errorImage");
            Context context = appCompatImageView2.getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"errorImage.context");
            appCompatImageView.setImageDrawable(this.getDrawable(context, image.getResId()));
            ((TextView)this._$_findCachedViewById(R.id.errorMessage)).setText(message.getTitle());
            TextView textView = (TextView)this._$_findCachedViewById(R.id.errorMessage);
            Intrinsics.checkExpressionValueIsNotNull((Object)textView, (String)"errorMessage");
            TextViewExtKt.setTextAppearanceSafe(textView, message.getStyleId());
            TextView textView2 = (TextView)this._$_findCachedViewById(R.id.errorActionButton);
            Intrinsics.checkExpressionValueIsNotNull((Object)textView2, (String)"errorActionButton");
            textView2.setVisibility(button != null ? 0 : 8);
            ErrorButton errorButton2 = button;
            if (errorButton2 == null) break block1;
            ErrorButton it = errorButton = errorButton2;
            boolean bl = false;
            ((TextView)this._$_findCachedViewById(R.id.errorActionButton)).setText(it.getText());
            TextView textView3 = (TextView)this._$_findCachedViewById(R.id.errorActionButton);
            Intrinsics.checkExpressionValueIsNotNull((Object)textView3, (String)"errorActionButton");
            TextViewExtKt.setTextAppearanceSafe(textView3, it.getStyleId());
            Integer n = it.getColorBackground();
            if (n != null) {
                Integer n2 = n;
                int color2 = ((Number)n2).intValue();
                boolean bl2 = false;
                ((TextView)this._$_findCachedViewById(R.id.errorActionButton)).setBackgroundColor(ContextCompat.getColor((Context)this.getContext(), (int)color2));
            }
        }
    }

    private final Drawable getDrawable(Context context, int drawableResId) {
        Drawable drawable;
        if (Build.VERSION.SDK_INT >= 23) {
            drawable = context.getDrawable(drawableResId);
        } else {
            Drawable drawable2;
            try {
                drawable2 = (Drawable)VectorDrawableCompat.create((Resources)context.getResources(), (int)drawableResId, null);
            }
            catch (Resources.NotFoundException e) {
                drawable2 = ContextCompat.getDrawable((Context)context, (int)drawableResId);
            }
            drawable = drawable2;
        }
        return drawable;
    }

    public void onClick(@NotNull View v) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)v, (String)"v");
            OnReloadClickListener onReloadClickListener = this.onReloadClickListener;
            if (onReloadClickListener == null) break block0;
            onReloadClickListener.onReload();
        }
    }

    public final void setOnReloadClickListener(@NotNull OnReloadClickListener onReloadClickListener) {
        Intrinsics.checkParameterIsNotNull((Object)onReloadClickListener, (String)"onReloadClickListener");
        this.onReloadClickListener = onReloadClickListener;
    }

    public final void clearOnReloadClickListener() {
        this.onReloadClickListener = null;
    }

    public ErrorView(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context);
        this.init();
    }

    public ErrorView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs);
        this.init();
    }

    public ErrorView(@NotNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.init();
    }

    public static final /* synthetic */ void access$updateViews(ErrorView $this, ErrorImage image, ErrorMessage message, ErrorButton button) {
        $this.updateViews(image, message, button);
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004"}, d2={"Lcom/artear/ui/views/error/ErrorView$OnReloadClickListener;", "", "onReload", "", "view_release"})
    public static interface OnReloadClickListener {
        public void onReload();
    }
}

