package com.artear.ui.model

import android.support.annotation.ColorRes
import android.support.annotation.DrawableRes
import android.support.annotation.StringRes
import android.support.annotation.StyleRes

sealed class ErrorField

data class ErrorImage(@DrawableRes val resId: Int) : ErrorField()
data class ErrorMessage(@StringRes val title: Int, @StyleRes var styleId: Int? = null) : ErrorField()
data class ErrorButton(@StringRes val text: Int, @ColorRes val colorBackground: Int? = null,
                       @StyleRes var styleId: Int? = null) : ErrorField()