package com.artear.ui.extensions

import android.os.Build
import android.widget.TextView


fun TextView.setTextAppearanceSafe(style : Int?){
    style?.let {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
            this.setTextAppearance(style)
        } else {
            this.setTextAppearance(context, style)
        }
    }
}