package com.artear.ui.viewmodel

import android.arch.lifecycle.MutableLiveData
import android.arch.lifecycle.ViewModel
import com.artear.tools.error.NestError
import com.artear.ui.model.State


open class StateViewModel : ViewModel() {

    var state = MutableLiveData<State>()

    init {
        state.value = State.Start
    }

    fun loading() {
        state.value = State.Loading
    }

    fun success() {
        state.value = State.Success
    }

    fun error(error: NestError) {
        state.value = State.Error(error)
    }
}