/*
 * Decompiled with CFR 0.152.
 */
package play.runsupport.classloader;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import play.runsupport.classloader.ApplicationClassLoaderProvider;

public class DelegatingClassLoader
extends ClassLoader {
    private List<String> sharedClasses;
    private ClassLoader buildLoader;
    private ApplicationClassLoaderProvider applicationClassLoaderProvider;

    public DelegatingClassLoader(ClassLoader commonLoader, List<String> sharedClasses, ClassLoader buildLoader, ApplicationClassLoaderProvider applicationClassLoaderProvider) {
        super(commonLoader);
        this.sharedClasses = sharedClasses;
        this.buildLoader = buildLoader;
        this.applicationClassLoaderProvider = applicationClassLoaderProvider;
    }

    @Override
    public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (this.sharedClasses.contains(name)) {
            return this.buildLoader.loadClass(name);
        }
        return super.loadClass(name, resolve);
    }

    @Override
    public URL getResource(String name) {
        URLClassLoader appClassLoader = this.applicationClassLoaderProvider.get();
        URL resource = null;
        if (appClassLoader != null) {
            resource = appClassLoader.findResource(name);
        }
        return resource != null ? resource : super.getResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        URLClassLoader appClassLoader = this.applicationClassLoaderProvider.get();
        Enumeration<URL> resources1 = appClassLoader != null ? appClassLoader.findResources(name) : new Vector().elements();
        Enumeration<URL> resources2 = super.getResources(name);
        return this.combineResources(resources1, resources2);
    }

    private Enumeration<URL> combineResources(Enumeration<URL> resources1, Enumeration<URL> resources2) {
        HashSet<URL> set = new HashSet<URL>();
        while (resources1.hasMoreElements()) {
            set.add(resources1.nextElement());
        }
        while (resources2.hasMoreElements()) {
            set.add(resources2.nextElement());
        }
        return new Vector(set).elements();
    }

    public String toString() {
        return "DelegatingClassLoader, using parent: " + this.getParent();
    }
}

