/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.play2.provider.play27;

import com.google.code.play2.provider.api.AssetCompilationException;
import com.google.code.play2.provider.api.CoffeescriptCompilationResult;
import com.google.code.play2.provider.api.Play2CoffeescriptCompiler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.tools.shell.Global;

public class Play27CoffeescriptCompiler
implements Play2CoffeescriptCompiler {
    private List<String> compilerOptions = Collections.emptyList();

    public void setCompilerOptions(List<String> compilerOptions) {
        this.compilerOptions = compilerOptions;
    }

    public CoffeescriptCompilationResult compile(File source) throws AssetCompilationException, IOException {
        try {
            String js = this.compile(source, this.compilerOptions.contains("bare"));
            return new CompileResult(js);
        }
        catch (JavaScriptException e) {
            Scriptable error = (Scriptable)e.getValue();
            String msg = (String)ScriptableObject.getProperty((Scriptable)error, (String)"message");
            int line = 0;
            Matcher m = Pattern.compile(".*on line ([0-9]+).*").matcher(msg);
            if (m.find()) {
                line = Integer.parseInt(m.group(1));
            }
            throw new AssetCompilationException(source, msg, line, 0);
        }
    }

    private String compile(File source, boolean bare) throws IOException {
        Context ctx = Context.enter();
        ctx.setOptimizationLevel(-1);
        Global global = new Global();
        global.init(ctx);
        Scriptable scope = ctx.initStandardObjects((ScriptableObject)global);
        Object wrappedCoffeescriptCompiler = Context.javaToJS((Object)this, (Scriptable)scope);
        ScriptableObject.putProperty((Scriptable)scope, (String)"CoffeescriptCompiler", (Object)wrappedCoffeescriptCompiler);
        ctx.evaluateReader(scope, (Reader)new InputStreamReader(this.getClass().getClassLoader().getResource("coffee-script.js").openConnection().getInputStream(), "UTF-8"), "coffee-script.js", 1, null);
        NativeObject coffee = (NativeObject)scope.get("CoffeeScript", scope);
        Function compilerFunction = (Function)coffee.get("compile", scope);
        Context.exit();
        String coffeeCode = this.readFileContent(source);
        Scriptable options = ctx.newObject(scope);
        options.put("bare", options, (Object)bare);
        return (String)Context.call(null, (Callable)compilerFunction, (Scriptable)scope, (Scriptable)scope, (Object[])new Object[]{coffeeCode, options});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFileContent(File file) throws IOException {
        String result = null;
        try (BufferedReader is = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));){
            StringBuilder sb = new StringBuilder();
            String line = is.readLine();
            while (line != null) {
                sb.append(line).append('\n');
                line = is.readLine();
            }
            result = sb.toString();
        }
        return result;
    }

    public static class CompileResult
    implements CoffeescriptCompilationResult {
        private String js;

        public CompileResult(String js) {
            this.js = js;
        }

        public String getJs() {
            return this.js;
        }
    }
}

