/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.http.upload;

import android.text.TextUtils;
import com.arialyy.aria.core.common.SubThreadConfig;
import com.arialyy.aria.core.upload.UploadEntity;
import com.arialyy.aria.exception.AriaException;
import com.arialyy.aria.exception.AriaHTTPException;
import com.arialyy.aria.http.BaseHttpThreadTaskAdapter;
import com.arialyy.aria.http.ConnectionHelp;
import com.arialyy.aria.util.ALog;
import com.arialyy.aria.util.CommonUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

final class HttpUThreadTaskAdapter
extends BaseHttpThreadTaskAdapter {
    private final String BOUNDARY = UUID.randomUUID().toString();
    private final String PREFIX = "--";
    private final String LINE_END = "\r\n";
    private HttpURLConnection mHttpConn;
    private OutputStream mOutputStream;

    HttpUThreadTaskAdapter(SubThreadConfig config) {
        super(config);
    }

    protected void handlerThreadTask() {
        File uploadFile = new File(this.getEntity().getFilePath());
        if (!uploadFile.exists()) {
            this.fail(new AriaHTTPException(String.format("\u4e0a\u4f20\u5931\u8d25\uff0c\u6587\u4ef6\u4e0d\u5b58\u5728\uff1bfilePath: %s, url: %s", this.getEntity().getFilePath(), this.getEntity().getUrl())));
            return;
        }
        try {
            URL url = new URL(CommonUtil.convertUrl((String)this.getThreadConfig().url));
            this.mHttpConn = (HttpURLConnection)url.openConnection();
            this.mHttpConn.setRequestMethod(this.mTaskOption.getRequestEnum().name);
            this.mHttpConn.setUseCaches(false);
            this.mHttpConn.setDoOutput(true);
            this.mHttpConn.setDoInput(true);
            this.mHttpConn.setRequestProperty("Connection", "Keep-Alive");
            this.mHttpConn.setRequestProperty("Content-Type", this.getContentType() + "; boundary=" + this.BOUNDARY);
            this.mHttpConn.setRequestProperty("User-Agent", this.getUserAgent());
            this.mHttpConn.setConnectTimeout(this.getTaskConfig().getConnectTimeOut());
            this.mHttpConn.setReadTimeout(this.getTaskConfig().getIOTimeOut());
            this.mHttpConn.setChunkedStreamingMode(this.getTaskConfig().getBuffSize());
            Set<String> keys = this.mTaskOption.getHeaders().keySet();
            for (String key : keys) {
                this.mHttpConn.setRequestProperty(key, this.mTaskOption.getHeaders().get(key));
            }
            this.mOutputStream = this.mHttpConn.getOutputStream();
            PrintWriter writer = new PrintWriter((Writer)new OutputStreamWriter(this.mOutputStream, this.mTaskOption.getCharSet()), true);
            Map<String, String> params = this.mTaskOption.getParams();
            if (params != null && !params.isEmpty()) {
                for (String key : params.keySet()) {
                    this.addFormField(writer, key, params.get(key));
                }
            }
            keys = this.mTaskOption.getFormFields().keySet();
            for (String key : keys) {
                this.addFormField(writer, key, this.mTaskOption.getFormFields().get(key));
            }
            this.uploadFile(writer, this.mTaskOption.getAttachment(), uploadFile);
            this.getEntity().setResponseStr(this.finish(writer));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.fail(new AriaHTTPException(String.format("\u4e0a\u4f20\u5931\u8d25\uff0cfilePath: %s, url: %s", this.getEntity().getFilePath(), this.getEntity().getUrl()), e));
        }
    }

    private void fail(AriaHTTPException e1) {
        try {
            this.fail((AriaException)e1, false);
            if (this.mOutputStream != null) {
                this.mOutputStream.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String getContentType() {
        return "multipart/form-data";
    }

    private String getUserAgent() {
        return this.mTaskOption.getHeaders() == null || TextUtils.isEmpty((CharSequence)this.mTaskOption.getHeaders().get("User-Agent")) ? "Mozilla/5.0 (Windows; U; Windows NT 6.1; zh-CN; rv:1.9.2.6)" : this.mTaskOption.getHeaders().get("User-Agent");
    }

    private void addFormField(PrintWriter writer, String name, String value) {
        writer.append("--").append(this.BOUNDARY).append("\r\n");
        writer.append("Content-Disposition: form-data; name=\"").append(name).append("\"").append("\r\n");
        writer.append("Content-Type: text/plain; charset=").append(this.mTaskOption.getCharSet()).append("\r\n");
        writer.append("\r\n");
        writer.append(value).append("\r\n");
        writer.flush();
    }

    private void uploadFile(PrintWriter writer, String attachment, File uploadFile) throws IOException {
        int bytesLen;
        writer.append("--").append(this.BOUNDARY).append("\r\n");
        writer.append("Content-Disposition: form-data; name=\"").append(attachment).append("\"; filename=\"").append(this.getEntity().getFileName()).append("\"").append("\r\n");
        writer.append("Content-Type: ").append(URLConnection.guessContentTypeFromName(this.getEntity().getFileName())).append("\r\n");
        writer.append("Content-Transfer-Encoding: binary").append("\r\n");
        writer.append("\r\n");
        writer.flush();
        FileInputStream inputStream = new FileInputStream(uploadFile);
        byte[] buffer = new byte[4096];
        while ((bytesLen = inputStream.read(buffer)) != -1) {
            this.mOutputStream.write(buffer, 0, bytesLen);
            this.progress(bytesLen);
            if (this.getThreadTask().isBreak()) break;
            if (this.mSpeedBandUtil == null) continue;
            this.mSpeedBandUtil.limitNextBytes(bytesLen);
        }
        this.mOutputStream.flush();
        inputStream.close();
        writer.append("\r\n").flush();
        writer.append("--").append(this.BOUNDARY).append("--").append("\r\n").flush();
    }

    private String finish(PrintWriter writer) throws IOException {
        StringBuilder response = new StringBuilder();
        int status = this.mHttpConn.getResponseCode();
        if (status == 200) {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(ConnectionHelp.convertInputStream(this.mHttpConn)));
            while (this.getThreadTask().isLive() && (line = reader.readLine()) != null) {
                response.append(line);
            }
            reader.close();
            this.mHttpConn.disconnect();
            this.complete();
        } else {
            String msg = "response msg: " + this.mHttpConn.getResponseMessage() + "\uff0ccode: " + status;
            ALog.e((String)this.TAG, (String)msg);
            this.fail((AriaException)new AriaHTTPException(msg), false);
            response.append(status);
        }
        writer.flush();
        writer.close();
        this.mOutputStream.close();
        return response.toString();
    }

    protected UploadEntity getEntity() {
        return (UploadEntity)super.getEntity();
    }
}

