/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.arcmutate.spring.scan;

import com.groupcdg.arcmutate.spring.scan.State;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;

public class SimpleScanner {
    private final Deque<State> state = new ArrayDeque<State>();
    private final String splitOn;

    public SimpleScanner(String splitOn) {
        this.splitOn = splitOn;
        this.state.push(State.START);
    }

    public List<String> scan(String line) {
        if (this.state.peek().equals((Object)State.IN_LINE_COMMENT)) {
            this.state.pop();
        }
        String[] parts = line.split(this.splitOn);
        ArrayList<String> ret = new ArrayList<String>();
        for (String part : parts) {
            if (part.isEmpty()) continue;
            State current = this.state.peek();
            if (current == State.IN_MULTI_LINE_COMMENT && part.contains("*/")) {
                this.state.pop();
            }
            if (current == State.IN_MULTI_LINE_STRING && part.contains("\"\"\"")) {
                this.state.pop();
            }
            if (!current.include()) continue;
            if (part.startsWith("/*")) {
                this.state.push(State.IN_MULTI_LINE_COMMENT);
                continue;
            }
            if (part.startsWith("//")) {
                this.state.push(State.IN_LINE_COMMENT);
                continue;
            }
            if (part.startsWith("\"\"\"")) {
                this.state.push(State.IN_MULTI_LINE_STRING);
                continue;
            }
            if (part.startsWith("\"")) continue;
            ret.add(part);
        }
        return ret;
    }
}

