/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.velocypack;

import com.arangodb.velocypack.ArrayIterator;
import com.arangodb.velocypack.ObjectIterator;
import com.arangodb.velocypack.VPackAttributeTranslator;
import com.arangodb.velocypack.VPackParser;
import com.arangodb.velocypack.VPackStringSlice;
import com.arangodb.velocypack.ValueType;
import com.arangodb.velocypack.exception.VPackException;
import com.arangodb.velocypack.exception.VPackKeyTypeException;
import com.arangodb.velocypack.exception.VPackNeedAttributeTranslatorException;
import com.arangodb.velocypack.exception.VPackValueTypeException;
import com.arangodb.velocypack.internal.VPackAttributeTranslatorImpl;
import com.arangodb.velocypack.internal.util.BinaryUtil;
import com.arangodb.velocypack.internal.util.DateUtil;
import com.arangodb.velocypack.internal.util.NumberUtil;
import com.arangodb.velocypack.internal.util.ObjectArrayUtil;
import com.arangodb.velocypack.internal.util.ValueLengthUtil;
import com.arangodb.velocypack.internal.util.ValueTypeUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class VPackSlice
implements Serializable {
    private static final long serialVersionUID = -3452953589283603980L;
    private static final byte[] NONE_SLICE_DATA = new byte[]{0};
    public static final VPackSlice NONE_SLICE = new VPackSlice();
    public static final VPackAttributeTranslator attributeTranslator = new VPackAttributeTranslatorImpl();
    private final byte[] vpack;
    private final int start;

    protected VPackSlice() {
        this(NONE_SLICE_DATA, 0);
    }

    public VPackSlice(byte[] vpack) {
        this(vpack, 0);
    }

    public VPackSlice(byte[] vpack, int start) {
        this.vpack = vpack;
        this.start = start;
    }

    public byte head() {
        return this.vpack[this.start];
    }

    public byte[] getBuffer() {
        return this.vpack;
    }

    public int getStart() {
        return this.start;
    }

    public int getValueStart() {
        return this.start + this.tagsOffset(this.start);
    }

    public VPackSlice value() {
        return this.isTagged() ? new VPackSlice(this.vpack, this.getValueStart()) : this;
    }

    public ValueType getType() {
        return ValueTypeUtil.get(this.head());
    }

    private int length() {
        return ValueLengthUtil.get(this.head()) - 1;
    }

    public boolean isType(ValueType type) {
        return this.getType() == type;
    }

    public boolean isNone() {
        return this.isType(ValueType.NONE);
    }

    public boolean isNull() {
        return this.isType(ValueType.NULL);
    }

    public boolean isIllegal() {
        return this.isType(ValueType.ILLEGAL);
    }

    public boolean isBoolean() {
        return this.isType(ValueType.BOOL);
    }

    public boolean isTrue() {
        return this.head() == 26;
    }

    public boolean isFalse() {
        return this.head() == 25;
    }

    public boolean isArray() {
        return this.isType(ValueType.ARRAY);
    }

    public boolean isObject() {
        return this.isType(ValueType.OBJECT);
    }

    public boolean isDouble() {
        return this.isType(ValueType.DOUBLE);
    }

    public boolean isDate() {
        return this.isType(ValueType.UTC_DATE);
    }

    public boolean isExternal() {
        return this.isType(ValueType.EXTERNAL);
    }

    public boolean isMinKey() {
        return this.isType(ValueType.MIN_KEY);
    }

    public boolean isMaxKey() {
        return this.isType(ValueType.MAX_KEY);
    }

    public boolean isInt() {
        return this.isType(ValueType.INT);
    }

    public boolean isUInt() {
        return this.isType(ValueType.UINT);
    }

    public boolean isSmallInt() {
        return this.isType(ValueType.SMALLINT);
    }

    public boolean isInteger() {
        return this.isInt() || this.isUInt() || this.isSmallInt();
    }

    public boolean isNumber() {
        return this.isInteger() || this.isDouble();
    }

    public boolean isString() {
        return this.isType(ValueType.STRING);
    }

    public boolean isBinary() {
        return this.isType(ValueType.BINARY);
    }

    public boolean isBCD() {
        return this.isType(ValueType.BCD);
    }

    public boolean isCustom() {
        return this.isType(ValueType.CUSTOM);
    }

    public boolean isTagged() {
        return this.isType(ValueType.TAGGED);
    }

    public long getFirstTag() {
        if (this.isTagged()) {
            if (this.vpack[this.start] == -18) {
                return NumberUtil.toLong(this.vpack, this.start + 1, 1, false);
            }
            if (this.vpack[this.start] == -17) {
                return NumberUtil.toLong(this.vpack, this.start + 1, 8, false);
            }
            throw new IllegalStateException("Invalid tag type ID");
        }
        return 0L;
    }

    public List<Long> getTags() {
        if (!this.isTagged()) {
            return Collections.emptyList();
        }
        ArrayList<Long> ret = new ArrayList<Long>();
        int start = this.start;
        while (ValueTypeUtil.get(this.vpack[start]) == ValueType.TAGGED) {
            int offset;
            long tag;
            if (this.vpack[start] == -18) {
                tag = NumberUtil.toLong(this.vpack, start + 1, 1, false);
                offset = 2;
            } else if (this.vpack[start] == -17) {
                tag = NumberUtil.toLong(this.vpack, start + 1, 8, false);
                offset = 9;
            } else {
                throw new IllegalStateException("Invalid tag type ID");
            }
            ret.add(tag);
            start += offset;
        }
        return ret;
    }

    public boolean hasTag(long tagId) {
        int start = this.start;
        while (ValueTypeUtil.get(this.vpack[start]) == ValueType.TAGGED) {
            int offset;
            long tag;
            if (this.vpack[start] == -18) {
                tag = NumberUtil.toLong(this.vpack, start + 1, 1, false);
                offset = 2;
            } else if (this.vpack[start] == -17) {
                tag = NumberUtil.toLong(this.vpack, start + 1, 8, false);
                offset = 9;
            } else {
                throw new IllegalStateException("Invalid tag type ID");
            }
            if (tag == tagId) {
                return true;
            }
            start += offset;
        }
        return false;
    }

    public boolean getAsBoolean() {
        if (!this.isBoolean()) {
            throw new VPackValueTypeException(ValueType.BOOL);
        }
        return this.isTrue();
    }

    public double getAsDouble() {
        return this.getAsNumber().doubleValue();
    }

    private double getAsDoubleUnchecked() {
        return NumberUtil.toDouble(this.vpack, this.start + 1, this.length());
    }

    public BigDecimal getAsBigDecimal() {
        if (this.isString()) {
            return new BigDecimal(this.getAsString());
        }
        if (this.isDouble()) {
            return BigDecimal.valueOf(this.getAsDouble());
        }
        throw new VPackValueTypeException(ValueType.STRING, ValueType.DOUBLE);
    }

    private long getSmallInt() {
        byte head = this.head();
        long smallInt = head >= 48 && head <= 57 ? (long)(head - 48) : (long)(head - 58 - 6);
        return smallInt;
    }

    private long getInt() {
        return NumberUtil.toLong(this.vpack, this.start + 1, this.length(), true);
    }

    private long getUInt() {
        return NumberUtil.toLong(this.vpack, this.start + 1, this.length());
    }

    public Number getAsNumber() {
        Number result;
        if (this.isSmallInt()) {
            result = this.getSmallInt();
        } else if (this.isInt()) {
            result = this.getInt();
        } else if (this.isUInt()) {
            result = this.getUInt();
        } else if (this.isDouble()) {
            result = this.getAsDoubleUnchecked();
        } else {
            throw new VPackValueTypeException(ValueType.INT, ValueType.UINT, ValueType.SMALLINT);
        }
        return result;
    }

    public long getAsLong() {
        return this.getAsNumber().longValue();
    }

    public int getAsInt() {
        return this.getAsNumber().intValue();
    }

    public float getAsFloat() {
        return this.getAsNumber().floatValue();
    }

    public short getAsShort() {
        return this.getAsNumber().shortValue();
    }

    public byte getAsByte() {
        return this.getAsNumber().byteValue();
    }

    public BigInteger getAsBigInteger() {
        if (this.isString()) {
            return new BigInteger(this.getAsString());
        }
        if (this.isSmallInt() || this.isInt()) {
            return BigInteger.valueOf(this.getAsLong());
        }
        if (this.isUInt()) {
            return NumberUtil.toBigInteger(this.vpack, this.start + 1, this.length());
        }
        throw new VPackValueTypeException(ValueType.STRING, ValueType.INT, ValueType.UINT, ValueType.SMALLINT);
    }

    public java.util.Date getAsDate() {
        if (!this.isDate()) {
            throw new VPackValueTypeException(ValueType.UTC_DATE);
        }
        return DateUtil.toDate(this.vpack, this.start + 1, this.length());
    }

    public Date getAsSQLDate() {
        if (!this.isDate()) {
            throw new VPackValueTypeException(ValueType.UTC_DATE);
        }
        return DateUtil.toSQLDate(this.vpack, this.start + 1, this.length());
    }

    public Timestamp getAsSQLTimestamp() {
        if (!this.isDate()) {
            throw new VPackValueTypeException(ValueType.UTC_DATE);
        }
        return DateUtil.toSQLTimestamp(this.vpack, this.start + 1, this.length());
    }

    public String getAsString() {
        return this.getAsStringSlice().toString();
    }

    public VPackStringSlice getAsStringSlice() {
        if (!this.isString()) {
            throw new VPackValueTypeException(ValueType.STRING);
        }
        return this.isLongString() ? this.getLongString() : this.getShortString();
    }

    public char getAsChar() {
        return this.getAsString().charAt(0);
    }

    private boolean isLongString() {
        return this.head() == -65;
    }

    private VPackStringSlice getShortString() {
        return new VPackStringSlice(this.vpack, this.start + 1, this.length());
    }

    private VPackStringSlice getLongString() {
        return new VPackStringSlice(this.vpack, this.start + 9, this.getLongStringLength());
    }

    private int getLongStringLength() {
        return (int)NumberUtil.toLong(this.vpack, this.start + 1, 8);
    }

    private int getStringLength() {
        return this.isLongString() ? this.getLongStringLength() : this.head() - 64;
    }

    public byte[] getAsBinary() {
        if (!this.isBinary()) {
            throw new VPackValueTypeException(ValueType.BINARY);
        }
        return BinaryUtil.toBinary(this.vpack, this.start + 1 + this.head() - -65, this.getBinaryLength());
    }

    public int getBinaryLength() {
        if (!this.isBinary()) {
            throw new VPackValueTypeException(ValueType.BINARY);
        }
        return this.getBinaryLengthUnchecked();
    }

    private int getBinaryLengthUnchecked() {
        return (int)NumberUtil.toLong(this.vpack, this.start + 1, this.head() - -65);
    }

    public int getLength() {
        long length;
        if (this.isString()) {
            length = this.getStringLength();
        } else {
            if (!this.isArray() && !this.isObject()) {
                throw new VPackValueTypeException(ValueType.ARRAY, ValueType.OBJECT, ValueType.STRING);
            }
            byte head = this.head();
            if (head == 1 || head == 10) {
                length = 0L;
            } else if (head == 19 || head == 20) {
                long end = NumberUtil.readVariableValueLength(this.vpack, this.start + 1, false);
                length = NumberUtil.readVariableValueLength(this.vpack, (int)((long)this.start + end - 1L), true);
            } else {
                int offsetsize = ObjectArrayUtil.getOffsetSize(head);
                long end = NumberUtil.toLong(this.vpack, this.start + 1, offsetsize);
                if (head <= 5) {
                    int dataOffset = this.findDataOffset();
                    VPackSlice first = new VPackSlice(this.vpack, this.start + dataOffset);
                    length = (end - (long)dataOffset) / (long)first.getByteSize();
                } else {
                    length = offsetsize < 8 ? NumberUtil.toLong(this.vpack, this.start + 1 + offsetsize, offsetsize) : NumberUtil.toLong(this.vpack, (int)((long)this.start + end - (long)offsetsize), offsetsize);
                }
            }
        }
        return (int)length;
    }

    public int size() {
        return this.getLength();
    }

    protected int findDataOffset() {
        int fsm = ObjectArrayUtil.getFirstSubMap(this.head());
        int offset = fsm <= 2 && this.vpack[this.start + 2] != 0 ? 2 : (fsm <= 3 && this.vpack[this.start + 3] != 0 ? 3 : (fsm <= 5 && this.vpack[this.start + 6] != 0 ? 5 : 9));
        return offset;
    }

    public int getByteSize() {
        return this.getByteSize(this.start);
    }

    private int getByteSize(int start) {
        long size;
        byte head = this.vpack[start];
        int valueLength = ValueLengthUtil.get(head);
        if (valueLength != 0) {
            size = valueLength;
        } else {
            switch (ValueTypeUtil.get(head)) {
                case ARRAY: 
                case OBJECT: {
                    if (head == 19 || head == 20) {
                        size = NumberUtil.readVariableValueLength(this.vpack, start + 1, false);
                        break;
                    }
                    size = NumberUtil.toLong(this.vpack, start + 1, ObjectArrayUtil.getOffsetSize(head));
                    break;
                }
                case STRING: {
                    size = NumberUtil.toLong(this.vpack, start + 1, 8) + 1L + 8L;
                    break;
                }
                case BINARY: {
                    size = (long)(1 + head - -65) + NumberUtil.toLong(this.vpack, start + 1, head - -65);
                    break;
                }
                case BCD: {
                    if (head <= 207) {
                        size = (long)(1 + head + -57) + NumberUtil.toLong(this.vpack, start + 1, head - -57);
                        break;
                    }
                    size = (long)(1 + head - -49) + NumberUtil.toLong(this.vpack, start + 1, head - -49);
                    break;
                }
                case TAGGED: {
                    int offset = this.tagsOffset(start);
                    size = this.getByteSize(start + offset) + offset;
                    break;
                }
                case CUSTOM: {
                    if (head == 244 || head == 245 || head == 246) {
                        size = 2L + NumberUtil.toLong(this.vpack, start + 1, 1);
                        break;
                    }
                    if (head == 247 || head == 248 || head == 249) {
                        size = 3L + NumberUtil.toLong(this.vpack, start + 1, 2);
                        break;
                    }
                    if (head == 250 || head == 251 || head == 252) {
                        size = 5L + NumberUtil.toLong(this.vpack, start + 1, 4);
                        break;
                    }
                    size = 9L + NumberUtil.toLong(this.vpack, start + 1, 8);
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid type for byteSize()");
                }
            }
        }
        return (int)size;
    }

    private int tagOffset(int start) {
        byte v = this.vpack[start];
        if (ValueTypeUtil.get(v) == ValueType.TAGGED) {
            if (v == -18) {
                return 2;
            }
            if (v == -17) {
                return 9;
            }
            throw new IllegalStateException("Invalid tag type ID");
        }
        return 0;
    }

    private int tagsOffset(int start) {
        int ret = 0;
        while (ValueTypeUtil.get(this.vpack[start]) == ValueType.TAGGED) {
            int offset = this.tagOffset(start);
            ret += offset;
            start += offset;
        }
        return ret;
    }

    public VPackSlice get(int index) {
        if (!this.isArray()) {
            throw new VPackValueTypeException(ValueType.ARRAY);
        }
        return this.getNth(index);
    }

    public VPackSlice get(String attribute) throws VPackException {
        VPackSlice result;
        if (!this.isObject()) {
            throw new VPackValueTypeException(ValueType.OBJECT);
        }
        byte head = this.head();
        if (head == 10) {
            result = NONE_SLICE;
        } else if (head == 20) {
            result = this.getFromCompactObject(attribute);
        } else {
            int offsetsize = ObjectArrayUtil.getOffsetSize(head);
            long end = NumberUtil.toLong(this.vpack, this.start + 1, offsetsize);
            long n = offsetsize < 8 ? NumberUtil.toLong(this.vpack, this.start + 1 + offsetsize, offsetsize) : NumberUtil.toLong(this.vpack, (int)((long)this.start + end - (long)offsetsize), offsetsize);
            if (n == 1L) {
                VPackSlice key = new VPackSlice(this.vpack, this.start + this.findDataOffset());
                result = key.isString() ? (key.isEqualString(attribute) ? new VPackSlice(this.vpack, key.start + key.getByteSize()) : NONE_SLICE) : (key.isInteger() ? (key.translateUnchecked().isEqualString(attribute) ? new VPackSlice(this.vpack, key.start + key.getByteSize()) : NONE_SLICE) : NONE_SLICE);
            } else {
                long ieBase = end - n * (long)offsetsize - (long)(offsetsize == 8 ? 8 : 0);
                long sortedSearchEntriesThreshold = 4L;
                boolean sorted = head >= 11 && head <= 14;
                result = sorted && n >= 4L ? this.searchObjectKeyBinary(attribute, ieBase, offsetsize, n) : this.searchObjectKeyLinear(attribute, ieBase, offsetsize, n);
            }
        }
        return result;
    }

    protected VPackSlice translateUnchecked() {
        VPackSlice result = attributeTranslator.translate(this.getAsInt());
        return result != null ? result : NONE_SLICE;
    }

    protected VPackSlice makeKey() throws VPackKeyTypeException, VPackNeedAttributeTranslatorException {
        if (this.isString()) {
            return this;
        }
        if (this.isInteger()) {
            return this.translateUnchecked();
        }
        throw new VPackKeyTypeException("Cannot translate key of this type");
    }

    private VPackSlice getFromCompactObject(String attribute) throws VPackKeyTypeException, VPackNeedAttributeTranslatorException {
        Iterator<Map.Entry<String, VPackSlice>> iterator = this.objectIterator();
        while (iterator.hasNext()) {
            Map.Entry<String, VPackSlice> next = iterator.next();
            if (!next.getKey().equals(attribute)) continue;
            return next.getValue();
        }
        return NONE_SLICE;
    }

    private VPackSlice searchObjectKeyBinary(String attribute, long ieBase, int offsetsize, long n) throws VPackValueTypeException, VPackNeedAttributeTranslatorException {
        VPackSlice result;
        block7: {
            long l = 0L;
            long r = n - 1L;
            byte[] attributeBytes = attribute.getBytes(StandardCharsets.UTF_8);
            do {
                int res;
                long index;
                long offset;
                long keyIndex;
                VPackSlice key;
                if ((key = new VPackSlice(this.vpack, (int)((long)this.start + (keyIndex = NumberUtil.toLong(this.vpack, (int)((long)this.start + (offset = ieBase + (index = l + (r - l) / 2L) * (long)offsetsize)), offsetsize))))).isString()) {
                    res = key.getAsStringSlice().compareToBytes(attributeBytes);
                } else {
                    if (!key.isInteger()) {
                        result = NONE_SLICE;
                        break block7;
                    }
                    res = key.translateUnchecked().getAsStringSlice().compareToBytes(attributeBytes);
                }
                if (res == 0) {
                    result = new VPackSlice(this.vpack, key.start + key.getByteSize());
                    break block7;
                }
                if (res > 0) {
                    if (index == 0L) {
                        result = NONE_SLICE;
                        break block7;
                    }
                    r = index - 1L;
                    continue;
                }
                l = index + 1L;
            } while (r >= l);
            result = NONE_SLICE;
        }
        return result;
    }

    private VPackSlice searchObjectKeyLinear(String attribute, long ieBase, int offsetsize, long n) throws VPackValueTypeException, VPackNeedAttributeTranslatorException {
        VPackSlice result = NONE_SLICE;
        for (long index = 0L; index < n; ++index) {
            long offset = ieBase + index * (long)offsetsize;
            long keyIndex = NumberUtil.toLong(this.vpack, (int)((long)this.start + offset), offsetsize);
            VPackSlice key = new VPackSlice(this.vpack, (int)((long)this.start + keyIndex));
            if (key.isString()) {
                if (!key.isEqualString(attribute)) {
                    continue;
                }
            } else if (key.isInteger()) {
                if (!key.translateUnchecked().isEqualString(attribute)) {
                    continue;
                }
            } else {
                result = NONE_SLICE;
                break;
            }
            result = new VPackSlice(this.vpack, key.start + key.getByteSize());
            break;
        }
        return result;
    }

    public VPackSlice keyAt(int index) {
        if (!this.isObject()) {
            throw new VPackValueTypeException(ValueType.OBJECT);
        }
        return this.getNthKey(index);
    }

    public VPackSlice valueAt(int index) {
        if (!this.isObject()) {
            throw new VPackValueTypeException(ValueType.OBJECT);
        }
        VPackSlice key = this.getNthKey(index);
        return new VPackSlice(this.vpack, key.start + key.getByteSize());
    }

    private VPackSlice getNthKey(int index) {
        return new VPackSlice(this.vpack, this.start + this.getNthOffset(index));
    }

    private VPackSlice getNth(int index) {
        return new VPackSlice(this.vpack, this.start + this.getNthOffset(index));
    }

    private int getNthOffset(int index) {
        int offset;
        byte head = this.head();
        if (head == 19 || head == 20) {
            offset = this.getNthOffsetFromCompact(index);
        } else {
            long n;
            if (head == 1 || head == 10) {
                throw new IndexOutOfBoundsException();
            }
            int offsetsize = ObjectArrayUtil.getOffsetSize(head);
            long end = NumberUtil.toLong(this.vpack, this.start + 1, offsetsize);
            int dataOffset = this.findDataOffset();
            if (head <= 5) {
                VPackSlice first = new VPackSlice(this.vpack, this.start + dataOffset);
                n = (end - (long)dataOffset) / (long)first.getByteSize();
            } else {
                n = offsetsize < 8 ? NumberUtil.toLong(this.vpack, this.start + 1 + offsetsize, offsetsize) : NumberUtil.toLong(this.vpack, (int)((long)this.start + end - (long)offsetsize), offsetsize);
            }
            if ((long)index >= n) {
                throw new IndexOutOfBoundsException();
            }
            if (head <= 5 || n == 1L) {
                if (dataOffset == 0) {
                    dataOffset = this.findDataOffset();
                }
                offset = dataOffset + index * new VPackSlice(this.vpack, this.start + dataOffset).getByteSize();
            } else {
                long ieBase = end - n * (long)offsetsize + (long)(index * offsetsize) - (long)(offsetsize == 8 ? 8 : 0);
                offset = (int)NumberUtil.toLong(this.vpack, (int)((long)this.start + ieBase), offsetsize);
            }
        }
        return offset;
    }

    private int getNthOffsetFromCompact(int index) {
        long end = NumberUtil.readVariableValueLength(this.vpack, this.start + 1, false);
        long n = NumberUtil.readVariableValueLength(this.vpack, (int)((long)this.start + end - 1L), true);
        if ((long)index >= n) {
            throw new IndexOutOfBoundsException();
        }
        byte head = this.head();
        long offset = 1L + NumberUtil.getVariableValueLength(end);
        for (long current = 0L; current != (long)index; ++current) {
            long byteSize = new VPackSlice(this.vpack, (int)((long)this.start + offset)).getByteSize();
            offset += byteSize;
            if (head != 20) continue;
            offset += byteSize;
        }
        return (int)offset;
    }

    private boolean isEqualString(String s) {
        String string = this.getAsString();
        return string.equals(s);
    }

    private int compareString(String s) {
        String string = this.getAsString();
        return string.compareTo(s);
    }

    public Iterator<VPackSlice> arrayIterator() {
        if (this.isArray()) {
            return new ArrayIterator(this);
        }
        throw new VPackValueTypeException(ValueType.ARRAY);
    }

    public Iterator<Map.Entry<String, VPackSlice>> objectIterator() {
        if (this.isObject()) {
            return new ObjectIterator(this);
        }
        throw new VPackValueTypeException(ValueType.OBJECT);
    }

    public String toString() {
        try {
            return new VPackParser.Builder().build().toJson(this, true);
        }
        catch (VPackException e) {
            return super.toString();
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.start;
        int arrayHash = 1;
        int max = this.getByteSize();
        for (int i = this.start; i < max; ++i) {
            arrayHash = 31 * arrayHash + this.vpack[i];
        }
        result = 31 * result + arrayHash;
        return result;
    }

    public boolean equals(Object obj) {
        int otherByteSize;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VPackSlice other = (VPackSlice)obj;
        int byteSize = this.getByteSize();
        if (byteSize != (otherByteSize = other.getByteSize())) {
            return false;
        }
        for (int i = 0; i < byteSize; ++i) {
            if (this.vpack[i + this.start] == other.vpack[i + other.start]) continue;
            return false;
        }
        return true;
    }
}

