/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.velocypack;

import com.arangodb.velocypack.VPackSlice;
import com.arangodb.velocypack.VPackStringSlice;
import com.arangodb.velocypack.ValueType;
import com.arangodb.velocypack.exception.VPackBuilderException;
import com.arangodb.velocypack.exception.VPackBuilderKeyAlreadyWrittenException;
import com.arangodb.velocypack.exception.VPackBuilderNeedOpenCompoundException;
import com.arangodb.velocypack.exception.VPackBuilderNeedOpenObjectException;
import com.arangodb.velocypack.exception.VPackBuilderNumberOutOfRangeException;
import com.arangodb.velocypack.exception.VPackBuilderUnexpectedValueException;
import com.arangodb.velocypack.exception.VPackKeyTypeException;
import com.arangodb.velocypack.exception.VPackNeedAttributeTranslatorException;
import com.arangodb.velocypack.exception.VPackValueTypeException;
import com.arangodb.velocypack.internal.DefaultVPackBuilderOptions;
import com.arangodb.velocypack.internal.Value;
import com.arangodb.velocypack.internal.util.NumberUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class VPackBuilder {
    private static final int INTEGER_BYTES = 4;
    private static final int LONG_BYTES = 8;
    private static final int DOUBLE_BYTES = 8;
    private static final Appender<Value> VALUE = new Appender<Value>(){

        @Override
        public void append(VPackBuilder builder, Value value) throws VPackBuilderException {
            builder.set(value);
        }
    };
    private static final Appender<ValueType> VALUE_TYPE = new Appender<ValueType>(){

        @Override
        public void append(VPackBuilder builder, ValueType value) throws VPackBuilderException {
            switch (value) {
                case NULL: {
                    builder.appendNull();
                    break;
                }
                case ARRAY: {
                    builder.addArray(false);
                    break;
                }
                case OBJECT: {
                    builder.addObject(false);
                    break;
                }
                default: {
                    throw new VPackValueTypeException(ValueType.ARRAY, ValueType.OBJECT, ValueType.NULL);
                }
            }
        }
    };
    private static final Appender<Boolean> BOOLEAN = new Appender<Boolean>(){

        @Override
        public void append(VPackBuilder builder, Boolean value) throws VPackBuilderException {
            builder.appendBoolean(value);
        }
    };
    private static final Appender<Double> DOUBLE = new Appender<Double>(){

        @Override
        public void append(VPackBuilder builder, Double value) throws VPackBuilderException {
            builder.appendDouble(value);
        }
    };
    private static final Appender<Float> FLOAT = new Appender<Float>(){

        @Override
        public void append(VPackBuilder builder, Float value) throws VPackBuilderException {
            builder.appendDouble(value.floatValue());
        }
    };
    private static final Appender<BigDecimal> BIG_DECIMAL = new Appender<BigDecimal>(){

        @Override
        public void append(VPackBuilder builder, BigDecimal value) throws VPackBuilderException {
            builder.appendString(value.toString());
        }
    };
    private static final Appender<Long> LONG = new Appender<Long>(){

        @Override
        public void append(VPackBuilder builder, Long value) throws VPackBuilderException {
            if (value <= 9L && value >= -6L) {
                builder.appendSmallInt(value);
            } else {
                builder.add((byte)39);
                builder.append(value, 8);
            }
        }
    };
    private static final Appender<Integer> INTEGER = new Appender<Integer>(){

        @Override
        public void append(VPackBuilder builder, Integer value) throws VPackBuilderException {
            if (value <= 9 && value >= -6) {
                builder.appendSmallInt(value.intValue());
            } else {
                builder.add((byte)35);
                builder.append(value.intValue(), 4);
            }
        }
    };
    private static final Appender<Short> SHORT = new Appender<Short>(){

        @Override
        public void append(VPackBuilder builder, Short value) throws VPackBuilderException {
            if (value <= 9 && value >= -6) {
                builder.appendSmallInt(value.shortValue());
            } else {
                builder.add((byte)35);
                builder.append(value.shortValue(), 4);
            }
        }
    };
    private static final Appender<Byte> BYTE = new Appender<Byte>(){

        @Override
        public void append(VPackBuilder builder, Byte value) {
            if (value <= 9 && value >= -6) {
                builder.appendSmallInt(value.byteValue());
            } else {
                builder.add((byte)35);
                builder.append(value.byteValue(), 4);
            }
        }
    };
    private static final Appender<BigInteger> BIG_INTEGER = new Appender<BigInteger>(){

        @Override
        public void append(VPackBuilder builder, BigInteger value) throws VPackBuilderException {
            builder.appendString(value.toString());
        }
    };
    private static final Appender<java.util.Date> DATE = new Appender<java.util.Date>(){

        @Override
        public void append(VPackBuilder builder, java.util.Date value) throws VPackBuilderException {
            builder.appendDate(value);
        }
    };
    private static final Appender<Date> SQL_DATE = new Appender<Date>(){

        @Override
        public void append(VPackBuilder builder, Date value) throws VPackBuilderException {
            builder.appendSQLDate(value);
        }
    };
    private static final Appender<Timestamp> SQL_TIMESTAMP = new Appender<Timestamp>(){

        @Override
        public void append(VPackBuilder builder, Timestamp value) throws VPackBuilderException {
            builder.appendSQLTimestamp(value);
        }
    };
    private static final Appender<String> STRING = new Appender<String>(){

        @Override
        public void append(VPackBuilder builder, String value) throws VPackBuilderException {
            builder.appendString(value);
        }
    };
    private static final Appender<Character> CHARACTER = new Appender<Character>(){

        @Override
        public void append(VPackBuilder builder, Character value) throws VPackBuilderException {
            builder.appendString(String.valueOf(value));
        }
    };
    private static final Appender<byte[]> BYTE_ARRAY = new Appender<byte[]>(){

        @Override
        public void append(VPackBuilder builder, byte[] value) throws VPackBuilderException {
            builder.appendBinary(value);
        }
    };
    private static final Appender<VPackSlice> VPACK = new Appender<VPackSlice>(){

        @Override
        public void append(VPackBuilder builder, VPackSlice value) throws VPackBuilderException {
            builder.appendVPack(value);
        }
    };
    private byte[] buffer;
    private int size;
    private final List<Integer> stack;
    private final List<List<Integer>> index;
    private boolean keyWritten;
    private final BuilderOptions options;

    public VPackBuilder() {
        this(new DefaultVPackBuilderOptions());
    }

    public VPackBuilder(BuilderOptions options) {
        this.options = options;
        this.size = 0;
        this.buffer = new byte[10];
        this.stack = new ArrayList<Integer>();
        this.index = new ArrayList<List<Integer>>(4);
    }

    public BuilderOptions getOptions() {
        return this.options;
    }

    private void add(byte b) {
        this.ensureCapacity(this.size + 1);
        this.buffer[this.size++] = b;
    }

    private void addUnchecked(byte b) {
        this.buffer[this.size++] = b;
    }

    private void remove(int index) {
        int numMoved = this.size - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.buffer, index + 1, this.buffer, index, numMoved);
        }
        this.buffer[--this.size] = 0;
    }

    private void ensureCapacity(int minCapacity) {
        int oldCapacity = this.buffer.length;
        if (minCapacity > oldCapacity) {
            byte[] oldData = this.buffer;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.buffer = Arrays.copyOf(oldData, newCapacity);
        }
    }

    private void appendTag(long tag) {
        if (tag <= 255L) {
            this.ensureCapacity(2);
            this.addUnchecked((byte)-18);
            this.append(tag, 1);
        } else {
            this.ensureCapacity(9);
            this.addUnchecked((byte)-17);
            this.append(tag, 8);
        }
    }

    public VPackBuilder add(ValueType value) throws VPackBuilderException {
        return this.addInternal(VALUE_TYPE, value);
    }

    public VPackBuilder add(ValueType value, boolean unindexed) throws VPackBuilderException {
        return this.addInternal(VALUE, new Value(value, unindexed));
    }

    public VPackBuilder add(Boolean value) throws VPackBuilderException {
        return this.addInternal(BOOLEAN, value);
    }

    public VPackBuilder add(Double value) throws VPackBuilderException {
        return this.addInternal(DOUBLE, value);
    }

    public VPackBuilder add(Float value) throws VPackBuilderException {
        return this.addInternal(FLOAT, value);
    }

    public VPackBuilder add(BigDecimal value) throws VPackBuilderException {
        return this.addInternal(BIG_DECIMAL, value);
    }

    public VPackBuilder add(Long value) throws VPackBuilderException {
        return this.addInternal(LONG, value);
    }

    public VPackBuilder add(Long value, ValueType type) throws VPackBuilderException {
        return this.addInternal(VALUE, new Value(value, type));
    }

    public VPackBuilder add(Integer value) throws VPackBuilderException {
        return this.addInternal(INTEGER, value);
    }

    public VPackBuilder add(Short value) throws VPackBuilderException {
        return this.addInternal(SHORT, value);
    }

    public VPackBuilder add(BigInteger value) throws VPackBuilderException {
        return this.addInternal(BIG_INTEGER, value);
    }

    public VPackBuilder add(BigInteger value, ValueType type) throws VPackBuilderException {
        return this.addInternal(VALUE, new Value(value, type));
    }

    public VPackBuilder add(java.util.Date value) throws VPackBuilderException {
        return this.addInternal(DATE, value);
    }

    public VPackBuilder add(Date value) throws VPackBuilderException {
        return this.addInternal(SQL_DATE, value);
    }

    public VPackBuilder add(Timestamp value) throws VPackBuilderException {
        return this.addInternal(SQL_TIMESTAMP, value);
    }

    public VPackBuilder add(String value) throws VPackBuilderException {
        return this.addInternal(STRING, value);
    }

    public VPackBuilder add(Character value) throws VPackBuilderException {
        return this.addInternal(CHARACTER, value);
    }

    public VPackBuilder add(byte[] value) throws VPackBuilderException {
        return this.addInternal(BYTE_ARRAY, value);
    }

    public VPackBuilder add(VPackSlice value) throws VPackBuilderException {
        return this.addInternal(VPACK, value);
    }

    public VPackBuilder add(String attribute, ValueType value) throws VPackBuilderException {
        return this.addInternal(attribute, VALUE_TYPE, value);
    }

    public VPackBuilder add(String attribute, ValueType value, boolean unindexed) throws VPackBuilderException {
        return this.addInternal(attribute, VALUE, new Value(value, unindexed));
    }

    public VPackBuilder add(String attribute, Boolean value) throws VPackBuilderException {
        return this.addInternal(attribute, BOOLEAN, value);
    }

    public VPackBuilder add(String attribute, Double value) throws VPackBuilderException {
        return this.addInternal(attribute, DOUBLE, value);
    }

    public VPackBuilder add(String attribute, Float value) throws VPackBuilderException {
        return this.addInternal(attribute, FLOAT, value);
    }

    public VPackBuilder add(String attribute, BigDecimal value) throws VPackBuilderException {
        return this.addInternal(attribute, BIG_DECIMAL, value);
    }

    public VPackBuilder add(String attribute, Long value) throws VPackBuilderException {
        return this.addInternal(attribute, LONG, value);
    }

    public VPackBuilder add(String attribute, Long value, ValueType type) throws VPackBuilderException {
        return this.addInternal(attribute, VALUE, new Value(value, type));
    }

    public VPackBuilder add(String attribute, Integer value) throws VPackBuilderException {
        return this.addInternal(attribute, INTEGER, value);
    }

    public VPackBuilder add(String attribute, Short value) throws VPackBuilderException {
        return this.addInternal(attribute, SHORT, value);
    }

    public VPackBuilder add(String attribute, Byte value) throws VPackBuilderException {
        return this.addInternal(attribute, BYTE, value);
    }

    public VPackBuilder add(String attribute, BigInteger value) throws VPackBuilderException {
        return this.addInternal(attribute, BIG_INTEGER, value);
    }

    public VPackBuilder add(String attribute, BigInteger value, ValueType type) throws VPackBuilderException {
        return this.addInternal(attribute, VALUE, new Value(value, type));
    }

    public VPackBuilder add(String attribute, String value) throws VPackBuilderException {
        return this.addInternal(attribute, STRING, value);
    }

    public VPackBuilder add(String attribute, Character value) throws VPackBuilderException {
        return this.addInternal(attribute, CHARACTER, value);
    }

    public VPackBuilder add(String attribute, java.util.Date value) throws VPackBuilderException {
        return this.addInternal(attribute, DATE, value);
    }

    public VPackBuilder add(String attribute, Date value) throws VPackBuilderException {
        return this.addInternal(attribute, SQL_DATE, value);
    }

    public VPackBuilder add(String attribute, Timestamp value) throws VPackBuilderException {
        return this.addInternal(attribute, SQL_TIMESTAMP, value);
    }

    public VPackBuilder add(String attribute, byte[] value) throws VPackBuilderException {
        return this.addInternal(attribute, BYTE_ARRAY, value);
    }

    public VPackBuilder add(String attribute, VPackSlice value) throws VPackBuilderException {
        return this.addInternal(attribute, VPACK, value);
    }

    public VPackBuilder addTagged(long tag, ValueType value) throws VPackBuilderException {
        return this.addInternal(tag, VALUE_TYPE, value);
    }

    public VPackBuilder addTagged(long tag, ValueType value, boolean unindexed) throws VPackBuilderException {
        return this.addInternal(tag, VALUE, new Value(value, unindexed));
    }

    public VPackBuilder addTagged(long tag, Boolean value) throws VPackBuilderException {
        return this.addInternal(tag, BOOLEAN, value);
    }

    public VPackBuilder addTagged(long tag, Double value) throws VPackBuilderException {
        return this.addInternal(tag, DOUBLE, value);
    }

    public VPackBuilder addTagged(long tag, Float value) throws VPackBuilderException {
        return this.addInternal(tag, FLOAT, value);
    }

    public VPackBuilder addTagged(long tag, BigDecimal value) throws VPackBuilderException {
        return this.addInternal(tag, BIG_DECIMAL, value);
    }

    public VPackBuilder addTagged(long tag, Long value) throws VPackBuilderException {
        return this.addInternal(tag, LONG, value);
    }

    public VPackBuilder addTagged(long tag, Long value, ValueType type) throws VPackBuilderException {
        return this.addInternal(tag, VALUE, new Value(value, type));
    }

    public VPackBuilder addTagged(long tag, Integer value) throws VPackBuilderException {
        return this.addInternal(tag, INTEGER, value);
    }

    public VPackBuilder addTagged(long tag, Short value) throws VPackBuilderException {
        return this.addInternal(tag, SHORT, value);
    }

    public VPackBuilder addTagged(long tag, BigInteger value) throws VPackBuilderException {
        return this.addInternal(tag, BIG_INTEGER, value);
    }

    public VPackBuilder addTagged(long tag, BigInteger value, ValueType type) throws VPackBuilderException {
        return this.addInternal(tag, VALUE, new Value(value, type));
    }

    public VPackBuilder addTagged(long tag, java.util.Date value) throws VPackBuilderException {
        return this.addInternal(tag, DATE, value);
    }

    public VPackBuilder addTagged(long tag, Date value) throws VPackBuilderException {
        return this.addInternal(tag, SQL_DATE, value);
    }

    public VPackBuilder addTagged(long tag, Timestamp value) throws VPackBuilderException {
        return this.addInternal(tag, SQL_TIMESTAMP, value);
    }

    public VPackBuilder addTagged(long tag, String value) throws VPackBuilderException {
        return this.addInternal(tag, STRING, value);
    }

    public VPackBuilder addTagged(long tag, Character value) throws VPackBuilderException {
        return this.addInternal(tag, CHARACTER, value);
    }

    public VPackBuilder addTagged(long tag, byte[] value) throws VPackBuilderException {
        return this.addInternal(tag, BYTE_ARRAY, value);
    }

    public VPackBuilder addTagged(long tag, VPackSlice value) throws VPackBuilderException {
        return this.addInternal(tag, VPACK, value);
    }

    public VPackBuilder addTagged(String attribute, long tag, ValueType value) throws VPackBuilderException {
        return this.addInternal(attribute, tag, VALUE_TYPE, value);
    }

    public VPackBuilder addTagged(String attribute, long tag, ValueType value, boolean unindexed) throws VPackBuilderException {
        return this.addInternal(attribute, tag, VALUE, new Value(value, unindexed));
    }

    public VPackBuilder addTagged(String attribute, long tag, Boolean value) throws VPackBuilderException {
        return this.addInternal(attribute, tag, BOOLEAN, value);
    }

    public VPackBuilder addTagged(String attribute, long tag, Double value) throws VPackBuilderException {
        return this.addInternal(attribute, tag, DOUBLE, value);
    }

    public VPackBuilder addTagged(String attribute, long tag, Float value) throws VPackBuilderException {
        return this.addInternal(attribute, tag, FLOAT, value);
    }

    public VPackBuilder addTagged(String attribute, long tag, BigDecimal value) throws VPackBuilderException {
        return this.addInternal(attribute, tag, BIG_DECIMAL, value);
    }

    public VPackBuilder addTagged(String attribute, long tag, Long value) throws VPackBuilderException {
        return this.addInternal(attribute, tag, LONG, value);
    }

    public VPackBuilder addTagged(String attribute, long tag, Long value, ValueType type) throws VPackBuilderException {
        return this.addInternal(attribute, tag, VALUE, new Value(value, type));
    }

    public VPackBuilder addTagged(String attribute, long tag, Integer value) throws VPackBuilderException {
        return this.addInternal(attribute, tag, INTEGER, value);
    }

    public VPackBuilder addTagged(String attribute, long tag, Short value) throws VPackBuilderException {
        return this.addInternal(attribute, tag, SHORT, value);
    }

    public VPackBuilder addTagged(String attribute, long tag, Byte value) throws VPackBuilderException {
        return this.addInternal(attribute, tag, BYTE, value);
    }

    public VPackBuilder addTagged(String attribute, long tag, BigInteger value) throws VPackBuilderException {
        return this.addInternal(attribute, tag, BIG_INTEGER, value);
    }

    public VPackBuilder addTagged(String attribute, long tag, BigInteger value, ValueType type) throws VPackBuilderException {
        return this.addInternal(attribute, tag, VALUE, new Value(value, type));
    }

    public VPackBuilder addTagged(String attribute, long tag, String value) throws VPackBuilderException {
        return this.addInternal(attribute, tag, STRING, value);
    }

    public VPackBuilder addTagged(String attribute, long tag, Character value) throws VPackBuilderException {
        return this.addInternal(attribute, tag, CHARACTER, value);
    }

    public VPackBuilder addTagged(String attribute, long tag, java.util.Date value) throws VPackBuilderException {
        return this.addInternal(attribute, tag, DATE, value);
    }

    public VPackBuilder addTagged(String attribute, long tag, Date value) throws VPackBuilderException {
        return this.addInternal(attribute, tag, SQL_DATE, value);
    }

    public VPackBuilder addTagged(String attribute, long tag, Timestamp value) throws VPackBuilderException {
        return this.addInternal(attribute, tag, SQL_TIMESTAMP, value);
    }

    public VPackBuilder addTagged(String attribute, long tag, byte[] value) throws VPackBuilderException {
        return this.addInternal(attribute, tag, BYTE_ARRAY, value);
    }

    public VPackBuilder addTagged(String attribute, long tag, VPackSlice value) throws VPackBuilderException {
        return this.addInternal(attribute, tag, VPACK, value);
    }

    private <T> VPackBuilder addInternal(Appender<T> appender, T value) throws VPackBuilderException {
        return this.addInternal(0L, appender, value);
    }

    private <T> VPackBuilder addInternal(long tag, Appender<T> appender, T value) throws VPackBuilderException {
        boolean haveReported = false;
        if (!this.stack.isEmpty() && !this.keyWritten) {
            this.reportAdd();
            haveReported = true;
        }
        if (tag != 0L) {
            this.appendTag(tag);
        }
        try {
            if (value == null) {
                this.appendNull();
            } else {
                appender.append(this, value);
            }
        }
        catch (VPackBuilderException e) {
            if (haveReported) {
                this.cleanupAdd();
            }
            throw e;
        }
        return this;
    }

    private <T> VPackBuilder addInternal(String attribute, Appender<T> appender, T value) throws VPackBuilderException {
        return this.addInternal(attribute, 0L, appender, value);
    }

    private <T> VPackBuilder addInternal(String attribute, long tag, Appender<T> appender, T value) throws VPackBuilderException {
        if (attribute != null) {
            boolean haveReported = false;
            if (!this.stack.isEmpty()) {
                byte head = this.head();
                if (head != 11 && head != 20) {
                    throw new VPackBuilderNeedOpenObjectException();
                }
                if (this.keyWritten) {
                    throw new VPackBuilderKeyAlreadyWrittenException();
                }
                this.reportAdd();
                haveReported = true;
            }
            try {
                VPackSlice translate;
                if (VPackSlice.attributeTranslator != null && (translate = VPackSlice.attributeTranslator.translate(attribute)) != null) {
                    byte[] trValue = translate.getBuffer();
                    int trValueLength = translate.getByteSize();
                    int trValueStart = translate.getStart();
                    this.ensureCapacity(this.size + trValueLength);
                    for (int i = 0; i < trValueLength; ++i) {
                        this.addUnchecked(trValue[i + trValueStart]);
                    }
                    this.keyWritten = true;
                    if (value == null) {
                        this.appendNull();
                    } else {
                        appender.append(this, value);
                    }
                    VPackBuilder vPackBuilder = this;
                    return vPackBuilder;
                }
                STRING.append(this, attribute);
                this.keyWritten = true;
                if (tag != 0L) {
                    this.appendTag(tag);
                }
                if (value == null) {
                    this.appendNull();
                }
                appender.append(this, value);
            }
            catch (VPackBuilderException e) {
                if (haveReported) {
                    this.cleanupAdd();
                }
                throw e;
            }
            finally {
                this.keyWritten = false;
            }
        } else {
            this.addInternal(appender, value);
        }
        return this;
    }

    private void set(Value item) throws VPackBuilderException {
        Class<?> clazz = item.getClazz();
        switch (item.getType()) {
            case NULL: {
                this.appendNull();
                break;
            }
            case ARRAY: {
                this.addArray(item.isUnindexed());
                break;
            }
            case OBJECT: {
                this.addObject(item.isUnindexed());
                break;
            }
            case SMALLINT: {
                long vSmallInt = item.getNumber().longValue();
                if (vSmallInt < -6L || vSmallInt > 9L) {
                    throw new VPackBuilderNumberOutOfRangeException(ValueType.SMALLINT);
                }
                this.appendSmallInt(vSmallInt);
                break;
            }
            case INT: {
                if (clazz != Long.class && clazz != BigInteger.class) {
                    throw new VPackBuilderUnexpectedValueException(ValueType.INT, Long.class, Integer.class, BigInteger.class, Short.class);
                }
                this.add((byte)39);
                int length = 8;
                this.append(item.getNumber().longValue(), length);
                break;
            }
            case UINT: {
                BigInteger vUInt;
                if (clazz == Long.class) {
                    vUInt = BigInteger.valueOf(item.getLong());
                } else if (clazz == BigInteger.class) {
                    vUInt = item.getBigInteger();
                } else {
                    throw new VPackBuilderUnexpectedValueException(ValueType.UINT, Long.class, Integer.class, BigInteger.class);
                }
                if (vUInt.compareTo(BigInteger.ZERO) < 0) {
                    throw new VPackBuilderUnexpectedValueException(ValueType.UINT, "non-negative", Long.class, Integer.class, BigInteger.class);
                }
                this.appendUInt(vUInt);
                break;
            }
        }
    }

    private void appendNull() {
        this.add((byte)24);
    }

    private void appendBoolean(boolean value) {
        if (value) {
            this.add((byte)26);
        } else {
            this.add((byte)25);
        }
    }

    private void appendDouble(double value) {
        this.add((byte)27);
        this.append(value);
    }

    private void append(double value) {
        this.append(Double.doubleToRawLongBits(value), 8);
    }

    private void appendSmallInt(long value) {
        if (value >= 0L) {
            this.add((byte)(value + 48L));
        } else {
            this.add((byte)(value + 64L));
        }
    }

    private void appendUInt(BigInteger value) {
        this.add((byte)47);
        this.append(value);
    }

    private void append(long value, int length) {
        this.ensureCapacity(this.size + length);
        for (int i = length - 1; i >= 0; --i) {
            this.addUnchecked((byte)(value >> (length - i - 1 << 3)));
        }
    }

    private void append(BigInteger value) {
        this.ensureCapacity(this.size + 8);
        for (int i = 7; i >= 0; --i) {
            this.addUnchecked(value.shiftRight(8 - i - 1 << 3).byteValue());
        }
    }

    private void appendDate(java.util.Date value) {
        this.add((byte)28);
        this.append(value.getTime(), 8);
    }

    private void appendSQLDate(Date value) {
        this.add((byte)28);
        this.append(value.getTime(), 8);
    }

    private void appendSQLTimestamp(Timestamp value) {
        this.add((byte)28);
        this.append(value.getTime(), 8);
    }

    private void appendString(String value) {
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        int length = bytes.length;
        if (length <= 126) {
            this.add((byte)(64 + length));
        } else {
            this.add((byte)-65);
            this.appendLength(length);
        }
        this.appendString(bytes);
    }

    private void appendString(byte[] bytes) {
        this.ensureCapacity(this.size + bytes.length);
        System.arraycopy(bytes, 0, this.buffer, this.size, bytes.length);
        this.size += bytes.length;
    }

    private void appendBinary(byte[] value) {
        this.add((byte)-61);
        this.append(value.length, 4);
        this.ensureCapacity(this.size + value.length);
        System.arraycopy(value, 0, this.buffer, this.size, value.length);
        this.size += value.length;
    }

    private void appendVPack(VPackSlice value) {
        byte[] vpack = value.getBuffer();
        int length = value.getByteSize();
        this.ensureCapacity(this.size + length);
        System.arraycopy(vpack, value.getStart(), this.buffer, this.size, length);
        this.size += length;
    }

    private void addArray(boolean unindexed) {
        this.addCompoundValue((byte)(unindexed ? 19 : 6));
    }

    private void addObject(boolean unindexed) {
        this.addCompoundValue((byte)(unindexed ? 20 : 11));
    }

    private void addCompoundValue(byte head) {
        this.stack.add(this.size);
        this.index.add(this.stack.size() - 1, new ArrayList());
        this.add(head);
        this.size += 8;
        this.ensureCapacity(this.size);
    }

    private void appendLength(long length) {
        this.append(length, 8);
    }

    private void reportAdd() {
        Collection depth = this.index.get(this.stack.size() - 1);
        depth.add(this.size - this.stack.get(this.stack.size() - 1));
    }

    private void cleanupAdd() {
        List<Integer> depth = this.index.get(this.stack.size() - 1);
        depth.remove(depth.size() - 1);
    }

    public VPackBuilder close() throws VPackBuilderException {
        try {
            return this.close(true);
        }
        catch (VPackKeyTypeException | VPackNeedAttributeTranslatorException e) {
            throw new VPackBuilderException(e);
        }
    }

    protected VPackBuilder close(boolean sort) throws VPackBuilderNeedOpenCompoundException, VPackKeyTypeException, VPackNeedAttributeTranslatorException {
        int i;
        if (this.isClosed()) {
            throw new VPackBuilderNeedOpenCompoundException();
        }
        byte head = this.head();
        boolean isArray = head == 6 || head == 19;
        List<Integer> in = this.index.get(this.stack.size() - 1);
        int tos = this.stack.get(this.stack.size() - 1);
        if (in.isEmpty()) {
            return this.closeEmptyArrayOrObject(tos, isArray);
        }
        if ((head == 19 || head == 20 || head == 6 && this.options.isBuildUnindexedArrays() || head == 11 && (this.options.isBuildUnindexedObjects() || in.size() == 1)) && this.closeCompactArrayOrObject(tos, isArray, in)) {
            return this;
        }
        if (isArray) {
            return this.closeArray(tos, in);
        }
        this.buffer[tos] = 11;
        int offsetSize = this.size - tos + in.size() - 6 <= 255 ? 1 : (this.size - tos + 2 * in.size() <= 65535 ? 2 : 4);
        if (offsetSize == 1) {
            int targetPos = 3;
            if (this.size - 1 > tos + 9) {
                for (int i2 = tos + 3; i2 < tos + 9; ++i2) {
                    this.remove(tos + 3);
                }
            }
            int diff = 6;
            int n = in.size();
            for (int i3 = 0; i3 < n; ++i3) {
                in.set(i3, in.get(i3) - 6);
            }
        }
        if (sort && in.size() >= 2) {
            this.sortObjectIndex(tos, in);
        }
        Iterator<Integer> targetPos = in.iterator();
        while (targetPos.hasNext()) {
            long x = targetPos.next().intValue();
            this.ensureCapacity(this.size + offsetSize);
            for (int j = 0; j < offsetSize; ++j) {
                this.addUnchecked((byte)(x & 0xFFL));
                x >>= 8;
            }
        }
        if (offsetSize > 1) {
            this.buffer[tos] = offsetSize == 2 ? (byte)(this.buffer[tos] + 1) : (byte)(this.buffer[tos] + 2);
        }
        long x = this.size - tos;
        for (i = 1; i <= offsetSize; ++i) {
            this.buffer[tos + i] = (byte)(x & 0xFFL);
            x >>= 8;
        }
        x = in.size();
        for (i = offsetSize + 1; i <= 2 * offsetSize; ++i) {
            this.buffer[tos + i] = (byte)(x & 0xFFL);
            x >>= 8;
        }
        this.stack.remove(this.stack.size() - 1);
        return this;
    }

    private VPackBuilder closeEmptyArrayOrObject(int tos, boolean isArray) {
        this.buffer[tos] = (byte)(isArray ? 1 : 10);
        for (int i = 1; i <= 8; ++i) {
            this.remove(tos + 1);
        }
        this.stack.remove(this.stack.size() - 1);
        return this;
    }

    private boolean closeCompactArrayOrObject(int tos, boolean isArray, List<Integer> in) {
        long bLen;
        long nLen = NumberUtil.getVariableValueLength(in.size());
        long byteSize = (long)(this.size - (tos + 8)) + nLen;
        if (NumberUtil.getVariableValueLength(byteSize += (bLen = NumberUtil.getVariableValueLength(byteSize))) != bLen) {
            ++byteSize;
            ++bLen;
        }
        if (bLen < 9L) {
            this.buffer[tos] = (byte)(isArray ? 19 : 20);
            int targetPos = (int)(1L + bLen);
            if (this.size - 1 > tos + 9) {
                for (int i = tos + targetPos; i < tos + 9; ++i) {
                    this.remove(tos + targetPos);
                }
            }
            this.storeVariableValueLength(tos, byteSize, false);
            if (nLen > 8L - bLen) {
                this.ensureCapacity((int)((long)this.size + nLen));
            }
            this.storeVariableValueLength((int)((long)tos + byteSize), in.size(), true);
            this.size = (int)((long)this.size + nLen);
            this.stack.remove(this.stack.size() - 1);
            return true;
        }
        return false;
    }

    private void storeVariableValueLength(int offset, long value, boolean reverse) {
        long val;
        int i = offset;
        if (reverse) {
            for (val = value; val >= 128L; val >>= 7) {
                this.buffer[--i] = (byte)((byte)(val & 0x7FL) | 0xFFFFFF80);
            }
            this.buffer[--i] = (byte)(val & 0x7FL);
        } else {
            while (val >= 128L) {
                this.buffer[++i] = (byte)((byte)(val & 0x7FL) | 0xFFFFFF80);
                val >>= 7;
            }
            this.buffer[++i] = (byte)(val & 0x7FL);
        }
    }

    private VPackBuilder closeArray(int tos, List<Integer> in) {
        int i;
        int i2;
        this.buffer[tos] = 6;
        boolean needIndexTable = true;
        boolean needNrSubs = true;
        int n = in.size();
        if (n == 1) {
            needIndexTable = false;
            needNrSubs = false;
        } else if (this.size - tos - in.get(0) == n * (in.get(1) - in.get(0))) {
            boolean noTable = true;
            int subLen = in.get(1) - in.get(0);
            if (this.size - tos - in.get(n - 1) != subLen) {
                noTable = false;
            } else {
                for (i2 = 1; i2 < n - 1; ++i2) {
                    if (in.get(i2 + 1) - in.get(i2) == subLen) continue;
                    noTable = false;
                    break;
                }
            }
            if (noTable) {
                needIndexTable = false;
                needNrSubs = false;
            }
        }
        int offsetSize = this.size - tos + (needIndexTable ? n : 0) - (needNrSubs ? 6 : 7) <= 255 ? 1 : (this.size - tos + (needIndexTable ? 2 * n : 0) <= 65535 ? 2 : 4);
        if (offsetSize == 1) {
            int targetPos = 3;
            if (!needIndexTable) {
                targetPos = 2;
            }
            if (this.size - 1 > tos + 9) {
                for (i2 = tos + targetPos; i2 < tos + 9; ++i2) {
                    this.remove(tos + targetPos);
                }
            }
            int diff = 9 - targetPos;
            if (needIndexTable) {
                for (i = 0; i < n; ++i) {
                    in.set(i, in.get(i) - diff);
                }
            }
        }
        if (needIndexTable) {
            Iterator<Integer> targetPos = in.iterator();
            while (targetPos.hasNext()) {
                long x = targetPos.next().intValue();
                this.ensureCapacity(this.size + offsetSize);
                for (int j = 0; j < offsetSize; ++j) {
                    this.addUnchecked((byte)(x & 0xFFL));
                    x >>= 8;
                }
            }
        } else {
            this.buffer[tos] = 2;
        }
        if (offsetSize > 1) {
            this.buffer[tos] = offsetSize == 2 ? (byte)(this.buffer[tos] + 1) : (byte)(this.buffer[tos] + 2);
        }
        long x = this.size - tos;
        for (i = 1; i <= offsetSize; ++i) {
            this.buffer[tos + i] = (byte)(x & 0xFFL);
            x >>= 8;
        }
        if (needNrSubs) {
            x = n;
            for (i = offsetSize + 1; i <= 2 * offsetSize; ++i) {
                this.buffer[tos + i] = (byte)(x & 0xFFL);
                x >>= 8;
            }
        }
        this.stack.remove(this.stack.size() - 1);
        return this;
    }

    private void sortObjectIndex(int start, List<Integer> offsets) throws VPackKeyTypeException, VPackNeedAttributeTranslatorException {
        SortEntry[] attributes = new SortEntry[offsets.size()];
        for (int i = 0; i < offsets.size(); ++i) {
            Integer offset = offsets.get(i);
            attributes[i] = new SortEntry(new VPackSlice(this.buffer, start + offset).makeKey().getAsStringSlice(), offset);
        }
        Comparator<SortEntry> comparator = new Comparator<SortEntry>(){

            @Override
            public int compare(SortEntry o1, SortEntry o2) {
                return o1.slice.compareTo(o2.slice);
            }
        };
        Arrays.sort(attributes, comparator);
        offsets.clear();
        for (SortEntry sortEntry : attributes) {
            offsets.add(sortEntry.offset);
        }
    }

    public static int compareTo(byte[] b1, int b1Index, int b1Length, byte[] b2, int b2Index, int b2Length) {
        int commonLength = Math.min(b1Length, b2Length);
        for (int i = 0; i < commonLength; ++i) {
            byte byte1 = b1[b1Index + i];
            byte byte2 = b2[b2Index + i];
            if (byte1 == byte2) continue;
            return byte1 < byte2 ? -1 : 1;
        }
        if (b1Length != b2Length) {
            return b1Length < b2Length ? -2 : 2;
        }
        return 0;
    }

    private boolean isClosed() {
        return this.stack.isEmpty();
    }

    private byte head() {
        Integer in = this.stack.get(this.stack.size() - 1);
        return this.buffer[in];
    }

    public VPackSlice slice() {
        return new VPackSlice(this.buffer);
    }

    public int getVpackSize() {
        return this.size;
    }

    private static class SortEntry {
        private final VPackStringSlice slice;
        private final int offset;

        public SortEntry(VPackStringSlice slice, int offset) {
            this.slice = slice;
            this.offset = offset;
        }
    }

    public static interface Appender<T> {
        public void append(VPackBuilder var1, T var2) throws VPackBuilderException;
    }

    public static interface BuilderOptions {
        public boolean isBuildUnindexedArrays();

        public void setBuildUnindexedArrays(boolean var1);

        public boolean isBuildUnindexedObjects();

        public void setBuildUnindexedObjects(boolean var1);
    }
}

