/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.model;

import com.arangodb.velocypack.VPackSlice;
import com.arangodb.velocypack.annotations.Expose;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class AqlQueryOptions
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Boolean count;
    private Integer ttl;
    private Integer batchSize;
    private Boolean cache;
    private Long memoryLimit;
    private VPackSlice bindVars;
    private String query;
    private Options options;
    @Expose(serialize=false)
    private Boolean allowDirtyRead;
    private String streamTransactionId;

    public Boolean getCount() {
        return this.count;
    }

    public AqlQueryOptions count(Boolean count) {
        this.count = count;
        return this;
    }

    public Integer getTtl() {
        return this.ttl;
    }

    public AqlQueryOptions ttl(Integer ttl) {
        this.ttl = ttl;
        return this;
    }

    public Integer getBatchSize() {
        return this.batchSize;
    }

    public AqlQueryOptions batchSize(Integer batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public Long getMemoryLimit() {
        return this.memoryLimit;
    }

    public AqlQueryOptions memoryLimit(Long memoryLimit) {
        this.memoryLimit = memoryLimit;
        return this;
    }

    public Boolean getCache() {
        return this.cache;
    }

    public AqlQueryOptions cache(Boolean cache) {
        this.cache = cache;
        return this;
    }

    protected VPackSlice getBindVars() {
        return this.bindVars;
    }

    protected AqlQueryOptions bindVars(VPackSlice bindVars) {
        this.bindVars = bindVars;
        return this;
    }

    protected String getQuery() {
        return this.query;
    }

    protected AqlQueryOptions query(String query) {
        this.query = query;
        return this;
    }

    public Boolean getFailOnWarning() {
        return this.options != null ? this.options.failOnWarning : null;
    }

    public AqlQueryOptions failOnWarning(Boolean failOnWarning) {
        this.getOptions().failOnWarning = failOnWarning;
        return this;
    }

    public Boolean getProfile() {
        return this.options != null ? this.options.profile : null;
    }

    public AqlQueryOptions profile(Boolean profile) {
        this.getOptions().profile = profile;
        return this;
    }

    public Long getMaxTransactionSize() {
        return this.options != null ? this.options.maxTransactionSize : null;
    }

    public AqlQueryOptions maxTransactionSize(Long maxTransactionSize) {
        this.getOptions().maxTransactionSize = maxTransactionSize;
        return this;
    }

    public Long getMaxWarningCount() {
        return this.options != null ? this.options.maxWarningCount : null;
    }

    public AqlQueryOptions maxWarningCount(Long maxWarningCount) {
        this.getOptions().maxWarningCount = maxWarningCount;
        return this;
    }

    public Long getIntermediateCommitCount() {
        return this.options != null ? this.options.intermediateCommitCount : null;
    }

    public AqlQueryOptions intermediateCommitCount(Long intermediateCommitCount) {
        this.getOptions().intermediateCommitCount = intermediateCommitCount;
        return this;
    }

    public Long getIntermediateCommitSize() {
        return this.options != null ? this.options.intermediateCommitSize : null;
    }

    public AqlQueryOptions intermediateCommitSize(Long intermediateCommitSize) {
        this.getOptions().intermediateCommitSize = intermediateCommitSize;
        return this;
    }

    public Double getSatelliteSyncWait() {
        return this.options != null ? this.options.satelliteSyncWait : null;
    }

    public AqlQueryOptions satelliteSyncWait(Double satelliteSyncWait) {
        this.getOptions().satelliteSyncWait = satelliteSyncWait;
        return this;
    }

    public Boolean getSkipInaccessibleCollections() {
        return this.options != null ? this.options.skipInaccessibleCollections : null;
    }

    public AqlQueryOptions skipInaccessibleCollections(Boolean skipInaccessibleCollections) {
        this.getOptions().skipInaccessibleCollections = skipInaccessibleCollections;
        return this;
    }

    public Boolean getFullCount() {
        return this.options != null ? this.options.fullCount : null;
    }

    public AqlQueryOptions fullCount(Boolean fullCount) {
        this.getOptions().fullCount = fullCount;
        return this;
    }

    public Integer getMaxPlans() {
        return this.options != null ? this.options.maxPlans : null;
    }

    public AqlQueryOptions maxPlans(Integer maxPlans) {
        this.getOptions().maxPlans = maxPlans;
        return this;
    }

    public Collection<String> getRules() {
        return this.options != null ? (this.options.optimizer != null ? this.options.optimizer.rules : null) : null;
    }

    public AqlQueryOptions rules(Collection<String> rules) {
        this.getOptions().getOptimizer().rules = rules;
        return this;
    }

    public Boolean getStream() {
        return this.options != null ? this.options.stream : null;
    }

    public AqlQueryOptions stream(Boolean stream) {
        this.getOptions().stream = stream;
        return this;
    }

    public Collection<String> getShardIds() {
        return this.options != null ? this.options.shardIds : null;
    }

    public AqlQueryOptions shardIds(String ... shardIds) {
        this.getOptions().getShardIds().addAll(Arrays.asList(shardIds));
        return this;
    }

    private Options getOptions() {
        if (this.options == null) {
            this.options = new Options();
        }
        return this.options;
    }

    public AqlQueryOptions allowDirtyRead(Boolean allowDirtyRead) {
        this.allowDirtyRead = allowDirtyRead;
        return this;
    }

    public Boolean getAllowDirtyRead() {
        return this.allowDirtyRead;
    }

    public String getStreamTransactionId() {
        return this.streamTransactionId;
    }

    public AqlQueryOptions streamTransactionId(String streamTransactionId) {
        this.streamTransactionId = streamTransactionId;
        return this;
    }

    private static class Optimizer {
        private Collection<String> rules;

        private Optimizer() {
        }
    }

    private static class Options
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Boolean failOnWarning;
        private Boolean profile;
        private Long maxTransactionSize;
        private Long maxWarningCount;
        private Long intermediateCommitCount;
        private Long intermediateCommitSize;
        private Double satelliteSyncWait;
        private Boolean skipInaccessibleCollections;
        private Optimizer optimizer;
        private Boolean fullCount;
        private Integer maxPlans;
        private Boolean stream;
        private Collection<String> shardIds;

        private Options() {
        }

        protected Optimizer getOptimizer() {
            if (this.optimizer == null) {
                this.optimizer = new Optimizer();
            }
            return this.optimizer;
        }

        protected Collection<String> getShardIds() {
            if (this.shardIds == null) {
                this.shardIds = new ArrayList<String>();
            }
            return this.shardIds;
        }
    }
}

