/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal;

import com.arangodb.ArangoDBException;
import com.arangodb.entity.MetaAware;
import com.arangodb.internal.ArangoExecutor;
import com.arangodb.internal.DocumentCache;
import com.arangodb.internal.net.CommunicationProtocol;
import com.arangodb.internal.net.HostHandle;
import com.arangodb.internal.util.ArangoSerializationFactory;
import com.arangodb.velocypack.exception.VPackException;
import com.arangodb.velocystream.Request;
import com.arangodb.velocystream.Response;
import java.io.IOException;
import java.lang.reflect.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArangoExecutorSync
extends ArangoExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(ArangoExecutorSync.class);
    private final CommunicationProtocol protocol;

    public ArangoExecutorSync(CommunicationProtocol protocol, ArangoSerializationFactory util, DocumentCache documentCache) {
        super(util, documentCache);
        this.protocol = protocol;
    }

    public <T> T execute(Request request, Type type) throws ArangoDBException {
        return this.execute(request, type, null);
    }

    public <T> T execute(Request request, Type type, HostHandle hostHandle) throws ArangoDBException {
        return (T)this.execute(request, (Response response) -> this.createResult(type, response), hostHandle);
    }

    public <T> T execute(Request request, ArangoExecutor.ResponseDeserializer<T> responseDeserializer) throws ArangoDBException {
        return this.execute(request, responseDeserializer, null);
    }

    public <T> T execute(Request request, ArangoExecutor.ResponseDeserializer<T> responseDeserializer, HostHandle hostHandle) throws ArangoDBException {
        try {
            Response response = this.protocol.execute(request, hostHandle);
            T deserialize = responseDeserializer.deserialize(response);
            if (deserialize instanceof MetaAware) {
                LOG.debug("Respone is MetaAware " + deserialize.getClass().getName());
                ((MetaAware)deserialize).setMeta(response.getMeta());
            }
            return deserialize;
        }
        catch (VPackException e) {
            throw new ArangoDBException(e);
        }
    }

    public void disconnect() {
        try {
            this.protocol.close();
        }
        catch (IOException e) {
            throw new ArangoDBException(e);
        }
    }
}

