/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.async.internal;

import com.arangodb.async.ArangoEdgeCollectionAsync;
import com.arangodb.async.internal.ArangoDBAsyncImpl;
import com.arangodb.async.internal.ArangoDatabaseAsyncImpl;
import com.arangodb.async.internal.ArangoExecutorAsync;
import com.arangodb.async.internal.ArangoGraphAsyncImpl;
import com.arangodb.async.internal.ExceptionUtil;
import com.arangodb.entity.EdgeEntity;
import com.arangodb.entity.EdgeUpdateEntity;
import com.arangodb.internal.InternalArangoEdgeCollection;
import com.arangodb.model.EdgeCreateOptions;
import com.arangodb.model.EdgeDeleteOptions;
import com.arangodb.model.EdgeReplaceOptions;
import com.arangodb.model.EdgeUpdateOptions;
import com.arangodb.model.GraphDocumentReadOptions;
import java.lang.reflect.Type;
import java.util.concurrent.CompletableFuture;

public class ArangoEdgeCollectionAsyncImpl
extends InternalArangoEdgeCollection<ArangoDBAsyncImpl, ArangoDatabaseAsyncImpl, ArangoGraphAsyncImpl, ArangoExecutorAsync>
implements ArangoEdgeCollectionAsync {
    ArangoEdgeCollectionAsyncImpl(ArangoGraphAsyncImpl graph, String name) {
        super(graph, name);
    }

    @Override
    public <T> CompletableFuture<EdgeEntity> insertEdge(T value) {
        return ((ArangoExecutorAsync)this.executor).execute(this.insertEdgeRequest(value, new EdgeCreateOptions()), this.insertEdgeResponseDeserializer(value));
    }

    @Override
    public <T> CompletableFuture<EdgeEntity> insertEdge(T value, EdgeCreateOptions options) {
        return ((ArangoExecutorAsync)this.executor).execute(this.insertEdgeRequest(value, options), this.insertEdgeResponseDeserializer(value));
    }

    @Override
    public <T> CompletableFuture<T> getEdge(String key, Class<T> type) {
        return this.getEdge(key, type, null);
    }

    @Override
    public <T> CompletableFuture<T> getEdge(String key, Class<T> type, GraphDocumentReadOptions options) {
        boolean isCatchException = options != null ? options.isCatchException() : new GraphDocumentReadOptions().isCatchException();
        return ((ArangoExecutorAsync)this.executor).execute(this.getEdgeRequest(key, options), this.getEdgeResponseDeserializer(type)).exceptionally(ExceptionUtil.catchGetDocumentExceptions(isCatchException));
    }

    @Override
    public <T> CompletableFuture<EdgeUpdateEntity> replaceEdge(String key, T value) {
        return ((ArangoExecutorAsync)this.executor).execute(this.replaceEdgeRequest(key, value, new EdgeReplaceOptions()), this.replaceEdgeResponseDeserializer(value));
    }

    @Override
    public <T> CompletableFuture<EdgeUpdateEntity> replaceEdge(String key, T value, EdgeReplaceOptions options) {
        return ((ArangoExecutorAsync)this.executor).execute(this.replaceEdgeRequest(key, value, options), this.replaceEdgeResponseDeserializer(value));
    }

    @Override
    public <T> CompletableFuture<EdgeUpdateEntity> updateEdge(String key, T value) {
        return ((ArangoExecutorAsync)this.executor).execute(this.updateEdgeRequest(key, value, new EdgeUpdateOptions()), this.updateEdgeResponseDeserializer(value));
    }

    @Override
    public <T> CompletableFuture<EdgeUpdateEntity> updateEdge(String key, T value, EdgeUpdateOptions options) {
        return ((ArangoExecutorAsync)this.executor).execute(this.updateEdgeRequest(key, value, options), this.updateEdgeResponseDeserializer(value));
    }

    @Override
    public CompletableFuture<Void> deleteEdge(String key) {
        return ((ArangoExecutorAsync)this.executor).execute(this.deleteEdgeRequest(key, new EdgeDeleteOptions()), (Type)((Object)Void.class));
    }

    @Override
    public CompletableFuture<Void> deleteEdge(String key, EdgeDeleteOptions options) {
        return ((ArangoExecutorAsync)this.executor).execute(this.deleteEdgeRequest(key, options), (Type)((Object)Void.class));
    }
}

