/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.async.internal;

import com.arangodb.ArangoDBException;
import com.arangodb.async.ArangoDBAsync;
import com.arangodb.async.ArangoDatabaseAsync;
import com.arangodb.async.internal.ArangoDatabaseAsyncImpl;
import com.arangodb.async.internal.ArangoExecutorAsync;
import com.arangodb.async.internal.velocystream.VstCommunicationAsync;
import com.arangodb.entity.ArangoDBVersion;
import com.arangodb.entity.LogEntity;
import com.arangodb.entity.LogLevelEntity;
import com.arangodb.entity.Permissions;
import com.arangodb.entity.ServerRole;
import com.arangodb.entity.UserEntity;
import com.arangodb.internal.ArangoContext;
import com.arangodb.internal.ArangoExecutorSync;
import com.arangodb.internal.DocumentCache;
import com.arangodb.internal.InternalArangoDB;
import com.arangodb.internal.net.CommunicationProtocol;
import com.arangodb.internal.net.HostResolver;
import com.arangodb.internal.util.ArangoSerializationFactory;
import com.arangodb.internal.velocystream.VstCommunication;
import com.arangodb.internal.velocystream.VstCommunicationSync;
import com.arangodb.internal.velocystream.VstProtocol;
import com.arangodb.internal.velocystream.internal.VstConnectionSync;
import com.arangodb.model.LogOptions;
import com.arangodb.model.UserCreateOptions;
import com.arangodb.model.UserUpdateOptions;
import com.arangodb.velocystream.Request;
import com.arangodb.velocystream.Response;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;

public class ArangoDBAsyncImpl
extends InternalArangoDB<ArangoExecutorAsync>
implements ArangoDBAsync {
    private final CommunicationProtocol cp;

    public ArangoDBAsyncImpl(VstCommunicationAsync.Builder commBuilder, ArangoSerializationFactory util, VstCommunicationSync.Builder syncbuilder, HostResolver hostResolver, ArangoContext context) {
        super(new ArangoExecutorAsync(commBuilder.build(util.get(ArangoSerializationFactory.Serializer.INTERNAL)), util, new DocumentCache()), util, context);
        VstCommunication<Response, VstConnectionSync> cacheCom = syncbuilder.build(util.get(ArangoSerializationFactory.Serializer.INTERNAL));
        this.cp = new VstProtocol(cacheCom);
        ArangoExecutorSync arangoExecutorSync = new ArangoExecutorSync(this.cp, util, new DocumentCache());
        hostResolver.init(arangoExecutorSync, util.get(ArangoSerializationFactory.Serializer.INTERNAL));
    }

    @Override
    protected ArangoExecutorAsync executor() {
        return (ArangoExecutorAsync)this.executor;
    }

    @Override
    public void shutdown() throws ArangoDBException {
        try {
            ((ArangoExecutorAsync)this.executor).disconnect();
            this.cp.close();
        }
        catch (IOException e) {
            throw new ArangoDBException(e);
        }
    }

    @Override
    public ArangoDatabaseAsync db() {
        return this.db("_system");
    }

    @Override
    public ArangoDatabaseAsync db(String name) {
        return new ArangoDatabaseAsyncImpl(this, name);
    }

    @Override
    public CompletableFuture<Boolean> createDatabase(String name) {
        return ((ArangoExecutorAsync)this.executor).execute(this.createDatabaseRequest(name), this.createDatabaseResponseDeserializer());
    }

    @Override
    public CompletableFuture<Collection<String>> getDatabases() {
        return ((ArangoExecutorAsync)this.executor).execute(this.getDatabasesRequest(this.db().name()), this.getDatabaseResponseDeserializer());
    }

    @Override
    public CompletableFuture<Collection<String>> getAccessibleDatabases() {
        return this.db().getAccessibleDatabases();
    }

    @Override
    public CompletableFuture<Collection<String>> getAccessibleDatabasesFor(String user) {
        return ((ArangoExecutorAsync)this.executor).execute(this.getAccessibleDatabasesForRequest(this.db().name(), user), this.getAccessibleDatabasesForResponseDeserializer());
    }

    @Override
    public CompletableFuture<ArangoDBVersion> getVersion() {
        return this.db().getVersion();
    }

    @Override
    public CompletableFuture<ServerRole> getRole() {
        return ((ArangoExecutorAsync)this.executor).execute(this.getRoleRequest(), this.getRoleResponseDeserializer());
    }

    @Override
    public CompletableFuture<UserEntity> createUser(String user, String passwd) {
        return ((ArangoExecutorAsync)this.executor).execute(this.createUserRequest(this.db().name(), user, passwd, new UserCreateOptions()), (Type)((Object)UserEntity.class));
    }

    @Override
    public CompletableFuture<UserEntity> createUser(String user, String passwd, UserCreateOptions options) {
        return ((ArangoExecutorAsync)this.executor).execute(this.createUserRequest(this.db().name(), user, passwd, options), (Type)((Object)UserEntity.class));
    }

    @Override
    public CompletableFuture<Void> deleteUser(String user) {
        return ((ArangoExecutorAsync)this.executor).execute(this.deleteUserRequest(this.db().name(), user), (Type)((Object)Void.class));
    }

    @Override
    public CompletableFuture<UserEntity> getUser(String user) {
        return ((ArangoExecutorAsync)this.executor).execute(this.getUserRequest(this.db().name(), user), (Type)((Object)UserEntity.class));
    }

    @Override
    public CompletableFuture<Collection<UserEntity>> getUsers() {
        return ((ArangoExecutorAsync)this.executor).execute(this.getUsersRequest(this.db().name()), this.getUsersResponseDeserializer());
    }

    @Override
    public CompletableFuture<UserEntity> updateUser(String user, UserUpdateOptions options) {
        return ((ArangoExecutorAsync)this.executor).execute(this.updateUserRequest(this.db().name(), user, options), (Type)((Object)UserEntity.class));
    }

    @Override
    public CompletableFuture<UserEntity> replaceUser(String user, UserUpdateOptions options) {
        return ((ArangoExecutorAsync)this.executor).execute(this.replaceUserRequest(this.db().name(), user, options), (Type)((Object)UserEntity.class));
    }

    @Override
    public CompletableFuture<Void> grantDefaultDatabaseAccess(String user, Permissions permissions) {
        return ((ArangoExecutorAsync)this.executor).execute(this.updateUserDefaultDatabaseAccessRequest(user, permissions), (Type)((Object)Void.class));
    }

    @Override
    public CompletableFuture<Void> grantDefaultCollectionAccess(String user, Permissions permissions) {
        return ((ArangoExecutorAsync)this.executor).execute(this.updateUserDefaultCollectionAccessRequest(user, permissions), (Type)((Object)Void.class));
    }

    @Override
    public CompletableFuture<Response> execute(Request request) {
        return ((ArangoExecutorAsync)this.executor).execute(request, response -> response);
    }

    @Override
    public CompletableFuture<LogEntity> getLogs(LogOptions options) {
        return ((ArangoExecutorAsync)this.executor).execute(this.getLogsRequest(options), (Type)((Object)LogEntity.class));
    }

    @Override
    public CompletableFuture<LogLevelEntity> getLogLevel() {
        return ((ArangoExecutorAsync)this.executor).execute(this.getLogLevelRequest(), (Type)((Object)LogLevelEntity.class));
    }

    @Override
    public CompletableFuture<LogLevelEntity> setLogLevel(LogLevelEntity entity) {
        return ((ArangoExecutorAsync)this.executor).execute(this.setLogLevelRequest(entity), (Type)((Object)LogLevelEntity.class));
    }
}

