/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.async.internal;

import com.arangodb.async.ArangoVertexCollectionAsync;
import com.arangodb.async.internal.ArangoDBAsyncImpl;
import com.arangodb.async.internal.ArangoDatabaseAsyncImpl;
import com.arangodb.async.internal.ArangoExecutorAsync;
import com.arangodb.async.internal.ArangoGraphAsyncImpl;
import com.arangodb.async.internal.ExceptionUtil;
import com.arangodb.entity.VertexEntity;
import com.arangodb.entity.VertexUpdateEntity;
import com.arangodb.internal.InternalArangoVertexCollection;
import com.arangodb.model.GraphDocumentReadOptions;
import com.arangodb.model.VertexCreateOptions;
import com.arangodb.model.VertexDeleteOptions;
import com.arangodb.model.VertexReplaceOptions;
import com.arangodb.model.VertexUpdateOptions;
import java.lang.reflect.Type;
import java.util.concurrent.CompletableFuture;

public class ArangoVertexCollectionAsyncImpl
extends InternalArangoVertexCollection<ArangoDBAsyncImpl, ArangoDatabaseAsyncImpl, ArangoGraphAsyncImpl, ArangoExecutorAsync>
implements ArangoVertexCollectionAsync {
    ArangoVertexCollectionAsyncImpl(ArangoGraphAsyncImpl graph, String name) {
        super(graph, name);
    }

    @Override
    public CompletableFuture<Void> drop() {
        return ((ArangoExecutorAsync)this.executor).execute(this.dropRequest(), (Type)((Object)Void.class));
    }

    @Override
    public <T> CompletableFuture<VertexEntity> insertVertex(T value) {
        return ((ArangoExecutorAsync)this.executor).execute(this.insertVertexRequest(value, new VertexCreateOptions()), this.insertVertexResponseDeserializer(value));
    }

    @Override
    public <T> CompletableFuture<VertexEntity> insertVertex(T value, VertexCreateOptions options) {
        return ((ArangoExecutorAsync)this.executor).execute(this.insertVertexRequest(value, options), this.insertVertexResponseDeserializer(value));
    }

    @Override
    public <T> CompletableFuture<T> getVertex(String key, Class<T> type) {
        return this.getVertex(key, type, null);
    }

    @Override
    public <T> CompletableFuture<T> getVertex(String key, Class<T> type, GraphDocumentReadOptions options) {
        boolean isCatchException = options != null ? options.isCatchException() : new GraphDocumentReadOptions().isCatchException();
        return ((ArangoExecutorAsync)this.executor).execute(this.getVertexRequest(key, options), this.getVertexResponseDeserializer(type)).exceptionally(ExceptionUtil.catchGetDocumentExceptions(isCatchException));
    }

    @Override
    public <T> CompletableFuture<VertexUpdateEntity> replaceVertex(String key, T value) {
        return ((ArangoExecutorAsync)this.executor).execute(this.replaceVertexRequest(key, value, new VertexReplaceOptions()), this.replaceVertexResponseDeserializer(value));
    }

    @Override
    public <T> CompletableFuture<VertexUpdateEntity> replaceVertex(String key, T value, VertexReplaceOptions options) {
        return ((ArangoExecutorAsync)this.executor).execute(this.replaceVertexRequest(key, value, options), this.replaceVertexResponseDeserializer(value));
    }

    @Override
    public <T> CompletableFuture<VertexUpdateEntity> updateVertex(String key, T value) {
        return ((ArangoExecutorAsync)this.executor).execute(this.updateVertexRequest(key, value, new VertexUpdateOptions()), this.updateVertexResponseDeserializer(value));
    }

    @Override
    public <T> CompletableFuture<VertexUpdateEntity> updateVertex(String key, T value, VertexUpdateOptions options) {
        return ((ArangoExecutorAsync)this.executor).execute(this.updateVertexRequest(key, value, options), this.updateVertexResponseDeserializer(value));
    }

    @Override
    public CompletableFuture<Void> deleteVertex(String key) {
        return ((ArangoExecutorAsync)this.executor).execute(this.deleteVertexRequest(key, new VertexDeleteOptions()), (Type)((Object)Void.class));
    }

    @Override
    public CompletableFuture<Void> deleteVertex(String key, VertexDeleteOptions options) {
        return ((ArangoExecutorAsync)this.executor).execute(this.deleteVertexRequest(key, options), (Type)((Object)Void.class));
    }
}

