/*
 * Decompiled with CFR 0.152.
 */
package com.apradanas.simplelinkabletext;

import android.content.Context;
import android.text.method.LinkMovementMethod;
import android.util.AttributeSet;
import android.widget.TextView;
import com.apradanas.simplelinkabletext.Link;
import com.apradanas.simplelinkabletext.LinkModifier;
import java.util.ArrayList;
import java.util.List;

public class LinkableTextView
extends TextView {
    private List<Link> mLinks = new ArrayList<Link>();
    private LinkModifier mLinkModifier;

    public LinkableTextView(Context context) {
        super(context);
        this.init();
    }

    public LinkableTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public LinkableTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.setMovementMethod(LinkMovementMethod.getInstance());
        this.mLinkModifier = new LinkModifier(LinkModifier.ViewType.TEXT_VIEW);
    }

    public LinkableTextView setText(String text) {
        this.mLinkModifier.setText(text);
        return this;
    }

    public LinkableTextView addLink(Link link) {
        this.mLinks.add(link);
        this.mLinkModifier.setLinks(this.mLinks);
        return this;
    }

    public LinkableTextView addLinks(List<Link> links) {
        this.mLinks.addAll(links);
        this.mLinkModifier.setLinks(this.mLinks);
        return this;
    }

    public LinkableTextView build() {
        this.mLinkModifier.build();
        this.setText((CharSequence)this.mLinkModifier.getSpannable());
        return this;
    }
}

