/*
 * Decompiled with CFR 0.152.
 */
package com.apradanas.simplelinkabletext;

import android.content.Context;
import android.text.Editable;
import android.text.Spannable;
import android.text.TextWatcher;
import android.text.method.LinkMovementMethod;
import android.util.AttributeSet;
import android.widget.EditText;
import com.apradanas.simplelinkabletext.Link;
import com.apradanas.simplelinkabletext.LinkModifier;
import java.util.ArrayList;
import java.util.List;

public class LinkableEditText
extends EditText
implements TextWatcher {
    private List<Link> mLinks = new ArrayList<Link>();
    private LinkModifier mLinkModifier;

    public LinkableEditText(Context context) {
        super(context);
        this.init();
    }

    public LinkableEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public LinkableEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.addTextChangedListener(this);
        this.setMovementMethod(LinkMovementMethod.getInstance());
        this.mLinkModifier = new LinkModifier(LinkModifier.ViewType.EDIT_TEXT);
    }

    public LinkableEditText addLink(Link link) {
        this.mLinks.add(link);
        this.mLinkModifier.setLinks(this.mLinks);
        return this;
    }

    public LinkableEditText addLinks(List<Link> links) {
        this.mLinks.addAll(links);
        this.mLinkModifier.setLinks(this.mLinks);
        return this;
    }

    public void onTextChanged(CharSequence text, int start, int lengthBefore, int lengthAfter) {
        super.onTextChanged(text, start, lengthBefore, lengthAfter);
    }

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    public void afterTextChanged(Editable s) {
        this.mLinkModifier.setSpannable((Spannable)s);
        this.mLinkModifier.build();
    }
}

