/*
 * Decompiled with CFR 0.152.
 */
package com.apradanas.simplelinkabletext;

import android.text.Spannable;
import android.text.SpannableString;
import android.text.style.ClickableSpan;
import com.apradanas.simplelinkabletext.ClickableLinkSpan;
import com.apradanas.simplelinkabletext.Link;
import com.apradanas.simplelinkabletext.util.Range;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LinkModifier {
    private List<Link> mLinks = new ArrayList<Link>();
    private List<Link> mFoundLinks = new ArrayList<Link>();
    private String mText;
    private Spannable mSpannable;
    private ViewType mViewType;

    public LinkModifier(ViewType viewType) {
        this.mViewType = viewType;
    }

    public List<Link> getLinks() {
        return this.mLinks;
    }

    public void setLinks(List<Link> mLinks) {
        this.mLinks = mLinks;
    }

    public List<Link> getFoundLinks() {
        return this.mFoundLinks;
    }

    public void setFoundLinks(List<Link> mFoundLinks) {
        this.mFoundLinks = mFoundLinks;
    }

    public String getText() {
        return this.mText;
    }

    public void setText(String mText) {
        this.mText = mText;
    }

    public Spannable getSpannable() {
        return this.mSpannable;
    }

    public void setSpannable(Spannable mSpannable) {
        this.mSpannable = mSpannable;
    }

    public void addLinkToSpan(Link link) {
        if (this.mSpannable == null) {
            this.mSpannable = SpannableString.valueOf((CharSequence)this.mText);
        }
        this.addLinkToSpan(this.mSpannable, link);
    }

    private void addLinkToSpan(Spannable s, Link link) {
        Pattern pattern = Pattern.compile(Pattern.quote(link.getText()));
        Matcher matcher = pattern.matcher(this.mText);
        while (matcher.find()) {
            int start = matcher.start();
            if (start < 0) continue;
            int end = start + link.getText().length();
            this.applyLink(link, new Range(start, end), s);
        }
    }

    private void applyLink(Link link, Range range, Spannable text) {
        ClickableLinkSpan linkSpan = new ClickableLinkSpan(link, range);
        text.setSpan((Object)linkSpan, range.start, range.end, 33);
    }

    public void removePreviousSpans() {
        ClickableSpan[] toRemoveSpans;
        for (ClickableSpan toRemoveSpan : toRemoveSpans = (ClickableSpan[])this.mSpannable.getSpans(0, this.mSpannable.length(), ClickableSpan.class)) {
            this.mSpannable.removeSpan((Object)toRemoveSpan);
        }
    }

    public void convertPatternsToLinks() {
        this.mFoundLinks.clear();
        this.mFoundLinks.addAll(this.mLinks);
        int size = this.mFoundLinks.size();
        int i = 0;
        while (i < size) {
            if (this.mFoundLinks.get(i).getPattern() != null) {
                this.addLinksFromPattern(this.mFoundLinks.get(i));
                this.mFoundLinks.remove(i);
                --size;
                continue;
            }
            ++i;
        }
    }

    private void addLinksFromPattern(Link linkWithPattern) {
        Pattern pattern = linkWithPattern.getPattern();
        Matcher m = pattern.matcher(this.mText);
        while (m.find()) {
            Link link = new Link(linkWithPattern).setText(m.group());
            this.mFoundLinks.add(link);
        }
    }

    public void build() {
        if (this.mViewType == ViewType.EDIT_TEXT) {
            this.mText = this.mSpannable.toString();
            this.removePreviousSpans();
        } else {
            this.mSpannable = null;
        }
        this.convertPatternsToLinks();
        for (Link link : this.mFoundLinks) {
            this.addLinkToSpan(link);
        }
    }

    public static enum ViewType {
        TEXT_VIEW,
        EDIT_TEXT;

    }
}

