/*
 * Decompiled with CFR 0.152.
 */
package com.apradanas.simplelinkabletext;

import android.content.Context;
import android.text.Editable;
import android.text.TextPaint;
import android.text.TextWatcher;
import android.text.method.LinkMovementMethod;
import android.text.style.ClickableSpan;
import android.util.AttributeSet;
import android.view.View;
import android.widget.EditText;
import com.apradanas.simplelinkabletext.Link;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LinkableEditText
extends EditText
implements TextWatcher {
    private List<Link> mLinks = new ArrayList<Link>();
    private List<Link> mFoundLinks = new ArrayList<Link>();
    private String mText;
    private Editable editable;

    public LinkableEditText(Context context) {
        super(context);
        this.addTextChangedListener(this);
        this.setMovementMethod(LinkMovementMethod.getInstance());
    }

    public LinkableEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.addTextChangedListener(this);
        this.setMovementMethod(LinkMovementMethod.getInstance());
    }

    public LinkableEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.addTextChangedListener(this);
        this.setMovementMethod(LinkMovementMethod.getInstance());
    }

    public LinkableEditText addLink(Link link) {
        this.mLinks.add(link);
        this.mFoundLinks.add(link);
        return this;
    }

    public LinkableEditText addLinks(List<Link> links) {
        this.mLinks.addAll(links);
        this.mFoundLinks.addAll(links);
        return this;
    }

    private void addLinkToSpan(Link link) {
        Pattern pattern = Pattern.compile(Pattern.quote(link.getText()));
        Matcher matcher = pattern.matcher(this.mText);
        while (matcher.find()) {
            int start = matcher.start();
            if (start < 0) continue;
            int end = start + link.getText().length();
            this.applyLink(link, new Range(start, end));
        }
    }

    private void removePreviousSpans() {
        ClickableSpan[] toRemoveSpans = (ClickableSpan[])this.editable.getSpans(0, this.editable.length(), ClickableSpan.class);
        for (int i = 0; i < toRemoveSpans.length; ++i) {
            this.editable.removeSpan((Object)toRemoveSpans[i]);
        }
    }

    private void applyLink(final Link link, final Range range) {
        ClickableSpan span = new ClickableSpan(){

            public void onClick(View widget) {
                EditText et = (EditText)widget;
                Editable s = et.getText();
                if (link.getClickListener() != null) {
                    link.getClickListener().onClick(s.subSequence(range.start, range.end).toString());
                }
            }

            public void updateDrawState(TextPaint ds) {
                if (link.getTextColor() != 0) {
                    ds.setColor(link.getTextColor());
                }
                ds.setUnderlineText(link.isUnderlined());
            }
        };
        this.editable.setSpan((Object)span, range.start, range.end, 33);
    }

    private void convertPatternsToLinks() {
        this.mFoundLinks.clear();
        this.mFoundLinks.addAll(this.mLinks);
        int size = this.mFoundLinks.size();
        int i = 0;
        while (i < size) {
            if (this.mFoundLinks.get(i).getPattern() != null) {
                this.addLinksFromPattern(this.mFoundLinks.get(i));
                this.mFoundLinks.remove(i);
                --size;
                continue;
            }
            ++i;
        }
    }

    private void addLinksFromPattern(Link linkWithPattern) {
        Pattern pattern = linkWithPattern.getPattern();
        Matcher m = pattern.matcher(this.mText);
        while (m.find()) {
            Link link = new Link(linkWithPattern).setText(m.group());
            this.mFoundLinks.add(link);
        }
    }

    public void onTextChanged(CharSequence text, int start, int lengthBefore, int lengthAfter) {
        super.onTextChanged(text, start, lengthBefore, lengthAfter);
    }

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    public void afterTextChanged(Editable s) {
        this.mText = s.toString();
        this.editable = s;
        this.convertPatternsToLinks();
        this.removePreviousSpans();
        for (Link link : this.mFoundLinks) {
            this.addLinkToSpan(link);
        }
    }

    private static class Range {
        public int start;
        public int end;

        public Range(int start, int end) {
            this.start = start;
            this.end = end;
        }
    }
}

