package com.appspiriment.permissionutils

import androidx.appcompat.app.AppCompatActivity
import androidx.fragment.app.Fragment
import androidx.fragment.app.FragmentManager
import com.appspiriment.androidutils.LogUtils
import kotlinx.coroutines.*


/*********************************************************
 * Class   :  PermissionManager
 * Author  :  Arun Nair
 * Created :  14/10/20
 *******************************************************
 * Purpose :
 *******************************************************
 * Rework Details:
 * 1) {Author} :  {Date} : {Details}
 *********************************************************/
object PermissionManager {
    private const val TAG = "PermissionManager"
    private val parentJob = Job()
    private val coroutineScope = CoroutineScope(parentJob + Dispatchers.Default)

    fun AppCompatActivity.getCoroutineScope(): CoroutineScope {
        return coroutineScope
    }

    fun Fragment.getCoroutineScope(): CoroutineScope {
        return coroutineScope
    }

    suspend fun AppCompatActivity.requestPermissionsAsync(
        requestId: Int,
        vararg permissions: String
    ): PermissionResult {
        return withContext(Dispatchers.Main) {
            return@withContext requestPermissionsFromUser(
                supportFragmentManager,
                requestId,
                *permissions
            )
        }
    }

    suspend fun Fragment.requestPermissionsAsync(
        requestId: Int,
        vararg permissions: String
    ): PermissionResult {
        return withContext(Dispatchers.Main) {
            return@withContext requestPermissionsFromUser(
                childFragmentManager,
                requestId,
                *permissions
            )
        }
    }

    fun AppCompatActivity.requestPermissionsAsync(
        requestId: Int,
        permissionGrantedListener: (requestId: Int) -> Unit,
        permissionDeniedListener: (requestId: Int, deniedPermissions: List<String>) -> Unit,
        permissionDeniedPermanently: (requestId: Int, deniedPermissions: List<String>) -> Unit,
        permissionRationalListener: (requestId: Int) -> Unit,
        vararg permissions: String
    ) {
        getCoroutineScope().launch {
            withContext(Dispatchers.Main) {
                return@withContext requestPermissionsFromUser(
                    supportFragmentManager,
                    requestId,
                    permissionGrantedListener,
                    permissionDeniedListener,
                    permissionDeniedPermanently,
                    permissionRationalListener,
                    *permissions
                )
            }
        }
    }

    fun Fragment.requestPermissionsAsync(
        requestId: Int,
        permissionGrantedListener: (requestId: Int) -> Unit,
        permissionDeniedListener: (requestId: Int, deniedPermissions: List<String>) -> Unit,
        permissionDeniedPermanently: (requestId: Int, deniedPermissions: List<String>) -> Unit,
        permissionRationalListener: (requestId: Int) -> Unit,
        vararg permissions: String
    ) {
        getCoroutineScope().launch {
            withContext(Dispatchers.Main) {
                return@withContext requestPermissionsFromUser(
                    childFragmentManager,
                    requestId,
                    permissionGrantedListener,
                    permissionDeniedListener,
                    permissionDeniedPermanently,
                    permissionRationalListener,
                    *permissions
                )
            }
        }
    }

    fun AppCompatActivity.requestPermissionsAsync(
        requestId: Int,
        permissionListner: PermissionListener,
        vararg permissions: String
    ) {
        getCoroutineScope().launch {
            requestPermissionsFromUser(
                supportFragmentManager,
                requestId,
                permissionListner,
                *permissions
            )
        }
    }

    fun Fragment.requestPermissionsAsync(
        requestId: Int,
        permissionListner: PermissionListener,
        vararg permissions: String
    ) {
        getCoroutineScope().launch {
            requestPermissionsFromUser(
                childFragmentManager,
                requestId,
                permissionListner,
                *permissions
            )
        }
    }

    private suspend fun requestPermissionsFromUser(
        fragmentManager: FragmentManager,
        requestId: Int,
        permissionListner: PermissionListener,
        vararg permissions: String
    ) {

//
//        val permissionDeniedPermanently = { reqId: Int, deniedPermissions: List<String> ->
//            permissionListner.onPermissionDenied(
//                reqId,
//                deniedPermissions
//            )
//        }

        LogUtils.printLog("Reached")
        requestPermissionsFromUser(
            fragmentManager, requestId,
            permissionListner::onPermissionGranted,
            permissionListner::onPermissionDenied,
            permissionListner::onPermissionDeniedPermanently,
            permissionListner::onShowRational,
            *permissions
        )
    }

    private suspend fun requestPermissionsFromUser(
        fragmentManager: FragmentManager,
        requestId: Int,
        permissionGrantedListener: (requestId: Int) -> Unit,
        permissionDeniedListener: (requestId: Int, deniedPermissions: List<String>) -> Unit,
        permissionDeniedPermanently: (requestId: Int, deniedPermissions: List<String>) -> Unit,
        permissionRationalListener: (requestId: Int) -> Unit,
        vararg permissions: String
    ) {
        LogUtils.printLog("Reached 2")

        requestPermissionsFromUser(fragmentManager, requestId, *permissions).let {
            LogUtils.printLog(it)
            when (it) {
                is PermissionResult.PermissionGranted -> permissionGrantedListener(it.requestCode)
                is PermissionResult.PermissionDenied -> permissionDeniedListener(
                    it.requestCode,
                    it.deniedPermissions
                )
                is PermissionResult.PermissionDeniedPermanently -> permissionDeniedPermanently(
                    it.requestCode,
                    it.permanentlyDeniedPermissions
                )
                is PermissionResult.ShowRational -> permissionRationalListener(it.requestCode)
            }
        }
    }

    private suspend fun requestPermissionsFromUser(
        fragmentManager: FragmentManager,
        requestId: Int,
        vararg permissions: String
    ): PermissionResult {
        LogUtils.printLog("Reached 3")
        val permissionFragment =
            fragmentManager.findFragmentByTag(TAG) ?: PermissionFragment().apply {
                fragmentManager.beginTransaction().add(this, TAG).commitNow()
            }

        return permissionFragment.let {
            (it as PermissionFragment).run {
                deferredPermission = CompletableDeferred()
                requestPermissionsFromUser(requestId, *permissions)
                deferredPermission.await()
            }
        }
    }
}
