package com.appspiriment.baseclasses.ads

import android.content.Context
import android.util.DisplayMetrics
import android.view.WindowManager
import com.google.android.gms.ads.*

/*****************************
 * method to get shared Prefs
 *****************************/
object AdUtils {

    /***************************************
     * On Backpress
     ***************************************/
    fun getBannerAdSize(context: Context, windowManager: WindowManager): AdSize? {
        val display = windowManager.defaultDisplay
        val outMetrics = DisplayMetrics()
        display.getMetrics(outMetrics)
        val widthPixels = outMetrics.widthPixels.toFloat()
        val density = outMetrics.density
        val adWidth = (widthPixels / density).toInt()
        return AdSize.getCurrentOrientationAnchoredAdaptiveBannerAdSize(
            context, adWidth
        )
    }

    /*****************************
     * method to get shared Prefs
     *****************************/
    fun getBannerAdView(
        context: Context,
        bannerAdId: String,
        windowManager: WindowManager? = null,
        onFailAction: (AdView) -> Unit = {}
    ): AdView {
        return AdView(context).apply {
            adUnitId = bannerAdId
            adSize = windowManager?.let { getBannerAdSize(context, it) } ?: AdSize.BANNER
            adListener = object : AdListener() {
                override fun onAdFailedToLoad(p0: Int) {
                    val adview = when (adSize) {
                        AdSize.SMART_BANNER ->
                            AdView(context).apply {
                                adSize = AdSize.BANNER
                            }
                        AdSize.BANNER -> null
                        else -> AdView(context).apply {
                            adSize = AdSize.SMART_BANNER
                        }
                    }
                    adview?.run {
                        loadAd(AdRequest.Builder().build())
                        onFailAction(this)
                    }
                }
            }
            loadAd(AdRequest.Builder().build())
        }
    }

    /*****************************
     * method to get shared Prefs
     *****************************/
    fun getInterstitialAd(context: Context, adUnitId: String): InterstitialAd {
        return InterstitialAd(context).apply {
            this.adUnitId = adUnitId
            adListener = object : AdListener() {
                override fun onAdClosed() {
                    loadAd(AdRequest.Builder().build())
                }
            }
        }
    }
}