package com.appspiriment.baseclasses.ads

import android.content.SharedPreferences
import org.koin.core.KoinComponent
import org.koin.core.inject

/**********************************
 * Preferences
 **********************************/
abstract class AdPrefUtils : KoinComponent {
    abstract fun getSharedPrefs() : SharedPreferences

    /*****************************
     * method to get shared Prefs
     *****************************/
    fun getTimeElapsedFromLastInterstitial(
        isNowDisplayed: Boolean = false,
        adInterval: Int = 30000
    ): Boolean {
        val KEY_LAST_AD_SHOWN_AT = "~lastInter~"
        return if (isNowDisplayed) {
            getSharedPrefs().edit().putLong(KEY_LAST_AD_SHOWN_AT, System.currentTimeMillis()).apply()
            false
        } else {
            System.currentTimeMillis() - getSharedPrefs().getLong(
                KEY_LAST_AD_SHOWN_AT,
                System.currentTimeMillis() - (adInterval + 1000)
            ) > adInterval
        }
    }

    /*****************************
     * method to get shared Prefs
     *****************************/
    fun isTurnForInterstitial(adInterval: Int = 30000): Boolean {
        val KEY_INTER_AD_NUM = "~intrAd~"
        val ads = getSharedPrefs().getInt(KEY_INTER_AD_NUM, 0)
        val isTurn = ads >= adInterval
        getSharedPrefs().edit().putInt(KEY_INTER_AD_NUM, if (isTurn) 0 else (ads + 1)).apply()
        return isTurn && getTimeElapsedFromLastInterstitial()
    }
}