/*
 * Decompiled with CFR 0.152.
 */
package com.appspiriment.androidutils;

import android.text.format.DateUtils;
import com.appspiriment.androidutils.LogUtils;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u001e\u0010\u0004\u001a\u00020\u0001*\u00020\u00012\b\b\u0002\u0010\u0005\u001a\u00020\u00012\b\b\u0002\u0010\u0006\u001a\u00020\u0001\u001a\u001e\u0010\u0007\u001a\u00020\u0001*\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\u0001\u001a\u0014\u0010\f\u001a\u00020\u0001*\u00020\b2\b\b\u0002\u0010\u000b\u001a\u00020\u0001\u001a\n\u0010\r\u001a\u00020\u0001*\u00020\u000e\u001a\n\u0010\r\u001a\u00020\u0001*\u00020\b\u001a2\u0010\u000f\u001a\u00020\u0001*\u00020\u00012\b\b\u0002\u0010\u0010\u001a\u00020\b2\b\b\u0002\u0010\u0011\u001a\u00020\u000e2\b\b\u0002\u0010\u0005\u001a\u00020\u00012\b\b\u0002\u0010\u0006\u001a\u00020\u0001\u00a8\u0006\u0012"}, d2={"formatToKmgFormat", "", "num", "", "changeDateFormat", "inputFormat", "outputFormat", "formatMillisToHMS", "", "locale", "Ljava/util/Locale;", "format", "formatTimeInMillisToTimestamp", "toKmgFormat", "", "toRelativeDateString", "span", "maxSpan", "androidutils_release"})
public final class FormatUtilsKt {
    @NotNull
    public static final String formatMillisToHMS(long $this$formatMillisToHMS, @NotNull Locale locale, @NotNull String format) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)locale, (String)"locale");
        Intrinsics.checkParameterIsNotNull((Object)format, (String)"format");
        try {
            object = StringCompanionObject.INSTANCE;
            Object[] objectArray = new Object[]{TimeUnit.MILLISECONDS.toHours($this$formatMillisToHMS), TimeUnit.MILLISECONDS.toMinutes($this$formatMillisToHMS) - TimeUnit.HOURS.toMinutes(TimeUnit.MILLISECONDS.toHours($this$formatMillisToHMS)), TimeUnit.MILLISECONDS.toSeconds($this$formatMillisToHMS) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes($this$formatMillisToHMS))};
            boolean bl = false;
            String string = String.format(locale, format, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"java.lang.String.format(locale, format, *args)");
            object = string;
        }
        catch (Exception e) {
            return String.valueOf($this$formatMillisToHMS);
        }
        return object;
    }

    public static /* synthetic */ String formatMillisToHMS$default(long l, Locale locale, String string, int n, Object object) {
        if ((n & 1) != 0) {
            Locale locale2 = Locale.ENGLISH;
            Intrinsics.checkExpressionValueIsNotNull((Object)locale2, (String)"Locale.ENGLISH");
            locale = locale2;
        }
        if ((n & 2) != 0) {
            string = "%02d:%02d:%02d";
        }
        return FormatUtilsKt.formatMillisToHMS(l, locale, string);
    }

    @NotNull
    public static final String formatTimeInMillisToTimestamp(long $this$formatTimeInMillisToTimestamp, @NotNull String format) {
        Intrinsics.checkParameterIsNotNull((Object)format, (String)"format");
        try {
            String string = DateFormat.getDateTimeInstance().format(new Date($this$formatTimeInMillisToTimestamp));
            boolean bl = false;
            boolean bl2 = false;
            String it = string;
            boolean bl3 = false;
            String string2 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"it");
            String string3 = FormatUtilsKt.changeDateFormat(string2, "MMM dd, yyyy h:mm:ss a", format);
            boolean bl4 = false;
            boolean bl5 = false;
            String it2 = string3;
            boolean bl6 = false;
            LogUtils.printLog$default(LogUtils.INSTANCE, it2, null, false, 6, null);
            return string3;
        }
        catch (Exception e) {
            return String.valueOf($this$formatTimeInMillisToTimestamp);
        }
    }

    public static /* synthetic */ String formatTimeInMillisToTimestamp$default(long l, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
        }
        return FormatUtilsKt.formatTimeInMillisToTimestamp(l, string);
    }

    @NotNull
    public static final String toKmgFormat(int $this$toKmgFormat) {
        return FormatUtilsKt.formatToKmgFormat($this$toKmgFormat);
    }

    @NotNull
    public static final String toKmgFormat(long $this$toKmgFormat) {
        return FormatUtilsKt.formatToKmgFormat($this$toKmgFormat);
    }

    private static final String formatToKmgFormat(Number num) {
        NumberFormat formatter;
        NumberFormat numberFormat = formatter = NumberFormat.getNumberInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)numberFormat, (String)"formatter");
        numberFormat.setMaximumFractionDigits(1);
        Map kmgMap = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)1000000000L, (Object)"G"), TuplesKt.to((Object)1000000L, (Object)"M"), TuplesKt.to((Object)1000L, (Object)"K")});
        Iterable $this$forEach$iv = kmgMap.keySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            long it = ((Number)element$iv).longValue();
            boolean bl = false;
            if (num.longValue() < it) continue;
            float numQnt = num.floatValue() / (float)it;
            return formatter.format(numQnt) + (String)kmgMap.get(it);
        }
        return num.toString();
    }

    @NotNull
    public static final String toRelativeDateString(@NotNull String $this$toRelativeDateString, long span, int maxSpan, @NotNull String inputFormat, @NotNull String outputFormat) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)$this$toRelativeDateString, (String)"$this$toRelativeDateString");
        Intrinsics.checkParameterIsNotNull((Object)inputFormat, (String)"inputFormat");
        Intrinsics.checkParameterIsNotNull((Object)outputFormat, (String)"outputFormat");
        try {
            String string2;
            Date date1 = new SimpleDateFormat(inputFormat, Locale.ENGLISH).parse($this$toRelativeDateString);
            long now = System.currentTimeMillis();
            long diffInMillisec = now - date1.getTime();
            long diffInDays = TimeUnit.MILLISECONDS.toDays(diffInMillisec);
            if (diffInDays > (long)maxSpan) {
                String string3 = new SimpleDateFormat(outputFormat, Locale.ENGLISH).format(date1);
                string2 = string3;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"SimpleDateFormat(outputF\u2026le.ENGLISH).format(date1)");
            } else {
                string2 = ((Object)DateUtils.getRelativeTimeSpanString((long)date1.getTime(), (long)now, (long)span)).toString();
            }
            string = string2;
        }
        catch (Exception e) {
            string = $this$toRelativeDateString;
        }
        return string;
    }

    public static /* synthetic */ String toRelativeDateString$default(String string, long l, int n, String string2, String string3, int n2, Object object) {
        if ((n2 & 1) != 0) {
            l = 86400000L;
        }
        if ((n2 & 2) != 0) {
            n = 1;
        }
        if ((n2 & 4) != 0) {
            string2 = "yyyy-MM-dd";
        }
        if ((n2 & 8) != 0) {
            string3 = "dd MMM yyyy";
        }
        return FormatUtilsKt.toRelativeDateString(string, l, n, string2, string3);
    }

    @NotNull
    public static final String changeDateFormat(@NotNull String $this$changeDateFormat, @NotNull String inputFormat, @NotNull String outputFormat) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)$this$changeDateFormat, (String)"$this$changeDateFormat");
        Intrinsics.checkParameterIsNotNull((Object)inputFormat, (String)"inputFormat");
        Intrinsics.checkParameterIsNotNull((Object)outputFormat, (String)"outputFormat");
        try {
            Date date1 = new SimpleDateFormat(inputFormat, Locale.ENGLISH).parse($this$changeDateFormat);
            String string2 = new SimpleDateFormat(outputFormat, Locale.ENGLISH).format(date1);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"SimpleDateFormat(outputF\u2026le.ENGLISH).format(date1)");
            string = string2;
        }
        catch (Exception e) {
            string = $this$changeDateFormat;
        }
        return string;
    }

    public static /* synthetic */ String changeDateFormat$default(String string, String string2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = "yyyy-MM-dd";
        }
        if ((n & 2) != 0) {
            string3 = "dd MMM yyyy";
        }
        return FormatUtilsKt.changeDateFormat(string, string2, string3);
    }
}

