package com.appspiriment.androidutils

import android.content.Context
import android.net.ConnectivityManager
import android.net.NetworkCapabilities
import android.os.Build

/**
 * ******************************************
 * Method actionTo check whether the Internet is Connected
 * ******************************************
 */
fun Context.isNetworkConnected(): Boolean {
    val cm = getSystemService(Context.CONNECTIVITY_SERVICE) as ConnectivityManager
    if (Build.VERSION.SDK_INT < 23) {
        cm.activeNetworkInfo?.run {
            return this.isConnected && (this.type == ConnectivityManager.TYPE_WIFI
                    || this.type == ConnectivityManager.TYPE_MOBILE)

        }

    } else {
        cm.getNetworkCapabilities(cm.activeNetwork)?.run {
            return this.hasTransport(NetworkCapabilities.TRANSPORT_CELLULAR) ||
                    this.hasTransport(NetworkCapabilities.TRANSPORT_WIFI) ||
                    this.hasTransport(NetworkCapabilities.TRANSPORT_VPN)
        }
    }
    return false
}