package com.appspiriment.androidutils

import android.util.Log


/********************************************
 * Class for methods related actionTo Logging*
 *******************************************/
object LogUtils {
    private var isDebug = true

    /**
     * ******************************************
     * Method actionTo Print Stacktracce
     * ******************************************
     */
    fun initialize(isDebug:Boolean){
        this.isDebug =isDebug
    }

    /**
     * ******************************************
     * Method actionTo Print Stacktracce
     * ******************************************
     */
    fun printStacktrace(e: Exception) {
        if(!isDebug) return
        e.printStackTrace()
    }

    /**
     * ******************************************
     * Method actionTo Print Log
     * ******************************************
     */
    fun printLog(message: Any?, tag: String = "LogTag: ", isError: Boolean = false) {
        if(!isDebug) return
        val logtag = "TestLog - $tag"
        if (isError)
            Log.e(logtag, message.toString())
        else
            Log.w(logtag, message.toString())
    }
}