/*
 * Decompiled with CFR 0.152.
 */
package com.appspiriment.androidutils;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.os.Build;
import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.common.ANRequest;
import com.androidnetworking.common.Priority;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.JSONArrayRequestListener;
import com.androidnetworking.interfaces.JSONObjectRequestListener;
import com.androidnetworking.interfaces.StringRequestListener;
import com.appspiriment.androidutils.LogUtils;
import com.appspiriment.androidutils.NetworkUtils;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONObject;
import org.koin.core.Koin;
import org.koin.core.KoinComponent;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0081\u0001\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0014\b\u0002\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\b0\f2\u0014\b\u0002\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\b0\f2\u0014\b\u0002\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\b0\f2#\b\u0002\u0010\u0011\u001a\u001d\u0012\u0013\u0012\u00110\u0012\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0015\u0012\u0004\u0012\u00020\b0\f2\b\b\u0002\u0010\u0016\u001a\u00020\u0017H\u0002J\u00f1\u0001\u0010\u0018\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0014\b\u0002\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\b0\f2\u0014\b\u0002\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\b0\f2\u0014\b\u0002\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\b0\f26\u0010\u0019\u001a2\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u001b\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u001c\u0012\u0004\u0012\u00020\b0\u001a28\b\u0002\u0010\u001d\u001a2\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u001b\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u001c\u0012\u0004\u0012\u00020\b0\u001a2#\b\u0002\u0010\u001e\u001a\u001d\u0012\u0013\u0012\u00110\u0012\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0015\u0012\u0004\u0012\u00020\b0\f2\b\b\u0002\u0010\u0016\u001a\u00020\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006 "}, d2={"Lcom/appspiriment/androidutils/NetworkUtils;", "Lorg/koin/core/KoinComponent;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "getContext", "()Landroid/content/Context;", "processApiRequest", "", "url", "", "stringSuccessListener", "Lkotlin/Function1;", "jsonSuccessListener", "Lorg/json/JSONObject;", "jsonArraySuccessListener", "Lorg/json/JSONArray;", "errorObjHandler", "Lcom/androidnetworking/error/ANError;", "Lkotlin/ParameterName;", "name", "error", "requestType", "", "startApiRequest", "errorListen", "Lkotlin/Function2;", "errorCode", "errorDetail", "fallBackListener", "errorLogger", "Companion", "androidutils_release"})
public final class NetworkUtils
implements KoinComponent {
    @NotNull
    private final Context context;
    public static final int API_REQUEST_STRING = 101;
    public static final int API_REQUEST_JSON = 102;
    public static final int API_REQUEST_JSON_ARRAY = 103;
    public static final int API_REQUEST_OBJECT = 104;
    public static final int API_REQUEST_OBJECT_LIST = 105;
    public static final int RESPONSE_NONET = -101;
    public static final int RESPONSE_CUSTOM = -102;
    public static final int RESPONSE_UNKNOWN_CLASS = -103;
    public static final Companion Companion = new Companion(null);

    public final void startApiRequest(@NotNull String url, @NotNull Function1<? super String, Unit> stringSuccessListener, @NotNull Function1<? super JSONObject, Unit> jsonSuccessListener, @NotNull Function1<? super JSONArray, Unit> jsonArraySuccessListener, @NotNull Function2<? super Integer, ? super String, Unit> errorListen, @NotNull Function2<? super Integer, ? super String, Unit> fallBackListener, @NotNull Function1<? super ANError, Unit> errorLogger, int requestType) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull(stringSuccessListener, (String)"stringSuccessListener");
        Intrinsics.checkParameterIsNotNull(jsonSuccessListener, (String)"jsonSuccessListener");
        Intrinsics.checkParameterIsNotNull(jsonArraySuccessListener, (String)"jsonArraySuccessListener");
        Intrinsics.checkParameterIsNotNull(errorListen, (String)"errorListen");
        Intrinsics.checkParameterIsNotNull(fallBackListener, (String)"fallBackListener");
        Intrinsics.checkParameterIsNotNull(errorLogger, (String)"errorLogger");
        Function2 errorHandler2 = (Function2)new Function2<Integer, String, Unit>(fallBackListener, errorListen){
            final /* synthetic */ Function2 $fallBackListener;
            final /* synthetic */ Function2 $errorListen;

            public final void invoke(int code, @NotNull String detail) {
                Intrinsics.checkParameterIsNotNull((Object)detail, (String)"detail");
                int errorCode = code;
                String errorDetail = detail;
                if (errorCode == 0 && Intrinsics.areEqual((Object)errorDetail, (Object)"connectionError")) {
                    errorCode = -101;
                    errorDetail = "No Internet Connection!";
                }
                try {
                    this.$fallBackListener.invoke((Object)errorCode, (Object)errorDetail);
                }
                catch (Exception e) {
                    this.$errorListen.invoke((Object)errorCode, (Object)errorDetail);
                }
            }
            {
                this.$fallBackListener = function2;
                this.$errorListen = function22;
                super(2);
            }
        };
        Function1 errorObjHandler2 = (Function1)new Function1<ANError, Unit>(errorHandler2, errorLogger){
            final /* synthetic */ Function2 $errorHandler;
            final /* synthetic */ Function1 $errorLogger;

            public final void invoke(@NotNull ANError error) {
                String string;
                Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
                ANError aNError = error;
                boolean bl = false;
                boolean bl2 = false;
                ANError $this$run = aNError;
                boolean bl3 = false;
                Integer n = $this$run.getErrorCode();
                String string2 = $this$run.getErrorBody();
                if (string2 == null) {
                    string2 = string = $this$run.getErrorDetail();
                }
                if (string2 == null) {
                    string = "Unexpected Error!";
                }
                this.$errorHandler.invoke((Object)n, (Object)string);
                this.$errorLogger.invoke((Object)$this$run);
            }
            {
                this.$errorHandler = function2;
                this.$errorLogger = function1;
                super(1);
            }
        };
        if (!Companion.isNetworkConnected(this.context)) {
            errorHandler2.invoke((Object)-101, (Object)"No internet connection!");
        } else {
            this.processApiRequest(url, stringSuccessListener, jsonSuccessListener, jsonArraySuccessListener, (Function1<? super ANError, Unit>)errorObjHandler2, requestType);
        }
    }

    public static /* synthetic */ void startApiRequest$default(NetworkUtils networkUtils, String string, Function1 function1, Function1 function12, Function1 function13, Function2 function2, Function2 function22, Function1 function14, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            function1 = startApiRequest.1.INSTANCE;
        }
        if ((n2 & 4) != 0) {
            function12 = startApiRequest.2.INSTANCE;
        }
        if ((n2 & 8) != 0) {
            function13 = startApiRequest.3.INSTANCE;
        }
        if ((n2 & 0x20) != 0) {
            function22 = function2;
        }
        if ((n2 & 0x40) != 0) {
            function14 = startApiRequest.4.INSTANCE;
        }
        if ((n2 & 0x80) != 0) {
            n = 101;
        }
        networkUtils.startApiRequest(string, (Function1<? super String, Unit>)function1, (Function1<? super JSONObject, Unit>)function12, (Function1<? super JSONArray, Unit>)function13, (Function2<? super Integer, ? super String, Unit>)function2, (Function2<? super Integer, ? super String, Unit>)function22, (Function1<? super ANError, Unit>)function14, n);
    }

    private final void processApiRequest(String url, Function1<? super String, Unit> stringSuccessListener, Function1<? super JSONObject, Unit> jsonSuccessListener, Function1<? super JSONArray, Unit> jsonArraySuccessListener, Function1<? super ANError, Unit> errorObjHandler2, int requestType) {
        LogUtils.printLog$default(LogUtils.INSTANCE, " URL   " + url, null, false, 6, null);
        OkHttpClient okHttpClient = new OkHttpClient().newBuilder().connectTimeout(3L, TimeUnit.SECONDS).readTimeout(5L, TimeUnit.SECONDS).writeTimeout(3L, TimeUnit.SECONDS).build();
        ANRequest aNRequest = AndroidNetworking.get((String)url).setPriority(Priority.HIGH).setOkHttpClient(okHttpClient).build();
        boolean bl = false;
        boolean bl2 = false;
        ANRequest $this$apply = aNRequest;
        boolean bl3 = false;
        switch (requestType) {
            case 103: {
                $this$apply.getAsJSONArray(new JSONArrayRequestListener(requestType, jsonArraySuccessListener, errorObjHandler2, jsonSuccessListener, stringSuccessListener){
                    final /* synthetic */ int $requestType$inlined;
                    final /* synthetic */ Function1 $jsonArraySuccessListener$inlined;
                    final /* synthetic */ Function1 $errorObjHandler$inlined;
                    final /* synthetic */ Function1 $jsonSuccessListener$inlined;
                    final /* synthetic */ Function1 $stringSuccessListener$inlined;
                    {
                        this.$requestType$inlined = n;
                        this.$jsonArraySuccessListener$inlined = function1;
                        this.$errorObjHandler$inlined = function12;
                        this.$jsonSuccessListener$inlined = function13;
                        this.$stringSuccessListener$inlined = function14;
                    }

                    public void onResponse(@NotNull JSONArray response) {
                        Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
                        this.$jsonArraySuccessListener$inlined.invoke((Object)response);
                    }

                    public void onError(@NotNull ANError error) {
                        Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
                        this.$errorObjHandler$inlined.invoke((Object)error);
                    }
                });
                break;
            }
            case 102: {
                $this$apply.getAsJSONObject(new JSONObjectRequestListener(requestType, jsonArraySuccessListener, errorObjHandler2, jsonSuccessListener, stringSuccessListener){
                    final /* synthetic */ int $requestType$inlined;
                    final /* synthetic */ Function1 $jsonArraySuccessListener$inlined;
                    final /* synthetic */ Function1 $errorObjHandler$inlined;
                    final /* synthetic */ Function1 $jsonSuccessListener$inlined;
                    final /* synthetic */ Function1 $stringSuccessListener$inlined;
                    {
                        this.$requestType$inlined = n;
                        this.$jsonArraySuccessListener$inlined = function1;
                        this.$errorObjHandler$inlined = function12;
                        this.$jsonSuccessListener$inlined = function13;
                        this.$stringSuccessListener$inlined = function14;
                    }

                    public void onResponse(@NotNull JSONObject response) {
                        Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
                        this.$jsonSuccessListener$inlined.invoke((Object)response);
                    }

                    public void onError(@NotNull ANError error) {
                        Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
                        this.$errorObjHandler$inlined.invoke((Object)error);
                    }
                });
                break;
            }
            default: {
                $this$apply.getAsString(new StringRequestListener(requestType, jsonArraySuccessListener, errorObjHandler2, jsonSuccessListener, stringSuccessListener){
                    final /* synthetic */ int $requestType$inlined;
                    final /* synthetic */ Function1 $jsonArraySuccessListener$inlined;
                    final /* synthetic */ Function1 $errorObjHandler$inlined;
                    final /* synthetic */ Function1 $jsonSuccessListener$inlined;
                    final /* synthetic */ Function1 $stringSuccessListener$inlined;
                    {
                        this.$requestType$inlined = n;
                        this.$jsonArraySuccessListener$inlined = function1;
                        this.$errorObjHandler$inlined = function12;
                        this.$jsonSuccessListener$inlined = function13;
                        this.$stringSuccessListener$inlined = function14;
                    }

                    public void onResponse(@NotNull String response) {
                        Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
                        this.$stringSuccessListener$inlined.invoke((Object)response);
                    }

                    public void onError(@NotNull ANError error) {
                        Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
                        this.$errorObjHandler$inlined.invoke((Object)error);
                    }
                });
            }
        }
    }

    static /* synthetic */ void processApiRequest$default(NetworkUtils networkUtils, String string, Function1 function1, Function1 function12, Function1 function13, Function1 function14, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            function1 = processApiRequest.1.INSTANCE;
        }
        if ((n2 & 4) != 0) {
            function12 = processApiRequest.2.INSTANCE;
        }
        if ((n2 & 8) != 0) {
            function13 = processApiRequest.3.INSTANCE;
        }
        if ((n2 & 0x10) != 0) {
            function14 = processApiRequest.4.INSTANCE;
        }
        if ((n2 & 0x20) != 0) {
            n = 101;
        }
        networkUtils.processApiRequest(string, (Function1<? super String, Unit>)function1, (Function1<? super JSONObject, Unit>)function12, (Function1<? super JSONArray, Unit>)function13, (Function1<? super ANError, Unit>)function14, n);
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    public NetworkUtils(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
        AndroidNetworking.initialize((Context)this.context);
    }

    @NotNull
    public Koin getKoin() {
        return KoinComponent.DefaultImpls.getKoin((KoinComponent)this);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/appspiriment/androidutils/NetworkUtils$Companion;", "", "()V", "API_REQUEST_JSON", "", "API_REQUEST_JSON_ARRAY", "API_REQUEST_OBJECT", "API_REQUEST_OBJECT_LIST", "API_REQUEST_STRING", "RESPONSE_CUSTOM", "RESPONSE_NONET", "RESPONSE_UNKNOWN_CLASS", "isNetworkConnected", "", "context", "Landroid/content/Context;", "androidutils_release"})
    public static final class Companion {
        public final boolean isNetworkConnected(@NotNull Context context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Object object = context.getSystemService("connectivity");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.net.ConnectivityManager");
            }
            ConnectivityManager cm = (ConnectivityManager)object;
            if (Build.VERSION.SDK_INT < 23) {
                NetworkInfo networkInfo = cm.getActiveNetworkInfo();
                if (networkInfo != null) {
                    NetworkInfo networkInfo2 = networkInfo;
                    boolean bl = false;
                    boolean bl2 = false;
                    NetworkInfo $this$run = networkInfo2;
                    boolean bl3 = false;
                    return $this$run.isConnected() && ($this$run.getType() == 1 || $this$run.getType() == 0);
                }
            } else {
                NetworkCapabilities networkCapabilities = cm.getNetworkCapabilities(cm.getActiveNetwork());
                if (networkCapabilities != null) {
                    NetworkCapabilities networkCapabilities2 = networkCapabilities;
                    boolean bl = false;
                    boolean bl4 = false;
                    NetworkCapabilities $this$run = networkCapabilities2;
                    boolean bl5 = false;
                    return $this$run.hasTransport(0) || $this$run.hasTransport(1) || $this$run.hasTransport(4);
                }
            }
            return false;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

