/*
 * Decompiled with CFR 0.152.
 */
package com.appsng.multiplecontactselection;

import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.Context;
import android.content.SharedPreferences;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.provider.ContactsContract;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.TextView;
import com.appsng.multiplecontactselection.Contact;
import com.appsng.multiplecontactselection.R;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class ContactAdapter
extends BaseAdapter {
    private Context context;
    SharedPreferences sharedPref;
    ArrayList<Contact> contacts = new ArrayList();
    boolean showCheckBox = false;

    public ContactAdapter(Context cont, ArrayList<Contact> contacts, boolean showCheckBox) {
        this.context = cont;
        this.contacts = contacts;
        this.showCheckBox = showCheckBox;
    }

    public int getCount() {
        return this.contacts.size();
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder holder = null;
        if (convertView == null) {
            holder = new ViewHolder();
            LayoutInflater inflater = (LayoutInflater)this.context.getSystemService("layout_inflater");
            convertView = inflater.inflate(R.layout.adapter_contacts, null);
            holder.avatar = (ImageView)convertView.findViewById(R.id.img_contact);
            holder.phone = (TextView)convertView.findViewById(R.id.phone);
            holder.name = (TextView)convertView.findViewById(R.id.name);
            holder.checkbox = (CheckBox)convertView.findViewById(R.id.check);
            holder.checkbox.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

                public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                    int getPosition = (Integer)buttonView.getTag();
                    ContactAdapter.this.contacts.get(getPosition).setSelected(buttonView.isChecked());
                }
            });
            convertView.setTag((Object)holder);
            convertView.setTag(R.id.check, (Object)holder.checkbox);
            convertView.setTag((Object)holder);
        } else {
            holder = (ViewHolder)convertView.getTag();
        }
        holder.checkbox.setTag((Object)position);
        if (this.showCheckBox) {
            holder.checkbox.setVisibility(0);
        } else {
            holder.checkbox.setVisibility(8);
        }
        holder.phone.setText((CharSequence)this.contacts.get(position).getPhoneNo());
        holder.name.setText((CharSequence)this.contacts.get(position).getName());
        try {
            Bitmap photo = ContactAdapter.retrieveContactPhoto(this.contacts.get(position).getContactId(), this.context);
            if (photo != null) {
                holder.avatar.setImageBitmap(photo);
            } else {
                holder.avatar.setImageResource(R.mipmap.user);
            }
        }
        catch (Exception e) {
            holder.avatar.setImageResource(R.mipmap.user);
            e.printStackTrace();
        }
        holder.checkbox.setChecked(this.contacts.get(position).getSelected());
        return convertView;
    }

    public Object getItem(int position) {
        return null;
    }

    public long getItemId(int position) {
        return 0L;
    }

    public int getItemViewType(int position) {
        return super.getItemViewType(position);
    }

    public static Bitmap retrieveContactPhoto(String contactID, Context context) throws IOException {
        Bitmap photo = null;
        InputStream inputStream = ContactsContract.Contacts.openContactPhotoInputStream((ContentResolver)context.getContentResolver(), (Uri)ContentUris.withAppendedId((Uri)ContactsContract.Contacts.CONTENT_URI, (long)Long.valueOf(contactID)));
        if (inputStream != null) {
            photo = BitmapFactory.decodeStream((InputStream)inputStream);
            return photo;
        }
        return photo;
    }

    class ViewHolder {
        ImageView avatar;
        TextView phone;
        TextView name;
        CheckBox checkbox;

        ViewHolder() {
        }
    }
}

