/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.android.installreferrer.api.InstallReferrerClient;
import com.android.installreferrer.api.InstallReferrerStateListener;
import com.appsflyer.AFLogger;
import com.appsflyer.internal.AFc1kSDK;
import com.appsflyer.internal.AFh1ySDK;
import com.appsflyer.internal.AFi1bSDK;
import com.appsflyer.internal.AFj1jSDK;
import com.appsflyer.internal.AFj1tSDK;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.ExecutorService;

public class AFi1cSDK
extends AFi1bSDK {
    public final Map<String, Object> getMonetizationNetwork = new HashMap<String, Object>();
    @NonNull
    final ExecutorService getCurrencyIso4217Code;

    public AFi1cSDK(@NonNull Runnable runnable, @NonNull ExecutorService executorService, @NonNull AFc1kSDK aFc1kSDK) {
        super("store", "google", aFc1kSDK, runnable);
        this.getCurrencyIso4217Code = executorService;
    }

    private boolean getMonetizationNetwork(@NonNull Context context) {
        if (!this.getCurrencyIso4217Code()) {
            return false;
        }
        String string = "com.android.installreferrer.api.InstallReferrerClient";
        try {
            Class.forName(string);
            if (AFj1jSDK.getRevenue(context, "com.google.android.finsky.permission.BIND_GET_INSTALL_REFERRER_SERVICE")) {
                AFLogger.INSTANCE.d(AFh1ySDK.equals, "Install referrer is allowed");
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            AFLogger.afErrorLogForExcManagerOnly("InstallReferrerClient not found", classNotFoundException);
            AFLogger.INSTANCE.v(AFh1ySDK.equals, "Class " + string + " not found");
            return false;
        }
        catch (Throwable throwable) {
            AFLogger.INSTANCE.e(AFh1ySDK.equals, "An error occurred while trying to verify manifest : ".concat(String.valueOf(string)), throwable);
            return false;
        }
        AFLogger.INSTANCE.d(AFh1ySDK.equals, "Install referrer is not allowed");
        return false;
    }

    @Override
    public final void AFAdRevenueData(Context context) {
        if (!this.getMonetizationNetwork(context)) {
            return;
        }
        AFi1cSDK aFi1cSDK = this;
        this.component4 = System.currentTimeMillis();
        aFi1cSDK.areAllFieldsValid = AFj1tSDK.AFa1ySDK.getMediationNetwork;
        aFi1cSDK.addObserver(new Observer(aFi1cSDK){
            private /* synthetic */ AFj1tSDK getCurrencyIso4217Code;
            {
                this.getCurrencyIso4217Code = aFj1tSDK;
            }

            public final void update(Observable o, Object arg) {
                this.getCurrencyIso4217Code.getRevenue.run();
            }
        });
        try {
            aFi1cSDK = InstallReferrerClient.newBuilder((Context)context).build();
            AFLogger.INSTANCE.d(AFh1ySDK.equals, "Connecting to Install Referrer Library...");
            aFi1cSDK.startConnection(new InstallReferrerStateListener(){
                final /* synthetic */ InstallReferrerClient val$referrerClient;
                final /* synthetic */ Context val$context;
                {
                    this.val$referrerClient = installReferrerClient;
                    this.val$context = context;
                }

                public final void onInstallReferrerSetupFinished(int responseCode) {
                    AFi1cSDK.this.getCurrencyIso4217Code.execute(() -> AFi1cSDK.this.getMonetizationNetwork(this.val$referrerClient, this.val$context, responseCode));
                }

                public final void onInstallReferrerServiceDisconnected() {
                    AFLogger.INSTANCE.d(AFh1ySDK.equals, "Install Referrer service disconnected");
                }
            });
            return;
        }
        catch (Throwable throwable) {
            AFLogger.INSTANCE.e(AFh1ySDK.equals, "referrerClient -> startConnection", throwable);
            return;
        }
    }

    @WorkerThread
    @VisibleForTesting
    protected final void getMonetizationNetwork(InstallReferrerClient installReferrerClient, Context referrerDetails, int n) {
        this.getMonetizationNetwork.put("code", String.valueOf(n));
        String string = "com.android.vending";
        referrerDetails = AFj1jSDK.AFAdRevenueData((Context)referrerDetails, string);
        this.getMediationNetwork.put("api_ver", referrerDetails.getFirst());
        this.getMediationNetwork.put("api_ver_name", referrerDetails.getSecond());
        switch (n) {
            case 0: {
                this.getMediationNetwork.put("response", "OK");
                try {
                    AFLogger.INSTANCE.d(AFh1ySDK.equals, "InstallReferrer connected");
                    if (installReferrerClient.isReady()) {
                        referrerDetails = installReferrerClient.getInstallReferrer();
                        Object object = referrerDetails.getInstallReferrer();
                        if (object != null) {
                            this.getMonetizationNetwork.put("val", object);
                            this.getMediationNetwork.put("referrer", object);
                        }
                        long l = referrerDetails.getReferrerClickTimestampSeconds();
                        this.getMonetizationNetwork.put("clk", Long.toString(l));
                        this.getMediationNetwork.put("click_ts", l);
                        long l2 = referrerDetails.getInstallBeginTimestampSeconds();
                        this.getMonetizationNetwork.put("install", Long.toString(l2));
                        this.getMediationNetwork.put("install_begin_ts", l2);
                        object = new HashMap();
                        try {
                            boolean bl = referrerDetails.getGooglePlayInstantParam();
                            this.getMonetizationNetwork.put("instant", bl);
                            ((AbstractMap)object).put("instant", bl);
                        }
                        catch (NoSuchMethodError noSuchMethodError) {
                            AFLogger.afErrorLogForExcManagerOnly("getGooglePlayInstantParam not exist", noSuchMethodError);
                        }
                        try {
                            ((AbstractMap)object).put("click_server_ts", referrerDetails.getReferrerClickTimestampServerSeconds());
                            ((AbstractMap)object).put("install_begin_server_ts", referrerDetails.getInstallBeginTimestampServerSeconds());
                            ((AbstractMap)object).put("install_version", referrerDetails.getInstallVersion());
                        }
                        catch (NoSuchMethodError noSuchMethodError) {
                            AFLogger.INSTANCE.e(AFh1ySDK.equals, "some method not exist", noSuchMethodError, false, false);
                        }
                        if (!((AbstractMap)object).isEmpty()) {
                            this.getMediationNetwork.put("google_custom", object);
                        }
                        installReferrerClient.endConnection();
                        break;
                    }
                    AFLogger.INSTANCE.w(AFh1ySDK.equals, "ReferrerClient: InstallReferrer is not ready");
                    this.getMonetizationNetwork.put("err", "ReferrerClient: InstallReferrer is not ready");
                }
                catch (Throwable throwable) {
                    AFLogger.INSTANCE.w(AFh1ySDK.equals, "Failed to get install referrer: " + throwable.getMessage());
                    this.getMonetizationNetwork.put("err", throwable.getMessage());
                    AFLogger.INSTANCE.e(AFh1ySDK.equals, "Failed to get install referrer", throwable, false, false);
                }
                break;
            }
            case 2: {
                AFLogger.INSTANCE.w(AFh1ySDK.equals, "InstallReferrer FEATURE_NOT_SUPPORTED");
                this.getMediationNetwork.put("response", "FEATURE_NOT_SUPPORTED");
                break;
            }
            case 1: {
                this.getMediationNetwork.put("response", "SERVICE_UNAVAILABLE");
                AFLogger.INSTANCE.w(AFh1ySDK.equals, "InstallReferrer not supported");
                break;
            }
            case 3: {
                AFLogger.INSTANCE.w(AFh1ySDK.equals, "InstallReferrer DEVELOPER_ERROR");
                this.getMediationNetwork.put("response", "DEVELOPER_ERROR");
                break;
            }
            case -1: {
                AFLogger.INSTANCE.w(AFh1ySDK.equals, "InstallReferrer SERVICE_DISCONNECTED");
                this.getMediationNetwork.put("response", "SERVICE_DISCONNECTED");
                break;
            }
            default: {
                AFLogger.INSTANCE.w(AFh1ySDK.equals, "responseCode not found.");
            }
        }
        AFLogger.INSTANCE.d(AFh1ySDK.equals, "Install Referrer collected locally");
        this.getRevenue();
    }
}

